package com.aircert.util;

import com.xdja.log.LogModule;
import com.xdja.log.XdjaLog;

import java.io.File;
import java.io.IOException;

/**
 * logcat util
 * Created by xingjianqiang on 2018/12/1.
 */

public class LogcatUtil {
    private static final String THIS_FILE = "LogcatUtil";

    private static String filePath = LogModule.getRootPath() + File.separator + "logcat" + File.separator;
    private static File logFile = null;
    private static Process process = null;
    private static boolean running = false;

    public static String getFilePath() {
        return filePath;
    }

    public static void setFilePath(String path) {
        filePath = path;
    }

    public static Process getProcess() {
        return process;
    }

    public static void setProcess(Process process) {
        LogcatUtil.process = process;
    }

    public static File getLogFile() {
        return logFile;
    }

    public static void setLogFile(File logFile) {
        LogcatUtil.logFile = logFile;
    }

    // 清除4天前保存的logcat日志
    public static void cleanHistory() {
        FileUtil.deleteFilesBefore(filePath, 4*24*60*60*1000);
    }

    public static boolean startCapture() {
        if (running) {
            XdjaLog.d(THIS_FILE, "Loggcat capture is already running");
            return true;
        }
        File path = new File(filePath);
        if (!path.exists()) {
            path.mkdirs();
        }

        logFile = new File(path, "logcat_tmp.log");
        try {
            process = Runtime.getRuntime().exec( "logcat -c");
            process = Runtime.getRuntime().exec( "logcat -f " + logFile);
        } catch (IOException e) {
            XdjaLog.e(THIS_FILE, "Trye to capture app logcat failed. IO exception");
            e.printStackTrace();
            return false;
        }
        running = true;
        return true;
    }

    /**
     * 继续抓取日志，使用同样的文件
     * @return
     */
    public static boolean resumeCapture() {
        if (logFile != null) {
            try {
                process = Runtime.getRuntime().exec( "logcat -c");
                process = Runtime.getRuntime().exec( "logcat -f " + logFile);
            } catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }

        return true;
    }

    public static void stopCapture() {
        if (process != null) {
            process.destroy();
        }
        logFile = null;
        running = false;
    }
}
