/*
 * Decompiled with CFR 0.152.
 */
package com.aircert;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.Nullable;
import com.aircert.util.LogcatUtil;
import com.xdja.log.LogModule;
import com.xdja.log.XdjaLog;
import java.io.File;

public class LogcatService
extends Service {
    private static final String THIS_FILE = "LogcatService";
    private boolean stop = false;
    private int maxFileCount = 4;
    private long maxFileSize = 0x2000000L;
    private static final String BACKUP_PREFIX = "log_backup_";

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    private void backupLogFile(File logFile) {
        int index;
        String logPath = LogcatUtil.getFilePath();
        if (!new File(logPath).exists()) {
            XdjaLog.e((String)THIS_FILE, (String)"Error!! Log file path not exists");
            return;
        }
        for (index = 0; index < this.maxFileCount; ++index) {
            String backupName = logPath + BACKUP_PREFIX + index + ".log";
            File file = new File(backupName);
            if (file.exists()) continue;
            XdjaLog.d((String)THIS_FILE, (String)("Backup file " + logFile.getAbsolutePath() + "  to  " + backupName));
            logFile.renameTo(file);
            return;
        }
        XdjaLog.d((String)THIS_FILE, (String)"Backup file is full. Delete first and rename current log file");
        String firstBackupName = logPath + BACKUP_PREFIX + "0.log";
        File firtFile = new File(firstBackupName);
        firtFile.delete();
        for (index = 1; index < this.maxFileCount; ++index) {
            String backupName = logPath + BACKUP_PREFIX + index + ".log";
            File file = new File(backupName);
            file.renameTo(new File(logPath + BACKUP_PREFIX + (index - 1) + ".log"));
        }
        String currentBackupName = logPath + BACKUP_PREFIX + (this.maxFileCount - 1) + ".log";
        logFile.renameTo(new File(currentBackupName));
    }

    public void onCreate() {
        LogcatUtil.setFilePath(LogModule.getRootPath() + File.separator + "logcat" + File.separator);
        LogcatUtil.cleanHistory();
        boolean success = LogcatUtil.startCapture();
        if (!success) {
            XdjaLog.e((String)THIS_FILE, (String)"Error to start capture logcat!");
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!LogcatService.this.stop) {
                        File logFile = LogcatUtil.getLogFile();
                        if (logFile.length() >= LogcatService.this.maxFileSize) {
                            LogcatUtil.stopCapture();
                            XdjaLog.d((String)LogcatService.THIS_FILE, (String)"Log file size exceed! Backup file");
                            LogcatService.this.backupLogFile(logFile);
                            LogcatUtil.startCapture();
                        }
                        Process process = LogcatUtil.getProcess();
                        boolean isAlive = false;
                        try {
                            int exitValue = process.exitValue();
                            if (exitValue != 0) {
                                isAlive = false;
                            }
                        }
                        catch (IllegalThreadStateException e) {
                            isAlive = true;
                        }
                        if (!isAlive) {
                            XdjaLog.e((String)LogcatService.THIS_FILE, (String)"Logcat thread died!!!");
                            LogcatUtil.resumeCapture();
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    XdjaLog.d((String)LogcatService.THIS_FILE, (String)"Logcat thread normal stop!!!");
                }
            }).start();
        }
        super.onCreate();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }

    public void onDestroy() {
        this.stop = true;
        LogcatUtil.stopCapture();
        super.onDestroy();
    }
}

