/*
 * Decompiled with CFR 0.152.
 */
package com.aircert;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.aircert.listener.OnPermissionListener;
import com.aircert.listener.RationaleListener;
import java.util.ArrayList;

public class SPermission {
    private SPermission sPermission = null;
    public static final int CHECK_ONCE = 1;
    public static final int CHECK_ALWAYS = 2;
    private int MOUDLE = 1;
    private int mRequestCode = -1;
    private OnPermissionListener mOnPermissionListener;
    private RationaleListener rationaleListener;
    private Context context;
    private String[] permissions;
    private boolean isActive = true;
    private boolean isDialogShow = false;

    @TargetApi(value=23)
    public void requestPermissionsAgain() {
        if (!(this.context instanceof Activity)) {
            throw new IllegalArgumentException("Context must be an Activity");
        }
        ((Activity)this.context).requestPermissions(this.permissions, this.mRequestCode);
    }

    @TargetApi(value=23)
    public void requestPermissions() {
        if (Build.VERSION.SDK_INT < 23) {
            this.callbackSucceed();
            return;
        }
        if (this.rationaleListener != null) {
            boolean rationale = false;
            String p = null;
            for (String permission : this.permissions) {
                rationale = ((Activity)this.context).shouldShowRequestPermissionRationale(permission);
                if (!rationale) continue;
                p = permission;
                break;
            }
            if (this.isDialogShow) {
                return;
            }
            if (p != null && this.isActive) {
                this.rationaleListener.onRationaleResult(p);
                this.setDialogShow(true);
                this.rationaleListener = null;
                return;
            }
        }
        if (!this.isActive) {
            return;
        }
        String[] deniedPermissions = this.getDeniedPermissions(this.context, this.permissions);
        if (deniedPermissions.length > 0 && Build.VERSION.SDK_INT >= 23) {
            this.requestPermissionsAgain();
        } else if (this.mOnPermissionListener != null) {
            this.mOnPermissionListener.onPermissionGranted();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, int[] grantResults) {
        if (this.sPermission != null) {
            this.sPermission.onRequestPermissionsResult(requestCode, permissions);
        }
    }

    public void activeSPermission() {
        if (!this.isDialogShow) {
            this.setActive(true);
        }
    }

    private void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions) {
        if (this.mRequestCode != -1 && requestCode == this.mRequestCode && this.mOnPermissionListener != null) {
            String[] deniedPermissions = this.getDeniedPermissions(this.context, permissions);
            if (deniedPermissions.length > 0) {
                boolean alwaysDenied = this.hasAlwaysDeniedPermission(this.context, permissions);
                if (alwaysDenied) {
                    if (this.MOUDLE == 2) {
                        this.isActive = false;
                    }
                    this.mOnPermissionListener.onPermissionDeniedAlways(deniedPermissions);
                    return;
                }
                if (this.MOUDLE == 2) {
                    this.isActive = false;
                }
                this.mOnPermissionListener.onPermissionDenied(deniedPermissions);
            } else {
                this.mOnPermissionListener.onPermissionGranted();
            }
        }
    }

    private void callbackSucceed() {
        if (this.mOnPermissionListener != null) {
            this.mOnPermissionListener.onPermissionGranted();
        }
    }

    private String[] getDeniedPermissions(@NonNull Context context, @NonNull String[] permissions) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)permission) != -1) continue;
            deniedPermissions.add(permission);
        }
        return deniedPermissions.toArray(new String[deniedPermissions.size()]);
    }

    private boolean hasAlwaysDeniedPermission(@NonNull Context context, String ... deniedPermissions) {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        for (String permission : deniedPermissions) {
            boolean rationale = ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)context), (String)permission);
            if (rationale) continue;
            return true;
        }
        return false;
    }

    private void setActive(boolean active) {
        this.isActive = active;
    }

    public void setDialogShow(boolean dialogShow) {
        this.isDialogShow = dialogShow;
    }

    public SPermission getsPermission() {
        return this.sPermission;
    }

    public SPermission setmOnPermissionListener(OnPermissionListener mOnPermissionListener) {
        this.mOnPermissionListener = mOnPermissionListener;
        return this;
    }

    public SPermission setRationaleListener(RationaleListener rationaleListener) {
        this.rationaleListener = rationaleListener;
        return this;
    }

    public SPermission setmRequestCode(int mRequestCode) {
        this.mRequestCode = mRequestCode;
        return this;
    }

    public SPermission setPermissions(String[] permissions) {
        this.permissions = permissions;
        return this;
    }

    public SPermission setMOUDLE(int MOUDLE) {
        if (MOUDLE != 1 && MOUDLE != 2) {
            throw new IllegalArgumentException("Invalid moudle");
        }
        this.MOUDLE = MOUDLE;
        return this;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public SPermission(Context context) {
        this.context = context;
    }

    public void setsPermission(SPermission sPermission) {
        this.sPermission = sPermission;
    }
}

