/*
 * Decompiled with CFR 0.152.
 */
package com.aircert.dialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.StringRes;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.xdja.aircert.common.R;

public class BindIdentifyDialog
extends Dialog {
    TextView tv_title;
    TextView tv_content;
    EditText et_content;
    TextView pin_tips;
    Button btn_negative;
    Button btn_positive;
    private String message;
    private String title;
    private String positiveButtonText;
    private String negativeButtonText;
    private Context context;
    private ClickListenerInterface clickListenerInterface;
    public static final int DEFAULT_MODEL = 1;
    public static final int MID_MODEL = 2;
    public static final int PIN_MODEL = 3;
    private int model = 1;

    public void setModel(int model) {
        this.model = model;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMessage(@StringRes int message) {
        this.message = this.context.getString(message);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTitle(@StringRes int title) {
        this.title = this.context.getString(title);
    }

    public void setPositiveButtonText(String positiveButtonText) {
        this.positiveButtonText = positiveButtonText;
    }

    public void setNegativeButtonText(String negativeButtonText) {
        this.negativeButtonText = negativeButtonText;
    }

    public void setPositiveButtonText(@StringRes int positiveButtonText) {
        this.positiveButtonText = this.context.getString(positiveButtonText);
    }

    public void setNegativeButtonText(@StringRes int negativeButtonText) {
        this.negativeButtonText = this.context.getString(negativeButtonText);
    }

    public BindIdentifyDialog(Context context) {
        super(context, R.style.Theme_AppCompat_Dialog);
        this.context = context;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        if (this.model == 2) {
            this.setContentView(R.layout.dialog_bind_identify_middle);
        } else if (this.model == 1) {
            this.setContentView(R.layout.dialog_bind_identify);
        } else if (this.model == 3) {
            this.setContentView(R.layout.pin_dialog_layout);
        }
        this.tv_title = (TextView)this.findViewById(R.id.tv_title);
        this.tv_content = (TextView)this.findViewById(R.id.tv_content);
        this.btn_negative = (Button)this.findViewById(R.id.btn_negative);
        this.btn_positive = (Button)this.findViewById(R.id.btn_positive);
        this.tv_title.setText((CharSequence)this.title);
        if (TextUtils.isEmpty((CharSequence)this.message) && this.tv_content != null && this.message.contains("<br>")) {
            this.tv_content.setLineSpacing(0.0f, 1.0f);
        }
        if (this.tv_content != null) {
            this.tv_content.setText((CharSequence)Html.fromHtml((String)this.message));
        }
        this.et_content = (EditText)this.findViewById(R.id.et_content);
        if (this.et_content != null) {
            this.pin_tips = (TextView)this.findViewById(R.id.tv_pin_code_tip);
        }
        this.btn_negative.setText((CharSequence)this.negativeButtonText);
        this.btn_positive.setText((CharSequence)this.positiveButtonText);
        this.btn_negative.setOnClickListener((View.OnClickListener)new clickListener());
        this.btn_positive.setOnClickListener((View.OnClickListener)new clickListener());
    }

    public String getPinCode() {
        return this.et_content.getText().toString();
    }

    public void clearPin() {
        if (this.et_content != null) {
            this.et_content.setText((CharSequence)"");
        }
        if (this.pin_tips != null) {
            this.pin_tips.setText((CharSequence)"");
        }
    }

    public void showPinTips(String tips) {
        this.pin_tips.setText((CharSequence)tips);
        this.pin_tips.setVisibility(0);
    }

    public void setClickListener(ClickListenerInterface clickListener2) {
        this.clickListenerInterface = clickListener2;
    }

    private class clickListener
    implements View.OnClickListener {
        private clickListener() {
        }

        public void onClick(View v) {
            int id2 = v.getId();
            if (id2 == R.id.btn_negative) {
                BindIdentifyDialog.this.clickListenerInterface.doCancel();
            } else if (id2 == R.id.btn_positive) {
                BindIdentifyDialog.this.clickListenerInterface.doConfirm();
            }
        }
    }

    public static interface ClickListenerInterface {
        public void doConfirm();

        public void doCancel();
    }
}

