/*
 * Decompiled with CFR 0.152.
 */
package com.aircert.dialog;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.aircert.dialog.BindIdentifyDialog;
import com.xdja.aircert.common.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class SinglePermissionDialog {
    public static final int PERMISSION_PHONE = 0;
    public static final int PERMISSION_STORAGE_TAKE_PHOTO = 1;
    public static final int PERMISSION_TAKE_PHOTO = 2;
    int permission;
    BindIdentifyDialog dialog;
    OnClickListener listener;

    public SinglePermissionDialog setListener(OnClickListener listener) {
        this.listener = listener;
        return this;
    }

    public BindIdentifyDialog build(final Context context, String message) {
        this.permission = this.permission;
        this.dialog = new BindIdentifyDialog(context);
        this.dialog.setTitle(R.string.verify_permission_title);
        this.dialog.setMessage(message);
        this.dialog.setModel(2);
        this.dialog.setNegativeButtonText(R.string.refuse);
        this.dialog.setPositiveButtonText(R.string.acu_can_not_open_power_right_button);
        this.dialog.setCancelable(false);
        this.dialog.setCanceledOnTouchOutside(false);
        this.dialog.show();
        this.dialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            @Override
            public void doConfirm() {
                SinglePermissionDialog.this.dialog.dismiss();
                if (SinglePermissionDialog.this.listener != null) {
                    SinglePermissionDialog.this.listener.onPositive();
                } else {
                    SinglePermissionDialog.this.gotoSetting(context);
                }
            }

            @Override
            public void doCancel() {
                SinglePermissionDialog.this.dialog.dismiss();
            }
        });
        return this.dialog;
    }

    public BindIdentifyDialog build(Context context, int permission) {
        return this.build(context, context.getString(R.string.permission_content, new Object[]{context.getString(this.getPermissionMessage(permission))}));
    }

    public void show() {
        this.dialog.show();
    }

    private int getPermissionMessage(int permission) {
        if (permission == 0) {
            return R.string.permission_phone;
        }
        if (permission == 1) {
            return R.string.permission_storage_take_photo;
        }
        if (permission == 2) {
            return R.string.permission_take_photo;
        }
        return 0;
    }

    private void gotoSetting(Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
        intent.setData(uri);
        context.startActivity(intent);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PermissionType {
    }

    public static interface OnClickListener {
        public void onPositive();
    }
}

