/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev.driver;

import android.util.Log;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.driver.DriverDevChangedListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class IDevDriver {
    private static final String THIS_FILE = "IDevDriver";
    protected Vector<CryptoDevInfo> devInfos = new Vector();
    protected ArrayList<CryptoInstance> cryptoDevs = new ArrayList();
    protected ArrayList<DriverDevChangedListener> devChangedListeners = new ArrayList();

    public abstract String getDriverName();

    public abstract int init();

    public int refresh() {
        for (DriverDevChangedListener listener : this.devChangedListeners) {
            listener.onDevChanged(this);
        }
        return 0;
    }

    public abstract CryptoInstance createInstance(CryptoDevInfo var1);

    public final void registerDevChangedListener(DriverDevChangedListener listener) {
        this.devChangedListeners.add(listener);
    }

    public final void unregisterDevChangedListener(DriverDevChangedListener listener) {
        this.devChangedListeners.remove(listener);
    }

    public void destroy() {
        this.devInfos.clear();
        for (CryptoInstance cryptoDev : this.cryptoDevs) {
            cryptoDev.close();
        }
        this.cryptoDevs.clear();
    }

    public List<CryptoDevInfo> getDevList() {
        return this.devInfos;
    }

    public List<CryptoInstance> getCryptoList() {
        return this.cryptoDevs;
    }

    public CryptoInstance getInstance(CryptoDevInfo devInfo) {
        Log.d((String)THIS_FILE, (String)("Try to get instance " + devInfo));
        for (CryptoInstance dev : this.cryptoDevs) {
            if (!devInfo.getCardId().equals(dev.getDevInfo().getCardId())) continue;
            Log.d((String)THIS_FILE, (String)"Instance already created. Just add ref and return it ");
            dev.addRef();
            return dev;
        }
        Log.d((String)THIS_FILE, (String)"Need to create new instance");
        CryptoInstance dev = this.createInstance(devInfo);
        if (dev != null) {
            dev.addRef();
        }
        return dev;
    }
}

