/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev.driver.chipmanager;

import android.content.Context;
import android.util.Pair;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_RSA_PRIKEY;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.devapi.RSAPrikey;
import com.xdja.cryptodev.devapi.RSAPubkey;
import com.xdja.cryptodev.devapi.SM2Prikey;
import com.xdja.cryptodev.devapi.SM2Pubkey;
import com.xdja.cryptodev.driver.IDevDriver;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerError;
import com.xdja.cryptodev.driver.xdja.XdjaError;
import com.xdja.cryptodev.driver.xdja.XdjaKey;
import com.xdja.cryptodev.error.SysError;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarJniApiProxyExtra;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.param.CertBean;

public class ChipManagerKey
extends CryptoInstance {
    private Context context = null;
    private JarMultiJniApiManager jniApiManager = JarMultiJniApiManager.getInstance();
    private JarJniApiProxy jarJniApiProxy;
    private static final String THIS_FILE = "ChipManagerKey";
    private static final int ERROR_FROM_CM_BEGIN = -11000;
    private static final int ERROR_FROM_CM_END = -9999;

    public ChipManagerKey(IDevDriver driver, CryptoDevInfo devInfo) {
        super(driver, devInfo);
        this.context = CryptoDevManager.getInstance().getContext();
    }

    @Override
    public int open() {
        Pair jniProxyPair = this.jniApiManager.make(this.context, this.devInfo.getCardId());
        if ((Integer)jniProxyPair.first == 0) {
            this.jarJniApiProxy = (JarJniApiProxy)jniProxyPair.second;
            return 0;
        }
        return ChipManagerKey.ERROR_COVERT((Integer)jniProxyPair.first);
    }

    @Override
    public int close() {
        return 0;
    }

    @Override
    public int reset() {
        return 0;
    }

    @Override
    public int lock() {
        int ret = this.jarJniApiProxy.LockDev();
        return 0;
    }

    @Override
    public int unlock() {
        int ret = this.jarJniApiProxy.UnlockDev();
        return 0;
    }

    @Override
    public int verifyPIN(String pin, int role) {
        int ret = this.jarJniApiProxy.VerifyPIN(role, pin.getBytes(), pin.length());
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int getPINTryCount(int role) {
        return this.jarJniApiProxy.GetPinTryCount(role);
    }

    @Override
    public int readCert(byte[] fid, byte[] cert, int[] certLen) {
        int ret = this.jarJniApiProxy.ReadCert(fid, cert, certLen);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int RSAPrikeyCalc(byte[] prikeyFid, byte[] dataInput, int dataInputLen, byte[] dataOut, int[] dataOutLen) {
        int ret = this.jarJniApiProxy.RSAPriKeyCalc(prikeyFid, dataInput, dataInputLen, dataOut, dataOutLen);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int RSAPubkeyCalc(byte[] pubkeyFid, RSAPubkey pubkey, byte[] dataInput, int dataInputLen, byte[] dataOut, int[] dataOutLen) {
        pubkey.setE(65537);
        int ret = this.jarJniApiProxy.RSAPubKeyCalc(pubkeyFid, XdjaKey.RSAPubkeyCovertToXdja(pubkey), dataInput, dataInputLen, dataOut, dataOutLen);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int SM2Sign(byte[] pubkeyFid, byte[] prikeyFid, int dataType, byte[] dataInput, int dataInputLen, byte[] dataOut, int[] dataOutLen) {
        int ret = this.jarJniApiProxy.SM2Sign(pubkeyFid, prikeyFid, dataType, dataInput, dataInputLen, dataOut, dataOutLen);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int RSASign(int bits, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        int ret = this.jarJniApiProxy.RSASign(bits, prifid, dataType, dataIn, inLen, dataOut, outLen);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int SM2SignVerify(byte[] pubkeyFid, int dataType, SM2Pubkey pubkey, byte[] dataInput, int dataInputLen, byte[] sign) {
        int ret = this.jarJniApiProxy.SM2SignVerify(pubkeyFid, dataType, XdjaKey.SM2PubkeyCovertToXdja(pubkey), dataInput, dataInputLen, sign);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int RSASignVerify(int bits, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int dataType, byte[] dataIn, int inLen, byte[] signatureData) {
        return this.jarJniApiProxy.RSASignVerify(bits, pubfid, pubkey, dataType, dataIn, inLen, signatureData);
    }

    @Override
    public int generateRandom(int randLen, byte[] random) {
        int ret = this.jarJniApiProxy.GenRandom(randLen, random);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int writeCert(byte[] fid, byte[] certBuf, int certLen) {
        int ret = this.jarJniApiProxy.WriteCert(fid, certBuf, certLen);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int SM4Key(byte[] tmpKey, byte[] dataInput, int dataInputLen, int flag, byte[] dataOutput, byte[] iv) {
        int ret = this.jarJniApiProxy.SM4KEY(tmpKey, dataInput, dataInputLen, flag, dataOutput, iv);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int SM2Decrypt(byte[] prikeyFid, byte[] dataInput, int dataInputLen, byte[] dataOutput, int[] dataOutputLen) {
        int ret = this.jarJniApiProxy.SM2Decrypt(prikeyFid, dataInput, dataInputLen, dataOutput, dataOutputLen);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int SM2Encrypt(byte[] pubkeyFid, SM2Pubkey sm2Pubkey, byte[] dataInput, int dataInputLen, byte[] dataOutput, int[] dataOutputLen) {
        int ret = this.jarJniApiProxy.SM2Encrypt(pubkeyFid, XdjaKey.SM2PubkeyCovertToXdja(sm2Pubkey), dataInput, dataInputLen, dataOutput, dataOutputLen);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int generateRSAPair(int bits, byte[] pubkeyFid, byte[] prikeyFid, RSAPubkey rsaPubkey, RSAPrikey rsaPrikey) {
        XDJA_RSA_PUBKEY xdja_rsa_pubkey = new XDJA_RSA_PUBKEY();
        XDJA_RSA_PRIKEY xdja_rsa_prikey = new XDJA_RSA_PRIKEY();
        int ret = this.jarJniApiProxy.GenRSAKeyPair(bits, pubkeyFid, prikeyFid, xdja_rsa_pubkey, xdja_rsa_prikey);
        if (ret == 0 && pubkeyFid[0] == 0 && pubkeyFid[1] == 0) {
            rsaPubkey.setBits(xdja_rsa_pubkey.bits);
            rsaPubkey.setE(xdja_rsa_pubkey.e);
            rsaPubkey.setM(xdja_rsa_pubkey.m);
            if (prikeyFid[0] == 0 && prikeyFid[1] == 0) {
                rsaPrikey.setBits(xdja_rsa_prikey.bits);
                rsaPrikey.setCe(xdja_rsa_prikey.ce);
                rsaPrikey.setDp(xdja_rsa_prikey.dp);
                rsaPrikey.setDq(xdja_rsa_prikey.dq);
                rsaPrikey.setQ(xdja_rsa_prikey.q);
                rsaPrikey.setP(xdja_rsa_prikey.p);
            }
        }
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int generateSM2Pair(byte[] pubkeyFid, byte[] prikeyFid, SM2Pubkey sm2Pubkey, SM2Prikey sm2Prikey) {
        XDJA_SM2_PUBKEY xdja_sm2_pubkey = new XDJA_SM2_PUBKEY();
        XDJA_SM2_PRIKEY xdja_sm2_prikey = new XDJA_SM2_PRIKEY();
        int ret = this.jarJniApiProxy.GenSM2KeyPair(pubkeyFid, prikeyFid, xdja_sm2_pubkey, xdja_sm2_prikey);
        if (ret == 0 && pubkeyFid[0] == 0 && pubkeyFid[1] == 0) {
            sm2Pubkey.setX(xdja_sm2_pubkey.x);
            sm2Pubkey.setY(xdja_sm2_pubkey.y);
            if (prikeyFid[0] == 0 && pubkeyFid[1] == 0) {
                sm2Prikey.setD(xdja_sm2_prikey.d);
            }
        }
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int writeSM2Pubkey(byte[] fid, SM2Pubkey sm2Pubkey) {
        int ret = this.jarJniApiProxy.WriteSm2PubKey(fid, XdjaKey.SM2PubkeyCovertToXdja(sm2Pubkey));
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int writeSM2Prikey(byte[] fid, SM2Prikey sm2Prikey) {
        int ret = this.jarJniApiProxy.WriteSm2PriKey(fid, XdjaKey.SM2PrikeyCovertToXdja(sm2Prikey));
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int readSM2Pubkey(byte[] fid, SM2Pubkey sm2Pubkey) {
        XDJA_SM2_PUBKEY xdja_sm2_pubkey = new XDJA_SM2_PUBKEY();
        int ret = this.jarJniApiProxy.ReadSm2PubKey(fid, xdja_sm2_pubkey);
        if (ret == 0) {
            sm2Pubkey.setX(xdja_sm2_pubkey.x);
            sm2Pubkey.setY(xdja_sm2_pubkey.y);
        }
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int readRSAPubKey(byte[] fid, RSAPubkey rsaPubkey) {
        XDJA_RSA_PUBKEY xdja_rsa_pubkey = new XDJA_RSA_PUBKEY();
        int ret = this.jarJniApiProxy.ReadRsaPubKey(fid, xdja_rsa_pubkey);
        if (ret == 0) {
            rsaPubkey.setBits(xdja_rsa_pubkey.bits);
            rsaPubkey.setE(xdja_rsa_pubkey.e);
            rsaPubkey.setM(xdja_rsa_pubkey.m);
        }
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int SM1Key(byte[] tmpKey, byte[] dataInput, int dataInputLen, int flag, byte[] dataOutput, byte[] iv) {
        int ret = this.jarJniApiProxy.SM1KEY(tmpKey, dataInput, dataInputLen, flag, dataOutput, iv);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int AESKey(byte[] tmpKey, int tmpKeyLen, byte[] dataInput, int dataInputLen, int flag, byte[] dataOutput, byte[] iv) {
        int ret = this.jarJniApiProxy.AESKEY(tmpKey, tmpKeyLen, dataInput, dataInputLen, flag, dataOutput, iv);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int DES3Key(byte[] tmpKey, int tmpKeyLen, byte[] dataInput, int dataInputLen, int flag, byte[] dataOutput, byte[] iv) {
        int ret = this.jarJniApiProxy.DES3KEY(tmpKey, tmpKeyLen, dataInput, dataInputLen, flag, dataOutput, iv);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int importCert(CertBean certBean) {
        Pair pair = JarJniApiProxyExtra.importCert((JarJniApiProxy)this.jarJniApiProxy, (CertBean)certBean);
        return ChipManagerKey.ERROR_COVERT((Integer)pair.first);
    }

    @Override
    public int genSignSM2KeyPair(int containerID) {
        int ret = JarJniApiProxyExtra.genSignSM2KeyPair((JarJniApiProxy)this.jarJniApiProxy, (int)containerID);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int genSignRSAKeyPair(int ContainerID, int bits) {
        int ret = JarJniApiProxyExtra.genSignRSAKeyPair((JarJniApiProxy)this.jarJniApiProxy, (int)ContainerID, (int)bits);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int createContainer(int role, String pin, int containerId, String containerName) {
        int ret = JarJniApiProxyExtra.createContainer((JarJniApiProxy)this.jarJniApiProxy, (int)role, (String)pin, (int)containerId, (String)containerName);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int clearContainer(int role, String pin, int containerId) {
        int ret = JarJniApiProxyExtra.clearContainer((JarJniApiProxy)this.jarJniApiProxy, (int)role, (String)pin, (int)containerId);
        return ChipManagerKey.ERROR_COVERT(ret);
    }

    @Override
    public int createFile(XDJA_FILE file) {
        return this.jarJniApiProxy.CreateFile(file);
    }

    @Override
    public int writeFile(byte[] fid, int writePos, int writeLen, byte[] dataIn) {
        return this.jarJniApiProxy.WriteFile(fid, writePos, writeLen, dataIn);
    }

    @Override
    public int readFile(byte[] fid, int readPos, int readLen, byte[] dataOut) {
        return this.jarJniApiProxy.ReadFile(fid, readPos, readLen, dataOut);
    }

    @Override
    public int deleteFile(byte[] fid) {
        return this.jarJniApiProxy.DeleteFile(fid);
    }

    @Override
    public int SM3(byte[] dataIn, int inLen, byte[] dataOut) {
        return this.jarJniApiProxy.SM3(dataIn, inLen, dataOut);
    }

    private static int ERROR_COVERT(int errCode) {
        if (errCode == 0) {
            return errCode;
        }
        if (SysError.inRange(errCode, -11000, -9999)) {
            return ChipManagerError.errorFromCM(errCode);
        }
        if (XdjaError.inXdjaErrorRange(errCode)) {
            return XdjaError.errorFromXdja(errCode);
        }
        return errCode;
    }
}

