/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev.driver.xdja;

import android.content.Context;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.R;
import com.xdja.cryptodev.error.ErrorCallback;
import com.xdja.cryptodev.error.SysError;

public class XdjaError
extends ErrorCallback {
    private static final int E_XDJA_START = 2000;
    private static final int E_XDJA_END = 3000;

    @Override
    public int getErrorBegin() {
        return 2000;
    }

    @Override
    public int getErrorEnd() {
        return 3000;
    }

    @Override
    public String getComment(int errCode) {
        return this.getXdjaErrorText(XdjaError.errorFromXdja(errCode));
    }

    public static boolean inXdjaErrorRange(int errCode) {
        return SysError.inRange(errCode, -200, 10);
    }

    public static int errorFromXdja(int xdjaCode) {
        return xdjaCode == 0 ? 0 : 2010 - xdjaCode;
    }

    public static int errorToXdja(int code) {
        if (SysError.inRange(code, 2000, 3000)) {
            return 2010 - code;
        }
        return 1000;
    }

    private String getXdjaErrorText(int errCode) {
        Context context = CryptoDevManager.getInstance().getContext();
        switch (errCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return context.getString(R.string.xdja_pin_error_head) + errCode + context.getString(R.string.xdja_pin_error_tail);
            }
            case -1: {
                return context.getString(R.string.xkr_no_handle);
            }
            case -2: {
                return context.getString(R.string.xkr_io_failed);
            }
            case -3: {
                return context.getString(R.string.xkr_io_failed);
            }
            case -4: {
                return context.getString(R.string.xkr_back_data);
            }
            case -5: {
                return context.getString(R.string.xkr_reset_failed);
            }
            case -6: {
                return context.getString(R.string.xkr_no_role);
            }
            case -7: {
                return context.getString(R.string.xkr_datain_size);
            }
            case -8: {
                return context.getString(R.string.xkr_outbuf_size);
            }
            case -9: {
                return context.getString(R.string.xkr_invalid_para);
            }
            case -10: {
                return context.getString(R.string.xkr_key_locked);
            }
            case -11: {
                return context.getString(R.string.xkr_eeprom_write);
            }
            case -12: {
                return context.getString(R.string.xkr_parameter);
            }
            case -13: {
                return context.getString(R.string.xkr_cmd_notmatch_line);
            }
            case -14: {
                return context.getString(R.string.xkr_cmd_notmatch_fat);
            }
            case -15: {
                return context.getString(R.string.xkr_no_power);
            }
            case -16: {
                return context.getString(R.string.xkr_key_locked);
            }
            case -18: {
                return context.getString(R.string.xkr_data_parameter);
            }
            case -19: {
                return context.getString(R.string.xkr_app_locked);
            }
            case -20: {
                return context.getString(R.string.xkr_file_not_exist);
            }
            case -21: {
                return context.getString(R.string.xkr_no_file_space);
            }
            case -22: {
                return context.getString(R.string.xkr_not_get_random);
            }
            case -23: {
                return context.getString(R.string.xkr_file_exist);
            }
            case -24: {
                return context.getString(R.string.xkr_file_content);
            }
            case -25: {
                return context.getString(R.string.xkr_wrong_state);
            }
            case -26: {
                return context.getString(R.string.xkr_card_locked);
            }
            case -27: {
                return context.getString(R.string.xkr_wrong_le);
            }
            case -28: {
                return context.getString(R.string.xkr_no_this_cmd);
            }
            case -29: {
                return context.getString(R.string.xkr_invalid_data);
            }
            case -30: {
                return context.getString(R.string.xkr_wrong_mac);
            }
            case -31: {
                return context.getString(R.string.xkr_keyfile_not_exist);
            }
            case -32: {
                return context.getString(R.string.xkr_key_not_exist);
            }
            case -33: {
                return context.getString(R.string.xkr_wrong_key_type);
            }
            case -34: {
                return context.getString(R.string.xkr_bad_pubkey);
            }
            case -35: {
                return context.getString(R.string.xkr_hash_failed);
            }
            case -36: {
                return context.getString(R.string.xkr_rsapublic_failed);
            }
            case -37: {
                return context.getString(R.string.xkr_bad_prikey);
            }
            case -38: {
                return context.getString(R.string.xkr_sign_confirm);
            }
            case -39: {
                return context.getString(R.string.xkr_sign_cancel);
            }
            case -40: {
                return context.getString(R.string.xkr_condition);
            }
            case -41: {
                return context.getString(R.string.xkr_decrypt_fail);
            }
            case -42: {
                return context.getString(R.string.xkr_not_find_data);
            }
            case -43: {
                return context.getString(R.string.xkr_dgi_not_support);
            }
            case -44: {
                return context.getString(R.string.xkr_data_nocorrent);
            }
            case -45: {
                return context.getString(R.string.xkr_exauth_fail);
            }
            case -46: {
                return context.getString(R.string.xkr_rsa_not_find);
            }
            case -47: {
                return context.getString(R.string.xkr_tlock_faild);
            }
            case -48: {
                return context.getString(R.string.xkr_tlock_timeout);
            }
            case -49: {
                return context.getString(R.string.xkr_bad_cert);
            }
            case -50: {
                return context.getString(R.string.xkr_sign_verify);
            }
            case -51: {
                return context.getString(R.string.xkr_getmountpath_faild);
            }
            case -95: {
                return context.getString(R.string.xkr_malloc_falid);
            }
            case -97: {
                return context.getString(R.string.xkr_no_key);
            }
            case -98: {
                return context.getString(R.string.xkr_not_support);
            }
            case -99: {
                return context.getString(R.string.xkr_not_activated);
            }
        }
        return context.getString(R.string.xkr_unknown);
    }
}

