/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev.driver.xdja;

import android.util.Log;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_RSA_PRIKEY;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.devapi.RSAPrikey;
import com.xdja.cryptodev.devapi.RSAPubkey;
import com.xdja.cryptodev.devapi.SM2Prikey;
import com.xdja.cryptodev.devapi.SM2Pubkey;
import com.xdja.cryptodev.driver.IDevDriver;
import com.xdja.cryptodev.driver.xdja.XdjaError;
import com.xdja.multichip.param.CertBean;

public class XdjaKey
extends CryptoInstance {
    private long handle = 0L;
    private JNIAPI jniapi = new JNIAPI();
    private static final String THIS_FILE = "XdjaKey";

    XdjaKey(IDevDriver driver, CryptoDevInfo devInfo) {
        super(driver, devInfo);
    }

    public static XDJA_RSA_PUBKEY RSAPubkeyCovertToXdja(RSAPubkey pubkey) {
        if (pubkey == null) {
            return null;
        }
        XDJA_RSA_PUBKEY xdja_rsa_pubkey = new XDJA_RSA_PUBKEY();
        xdja_rsa_pubkey.bits = pubkey.getBits();
        xdja_rsa_pubkey.e = pubkey.getE();
        System.arraycopy(pubkey.getM(), 0, xdja_rsa_pubkey.m, 0, 256);
        return xdja_rsa_pubkey;
    }

    public static RSAPubkey RSAPubkeyCovertFromXdja(XDJA_RSA_PUBKEY rsa_pubkey) {
        if (rsa_pubkey == null) {
            return null;
        }
        return new RSAPubkey(rsa_pubkey.bits, rsa_pubkey.m, rsa_pubkey.e);
    }

    public static XDJA_SM2_PUBKEY SM2PubkeyCovertToXdja(SM2Pubkey pubkey) {
        if (pubkey == null) {
            return null;
        }
        XDJA_SM2_PUBKEY xdja_sm2_pubkey = new XDJA_SM2_PUBKEY();
        System.arraycopy(pubkey.getX(), 0, xdja_sm2_pubkey.x, 0, 32);
        System.arraycopy(pubkey.getY(), 0, xdja_sm2_pubkey.y, 0, 32);
        return xdja_sm2_pubkey;
    }

    public static SM2Pubkey SM2PubkeyCovertFromXdja(XDJA_SM2_PUBKEY sm2_pubkey) {
        if (sm2_pubkey == null) {
            return null;
        }
        return new SM2Pubkey(sm2_pubkey.x, sm2_pubkey.y);
    }

    public static XDJA_SM2_PRIKEY SM2PrikeyCovertToXdja(SM2Prikey sm2Prikey) {
        XDJA_SM2_PRIKEY xdja_sm2_prikey = new XDJA_SM2_PRIKEY();
        System.arraycopy(xdja_sm2_prikey.d, 0, sm2Prikey.getD(), 0, 32);
        return xdja_sm2_prikey;
    }

    public static SM2Prikey SM2PrikeyCovertFromXdja(XDJA_SM2_PRIKEY sm2_prikey) {
        return new SM2Prikey(sm2_prikey.d);
    }

    @Override
    public int open() {
        int[] devCnt = new int[1];
        long[] devHandle = new long[1];
        XDJA_DEVINFO xdja_devinfo = new XDJA_DEVINFO();
        int ret = this.jniapi.EnumDev(0, devCnt);
        if (ret != 0) {
            Log.d((String)THIS_FILE, (String)("EnumDev faild. return " + ret));
            return 0;
        }
        for (int i = 0; i < devCnt[0]; ++i) {
            ret = this.jniapi.OpenDev(i, devHandle);
            if (ret != 0) {
                Log.e((String)THIS_FILE, (String)("OpenDev failed. index " + i + " return " + ret));
                continue;
            }
            ret = this.jniapi.GetDevInfo(devHandle[0], xdja_devinfo);
            if (ret != 0) continue;
            String cardId = new String(xdja_devinfo.cardid, 0, 32);
            if (cardId.equals(this.devInfo.getCardId())) {
                this.handle = devHandle[0];
                return 0;
            }
            this.jniapi.CloseDev(devHandle[0]);
        }
        return XdjaError.errorFromXdja(-97);
    }

    @Override
    public int close() {
        return XdjaError.errorFromXdja(this.jniapi.CloseDev(this.handle));
    }

    @Override
    public int reset() {
        return XdjaError.errorFromXdja(this.jniapi.CardReset(this.handle));
    }

    @Override
    public int lock() {
        return XdjaError.errorFromXdja(this.jniapi.LockDev(this.handle));
    }

    @Override
    public int unlock() {
        return XdjaError.errorFromXdja(this.jniapi.UnlockDev(this.handle));
    }

    @Override
    public int verifyPIN(String pin, int role) {
        int ret = this.jniapi.VerifyPIN(this.handle, role, pin.getBytes(), pin.length());
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int getPINTryCount(int role) {
        int ret = this.jniapi.GetPinTryCount(this.handle, role);
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int readCert(byte[] fid, byte[] cert, int[] certLen) {
        int ret = this.jniapi.ReadCert(this.handle, fid, cert, certLen);
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int RSAPrikeyCalc(byte[] prikeyFid, byte[] dataInput, int dataInputLen, byte[] dataOut, int[] dataOutLen) {
        int ret = this.jniapi.RSAPriKeyCalc(this.handle, prikeyFid, dataInput, dataInputLen, dataOut, dataOutLen);
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int RSAPubkeyCalc(byte[] pubkeyFid, RSAPubkey pubkey, byte[] dataInput, int dataInputLen, byte[] dataOut, int[] dataOutLen) {
        int ret = this.jniapi.RSAPubKeyCalc(this.handle, pubkeyFid, XdjaKey.RSAPubkeyCovertToXdja(pubkey), dataInput, dataInputLen, dataOut, dataOutLen);
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int SM2Sign(byte[] pubkeyFid, byte[] prikeyFid, int dataType, byte[] dataInput, int dataInputLen, byte[] dataOut, int[] dataOutLen) {
        int ret = this.jniapi.SM2Sign(this.handle, pubkeyFid, prikeyFid, dataType, dataInput, dataInputLen, dataOut, dataOutLen);
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int RSASign(int bits, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return 0;
    }

    @Override
    public int SM2SignVerify(byte[] pubkeyFid, int dataType, SM2Pubkey pubkey, byte[] dataInput, int dataInputLen, byte[] sign) {
        int ret = this.jniapi.SM2SignVerify(this.handle, pubkeyFid, dataType, XdjaKey.SM2PubkeyCovertToXdja(pubkey), dataInput, dataInputLen, sign);
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int RSASignVerify(int bits, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int dataType, byte[] dataIn, int inLen, byte[] signatureData) {
        return 0;
    }

    @Override
    public int generateRandom(int randLen, byte[] random) {
        int ret = this.jniapi.GenRandom(this.handle, randLen, random);
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int writeCert(byte[] fid, byte[] certBuf, int certLen) {
        int ret = this.jniapi.WriteCert(this.handle, fid, certBuf, certLen);
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int SM4Key(byte[] tmpKey, byte[] dataInput, int dataInputLen, int flag, byte[] dataOutput, byte[] iv) {
        int ret = this.jniapi.SM4KEY(this.handle, tmpKey, dataInput, dataInputLen, flag, dataOutput, iv);
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int SM2Decrypt(byte[] prikeyFid, byte[] dataInput, int dataInputLen, byte[] dataOutput, int[] dataOutputLen) {
        int ret = this.jniapi.SM2Decrypt(this.handle, prikeyFid, dataInput, dataInputLen, dataOutput, dataOutputLen);
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int SM2Encrypt(byte[] pubkeyFid, SM2Pubkey sm2Pubkey, byte[] dataInput, int dataInputLen, byte[] dataOutput, int[] dataOutputLen) {
        int ret = this.jniapi.SM2Encrypt(this.handle, pubkeyFid, XdjaKey.SM2PubkeyCovertToXdja(sm2Pubkey), dataInput, dataInputLen, dataOutput, dataOutputLen);
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int generateRSAPair(int bits, byte[] pubkeyFid, byte[] prikeyFid, RSAPubkey rsaPubkey, RSAPrikey rsaPrikey) {
        XDJA_RSA_PUBKEY xdja_rsa_pubkey = new XDJA_RSA_PUBKEY();
        XDJA_RSA_PRIKEY xdja_rsa_prikey = new XDJA_RSA_PRIKEY();
        int ret = this.jniapi.GenRSAKeyPair(this.handle, bits, pubkeyFid, prikeyFid, xdja_rsa_pubkey, xdja_rsa_prikey);
        if (ret == 0 && pubkeyFid[0] == 0 && pubkeyFid[1] == 0) {
            rsaPubkey.setBits(xdja_rsa_pubkey.bits);
            rsaPubkey.setE(xdja_rsa_pubkey.e);
            rsaPubkey.setM(xdja_rsa_pubkey.m);
            if (prikeyFid[0] == 0 && prikeyFid[1] == 0) {
                rsaPrikey.setBits(xdja_rsa_prikey.bits);
                rsaPrikey.setCe(xdja_rsa_prikey.ce);
                rsaPrikey.setDp(xdja_rsa_prikey.dp);
                rsaPrikey.setDq(xdja_rsa_prikey.dq);
                rsaPrikey.setQ(xdja_rsa_prikey.q);
                rsaPrikey.setP(xdja_rsa_prikey.p);
            }
        }
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int generateSM2Pair(byte[] pubkeyFid, byte[] prikeyFid, SM2Pubkey sm2Pubkey, SM2Prikey sm2Prikey) {
        XDJA_SM2_PUBKEY xdja_sm2_pubkey = new XDJA_SM2_PUBKEY();
        XDJA_SM2_PRIKEY xdja_sm2_prikey = new XDJA_SM2_PRIKEY();
        int ret = this.jniapi.GenSM2KeyPair(this.handle, pubkeyFid, prikeyFid, xdja_sm2_pubkey, xdja_sm2_prikey);
        if (ret == 0 && pubkeyFid[0] == 0 && pubkeyFid[1] == 0) {
            sm2Pubkey.setX(xdja_sm2_pubkey.x);
            sm2Pubkey.setY(xdja_sm2_pubkey.y);
            if (prikeyFid[0] == 0 && pubkeyFid[1] == 0) {
                sm2Prikey.setD(xdja_sm2_prikey.d);
            }
        }
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int writeSM2Pubkey(byte[] fid, SM2Pubkey sm2Pubkey) {
        int ret = this.jniapi.WriteSm2PubKey(this.handle, fid, XdjaKey.SM2PubkeyCovertToXdja(sm2Pubkey));
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int writeSM2Prikey(byte[] fid, SM2Prikey sm2Prikey) {
        int ret = this.jniapi.WriteSm2PriKey(this.handle, fid, XdjaKey.SM2PrikeyCovertToXdja(sm2Prikey));
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int readSM2Pubkey(byte[] fid, SM2Pubkey sm2Pubkey) {
        XDJA_SM2_PUBKEY xdja_sm2_pubkey = new XDJA_SM2_PUBKEY();
        int ret = this.jniapi.ReadSm2PubKey(this.handle, fid, xdja_sm2_pubkey);
        if (ret == 0) {
            sm2Pubkey.setX(xdja_sm2_pubkey.x);
            sm2Pubkey.setY(xdja_sm2_pubkey.y);
        }
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int readRSAPubKey(byte[] fid, RSAPubkey rsaPubkey) {
        return XdjaError.errorFromXdja(-98);
    }

    @Override
    public int SM1Key(byte[] tmpKey, byte[] dataInput, int dataInputLen, int flag, byte[] dataOutput, byte[] iv) {
        int ret = this.jniapi.SM1KEY(this.handle, tmpKey, dataInput, dataInputLen, flag, dataOutput, iv);
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int AESKey(byte[] tmpKey, int tmpKeyLen, byte[] dataInput, int dataInputLen, int flag, byte[] dataOutput, byte[] iv) {
        int ret = this.jniapi.AESKEY(this.handle, tmpKey, tmpKeyLen, dataInput, dataInputLen, flag, dataOutput, iv);
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int DES3Key(byte[] tmpKey, int tmpKeyLen, byte[] dataInput, int dataInputLen, int flag, byte[] dataOutput, byte[] iv) {
        int ret = this.jniapi.DES3KEY(this.handle, tmpKey, tmpKeyLen, dataInput, dataInputLen, flag, dataOutput, iv);
        return XdjaError.errorFromXdja(ret);
    }

    @Override
    public int importCert(CertBean certBean) {
        return XdjaError.errorFromXdja(-98);
    }

    @Override
    public int genSignSM2KeyPair(int ContainerID) {
        return XdjaError.errorFromXdja(-98);
    }

    @Override
    public int genSignRSAKeyPair(int ContainerID, int bits) {
        return XdjaError.errorFromXdja(-98);
    }

    @Override
    public int createContainer(int role, String pin, int containerId, String containerName) {
        return XdjaError.errorFromXdja(-98);
    }

    @Override
    public int clearContainer(int role, String pin, int containerId) {
        return 0;
    }

    @Override
    public int createFile(XDJA_FILE file) {
        return 0;
    }

    @Override
    public int writeFile(byte[] fid, int writePos, int writeLen, byte[] dataIn) {
        return 0;
    }

    @Override
    public int readFile(byte[] fid, int readPos, int readLen, byte[] dataOut) {
        return 0;
    }

    @Override
    public int deleteFile(byte[] fid) {
        return 0;
    }

    @Override
    public int SM3(byte[] dataIn, int inLen, byte[] dataOut) {
        return 0;
    }
}

