/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk;

import android.graphics.Bitmap;
import android.os.Process;
import android.util.Log;
import cn.cloudwalk.TestLog;
import cn.cloudwalk.Utils;
import cn.cloudwalk.callback.FaceInfoCallback;
import cn.cloudwalk.callback.ImageAnalyCallBack;
import cn.cloudwalk.callback.LivessCallBack;
import cn.cloudwalk.jni.FaceDetTrack;
import cn.cloudwalk.jni.FaceInfo;
import cn.cloudwalk.jni.FaceLivingImg;
import cn.cloudwalk.jni.FaceParam;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.concurrent.PriorityBlockingQueue;

public class CloudwalkSDK {
    private static final String TAG = "yc_CloudwalkSDK";
    private LivessCallBack livessCallBack;
    private volatile int livessType;
    private FaceInfoCallback faceInfoCallback;
    static CloudwalkSDK cloudwalkSDK;
    private long mStartTime;
    String modulePath = "";
    int pDetector;
    FaceDetTrack faceDetTrack;
    static FaceParam param;
    static int maxFaceNum;
    static FaceInfo[] faceInfos;
    private DetectType mWorkType = DetectType.LIVE_DETECT;
    FaceLivingImg[] faceLivingImgs;
    static final int BEST_FACE_INDEX = 3;
    static final int NEXT_FACE_INDEX = 2;
    int faceNum;
    int livessLevel;
    private float bestFacScore = -1.0f;
    private volatile int mTotalStep;
    private volatile int mCurrentStep;
    private volatile boolean mPushFrame = true;
    private Thread videoThread = null;
    private volatile boolean bDetecting = false;
    int frameFormat;
    private int frameW;
    private int frameH;
    private int frameAngle;
    private int frameMirror;
    private Frame mPreviewFrame;
    private PriorityBlockingQueue<Frame> mFrameQueue = new PriorityBlockingQueue();
    volatile int op = 4070;
    private volatile int stageflag = 1;

    public static CloudwalkSDK getInstance() {
        if (null == cloudwalkSDK) {
            cloudwalkSDK = new CloudwalkSDK();
        }
        return cloudwalkSDK;
    }

    private CloudwalkSDK() {
        this.faceDetTrack = FaceDetTrack.getInstance();
    }

    public synchronized String getModulePath() {
        return this.modulePath;
    }

    public synchronized void setModulePath(String modulePath) {
        this.modulePath = modulePath;
    }

    public int cwGetParam(FaceParam faceParam) {
        int sfRet = FaceDetTrack.getInstance().cwGetParam(this.pDetector, faceParam);
        return this.abs("cwGetParam", sfRet);
    }

    public int cwsetParam(FaceParam faceParam) {
        int sfRet = FaceDetTrack.getInstance().cwSetParam(this.pDetector, faceParam);
        return this.abs("cwsetParam", sfRet);
    }

    public String cwGetVersionInfo() {
        return FaceDetTrack.getInstance().cwGetVersionInfo();
    }

    public int cwInit(String pLicence) {
        int ret = 0;
        TestLog.netE(TAG, "cwInit  cwCreateDetectorFromMem");
        StringBuilder storagePath = new StringBuilder(this.getModulePath());
        StringBuilder pFaceDetectFile = new StringBuilder(storagePath.toString() + File.separator + "faceDetector_2_4.mdl");
        StringBuilder pFaceKeyPtFile = new StringBuilder(storagePath.toString() + File.separator + "keypt_detect_model_sdm_9pts.bin");
        StringBuilder pFaceKeyPtTrackFile = new StringBuilder(storagePath.toString() + File.separator + "keypt_track_model_sdm_9pts.bin");
        StringBuilder pFaceQualityFile = new StringBuilder(storagePath.toString() + File.separator + "facequality_4_1.bin");
        StringBuilder pFaceLivenessFile = new StringBuilder(storagePath.toString() + File.separator + "liveness171120.bin");
        this.pDetector = this.faceDetTrack.cwCreateDetectorFromFile(pFaceDetectFile.toString(), pFaceKeyPtFile.toString(), pFaceKeyPtTrackFile.toString(), pFaceQualityFile.toString(), pFaceLivenessFile.toString(), pLicence, 0);
        int cpuNum = 2;
        TestLog.netE(TAG, "cwInit  cpuNum=" + cpuNum);
        FaceParam faceParam = new FaceParam();
        this.cwGetParam(faceParam);
        faceParam.nCpuCores = 2;
        faceParam.minTrackedKeyptScore = 0.5f;
        faceParam.perfmonLevel = 6;
        faceParam.bCollectFrmsLiving = 0;
        this.cwsetParam(faceParam);
        this.mStartTime = 0L;
        if (this.pDetector < 0) {
            ret = this.abs("cwInit", this.pDetector);
        }
        if (ret == 0) {
            this.cwStart();
        }
        return ret;
    }

    private FaceLivingImg[] cwGetFaceLivingImg() {
        return this.faceDetTrack.cwGetLivingImage(this.pDetector);
    }

    public byte[] cwGetOriBestFace() {
        if (this.faceLivingImgs == null || this.faceLivingImgs != null && this.faceLivingImgs[3] == null || this.faceLivingImgs != null && this.faceLivingImgs[3] != null && this.faceLivingImgs[3].livingImageData == null) {
            this.faceLivingImgs = this.cwGetFaceLivingImg();
        }
        Bitmap bmp = null;
        try {
            bmp = Utils.byteArrayBGRToBitmap(this.faceLivingImgs[3].livingImageData, this.faceLivingImgs[3].livingImageW, this.faceLivingImgs[3].livingImageH);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)("----cwGetOriBestFace exception:" + e.getMessage()));
        }
        byte[] result = null;
        result = Utils.bitmapToByte(bmp, Bitmap.CompressFormat.JPEG);
        Utils.recycleBitmap(bmp);
        return result;
    }

    public String cwGetBestInfo() {
        if (this.faceLivingImgs == null || this.faceLivingImgs != null && this.faceLivingImgs[3] == null) {
            this.faceLivingImgs = this.cwGetFaceLivingImg();
        }
        return Utils.cwGetFaceLivingImgInfo(this.faceLivingImgs[3]);
    }

    public byte[] cwGetClipedBestFace() {
        if (this.faceLivingImgs == null || this.faceLivingImgs != null && this.faceLivingImgs[3] == null || this.faceLivingImgs != null && this.faceLivingImgs[3] != null && this.faceLivingImgs[3].livingImageData == null) {
            this.faceLivingImgs = this.cwGetFaceLivingImg();
        }
        Bitmap bmp = null;
        Bitmap clipedBestface = null;
        try {
            bmp = Utils.byteArrayBGRToBitmap(this.faceLivingImgs[3].livingImageData, this.faceLivingImgs[3].livingImageW, this.faceLivingImgs[3].livingImageH);
            if (bmp != null && this.faceLivingImgs[3] != null) {
                clipedBestface = this.cwClipFaceBitmap(bmp, this.faceLivingImgs[3]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)("----cwGetClipedBestFace exception:" + e.getMessage()));
        }
        byte[] result = null;
        if (clipedBestface != null) {
            result = Utils.bitmapToByte(clipedBestface, Bitmap.CompressFormat.JPEG);
        }
        Utils.recycleBitmap(bmp);
        Utils.recycleBitmap(clipedBestface);
        return result;
    }

    public byte[] cwGetNextFace() {
        if (this.faceLivingImgs == null || this.faceLivingImgs != null && this.faceLivingImgs[2].livingImageData == null) {
            this.faceLivingImgs = this.cwGetFaceLivingImg();
        }
        Bitmap bmp = null;
        try {
            bmp = Utils.byteArrayBGRToBitmap(this.faceLivingImgs[2].livingImageData, this.faceLivingImgs[2].livingImageW, this.faceLivingImgs[2].livingImageH);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)("----cwGetNextFace exception:" + e.getMessage()));
        }
        byte[] result = null;
        result = Utils.bitmapToByte(bmp, Bitmap.CompressFormat.JPEG);
        Utils.recycleBitmap(bmp);
        return result;
    }

    public String cwGetNextInfo() {
        if (this.faceLivingImgs == null || this.faceLivingImgs != null && this.faceLivingImgs[2] == null || this.faceLivingImgs != null && this.faceLivingImgs[2] != null && this.faceLivingImgs[2].livingImageData == null) {
            this.faceLivingImgs = this.cwGetFaceLivingImg();
        }
        return Utils.cwGetFaceLivingImgInfo(this.faceLivingImgs[2]);
    }

    public int cwResetLiving() {
        int sfRet = FaceDetTrack.getInstance().cwResetLiving(this.pDetector);
        TestLog.netE(TAG, "cwResetDetTrack ret=" + sfRet);
        return this.abs("cwResetDetTrack", sfRet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cwDestory() {
        CloudwalkSDK cloudwalkSDK = this;
        synchronized (cloudwalkSDK) {
            this.faceInfoCallback = null;
            this.livessCallBack = null;
        }
        this.cwStop();
        return 0;
    }

    public synchronized void cwClearBestFace() {
        this.faceLivingImgs = null;
    }

    @Deprecated
    public void cwSetLivessLevel(int levelType) {
        this.livessLevel = levelType;
    }

    public void cwStartLivess(int livessType) {
        TestLog.netd(TAG, "StartLivess=" + livessType);
        this.livessType = livessType;
        this.cwResetLiving();
        switch (livessType) {
            case 1000: {
                this.stageflag = 2;
                this.mFrameQueue.clear();
                this.mPushFrame = true;
                break;
            }
            case 1001: {
                this.stageflag = 4;
                this.mFrameQueue.clear();
                this.mPushFrame = true;
                break;
            }
            case 1004: {
                this.stageflag = 8;
                this.mFrameQueue.clear();
                this.mPushFrame = true;
                break;
            }
            case 1005: {
                this.stageflag = 16;
                this.mFrameQueue.clear();
                this.mPushFrame = true;
                break;
            }
            case 1002: {
                this.stageflag = 32;
                this.mFrameQueue.clear();
                this.mPushFrame = true;
                break;
            }
            case 1003: {
                this.stageflag = 64;
                this.mFrameQueue.clear();
                this.mPushFrame = true;
            }
        }
    }

    public void cwStopLivess() {
        this.livessType = -1;
        this.cwResetLiving();
        this.stageflag = 0;
        this.mFrameQueue.clear();
    }

    public synchronized void cwLivessInfoCallback(LivessCallBack livessCallBack) {
        this.livessCallBack = livessCallBack;
    }

    public synchronized void cwFaceInfoCallback(FaceInfoCallback faceInfoCallback) {
        this.faceInfoCallback = faceInfoCallback;
    }

    public void cwImageAnaly(Bitmap srcBitmap, ImageAnalyCallBack imageAnalyCallBack) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        srcBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)o);
        byte[] jpgData = o.toByteArray();
        this.faceNum = 0;
        int op = 20;
        int stageflag = 1;
        this.faceDetTrack.cwFaceDetectTrack(this.pDetector, jpgData, System.currentTimeMillis() % 1000000L, srcBitmap.getWidth(), srcBitmap.getHeight(), 6, 0, 0, op, stageflag, faceInfos);
        this.faceNum = FaceDetTrack.getInstance().mFaceNum;
        TestLog.netd(TAG, "cwImageAnaly faceNum=" + this.faceNum);
        if (imageAnalyCallBack != null) {
            imageAnalyCallBack.analyFaceInfo(faceInfos, this.faceNum);
        }
    }

    public Bitmap cwGetIDFaceImage(Bitmap srcBitmap) {
        long start = System.currentTimeMillis();
        Bitmap bmp = this.cwGetIDFaceImage(srcBitmap, 0);
        TestLog.netE("2222", "cwGetIDFaceImage" + (System.currentTimeMillis() - start));
        return bmp;
    }

    private Bitmap cwGetIDFaceImage(Bitmap srcBitmap, int imageAngle) {
        Bitmap tarBitmap = null;
        try {
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            srcBitmap.compress(Bitmap.CompressFormat.JPEG, 95, (OutputStream)o);
            byte[] jpgData = o.toByteArray();
            this.faceNum = 0;
            int op = 4;
            int stageflag = 0;
            this.faceDetTrack.cwFaceDetectTrack(this.pDetector, jpgData, System.currentTimeMillis() % 1000000L, srcBitmap.getWidth(), srcBitmap.getHeight(), 6, imageAngle, 0, op, stageflag, faceInfos);
            this.faceNum = FaceDetTrack.getInstance().mFaceNum;
            if (this.faceNum > 0 && faceInfos != null) {
                int srcH = srcBitmap.getHeight();
                int srcW = srcBitmap.getWidth();
                int faceX = CloudwalkSDK.faceInfos[0].x;
                int faceY = CloudwalkSDK.faceInfos[0].y;
                int faceWidth = CloudwalkSDK.faceInfos[0].width;
                int faceHeight = CloudwalkSDK.faceInfos[0].height;
                int width = faceWidth;
                int height = faceHeight;
                int x = faceX - width / 4 > 0 ? faceX - width / 4 : 0;
                int y = faceY - height / 2 > 0 ? faceY - height / 2 : 0;
                double scaleW = this.getScale(x, faceWidth, srcW, 1.5);
                double scaleH = this.getScale(y, faceHeight, srcH, 2.0);
                width = (int)((double)faceWidth * scaleW);
                height = (int)((double)faceHeight * scaleH);
                tarBitmap = Bitmap.createBitmap((Bitmap)srcBitmap, (int)x, (int)y, (int)width, (int)height);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("----cwGetIDFaceImage exception:" + e.getMessage()));
        }
        return tarBitmap;
    }

    private Bitmap cwClipFaceBitmap(Bitmap srcBitmap, FaceLivingImg faceLivingImg) {
        Bitmap tarBitmap = null;
        try {
            int srcH = srcBitmap.getHeight();
            int srcW = srcBitmap.getWidth();
            int minX = (int)this.minPoint(faceLivingImg.pointX);
            int minY = (int)this.minPoint(faceLivingImg.pointY);
            int maxX = (int)this.maxPoint(faceLivingImg.pointX);
            int maxY = (int)this.maxPoint(faceLivingImg.pointY);
            int faceX = (int)((double)minX / 1.2);
            int faceY = (int)((double)minY / 1.6);
            int faceWidth = (int)((double)(maxX - minX) * 1.5);
            int faceHeight = (int)((double)(maxY - minY) * 1.8);
            int width = faceWidth;
            int height = faceHeight;
            int x = faceX - width / 4 > 0 ? faceX - width / 4 : 0;
            int y = faceY - height / 2 > 0 ? faceY - height / 2 : 0;
            double scaleW = this.getScale(x, faceWidth, srcW, 1.5);
            double scaleH = this.getScale(y, faceHeight, srcH, 2.0);
            width = (int)((double)faceWidth * scaleW);
            height = (int)((double)faceHeight * scaleH);
            tarBitmap = Bitmap.createBitmap((Bitmap)srcBitmap, (int)x, (int)y, (int)width, (int)height);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("----cwClipFaceBitmap exception:" + e.getMessage()));
        }
        return tarBitmap;
    }

    private float minPoint(float[] points) {
        float result = points[0];
        for (int i = 0; i < points.length; ++i) {
            if (!(points[i] <= result)) continue;
            result = points[i];
        }
        return result;
    }

    private float maxPoint(float[] points) {
        float result = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            if (!(points[i] >= result)) continue;
            result = points[i];
        }
        return result;
    }

    double getScale(int start, int len, int total, double scale) {
        while ((double)start + (double)len * scale > (double)total) {
            scale -= 0.1;
        }
        return scale;
    }

    public void setOperator(int op) {
        this.op = op;
    }

    private int cwStart() {
        this.bDetecting = true;
        this.faceLivingImgs = null;
        this.bestFacScore = -1.0f;
        this.stageflag = 1;
        this.op = 4070;
        this.mPushFrame = true;
        if (null == this.videoThread) {
            TestLog.netd(TAG, "cwStar null == videoThread");
            this.mFrameQueue.clear();
            this.videoThread = new Thread(new VideoRecordRunnable(this.mFrameQueue));
            this.videoThread.start();
        } else {
            TestLog.netd(TAG, "cwStart null != videoThread");
        }
        return 0;
    }

    private int cwStop() {
        this.bDetecting = false;
        this.faceLivingImgs = null;
        this.stageflag = 1;
        this.mFrameQueue.clear();
        TestLog.netd(TAG, "cwStop videoThread:" + this.videoThread + "bDetecting:" + this.bDetecting);
        if (null != this.videoThread && !this.bDetecting) {
            try {
                this.videoThread.interrupt();
                this.videoThread.join();
                this.videoThread = null;
                TestLog.netd(TAG, "cwStop videoThread null");
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)("----cwStop exception:" + e.getMessage()));
            }
        }
        return 0;
    }

    public void cwPushFrame(byte[] frameData, int frameW, int frameH, int frameFormat, int frameAngle, int frameMirror) {
        this.frameW = frameW;
        this.frameH = frameH;
        this.frameFormat = frameFormat;
        if (this.frameAngle != frameAngle || this.frameMirror != frameMirror) {
            TestLog.netE(TAG, "\u6444\u50cf\u5934,\u5c4f\u5e55\u65b9\u5411\u53d8 \u89d2\u5ea6=" + frameAngle + "\u955c\u50cf=" + frameMirror);
            this.cwClearBestFace();
        }
        this.frameAngle = frameAngle;
        this.frameMirror = frameMirror;
        if (TestLog.isDebug) {
            ++TestLog.frame;
        }
        long currentTime = System.currentTimeMillis();
        if (this.mStartTime == 0L) {
            this.mStartTime = currentTime;
        }
        try {
            switch (this.mWorkType) {
                case LIVE_DETECT: {
                    if (this.mPushFrame) {
                        this.mFrameQueue.put(new Frame(frameData, (currentTime - this.mStartTime) % 1000000L));
                        break;
                    }
                    this.mFrameQueue.clear();
                    break;
                }
                case REATIME_ANALYZE: {
                    this.mFrameQueue.put(new Frame(frameData, (currentTime - this.mStartTime) % 1000000L));
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("----cwPushFrame exception:" + e.getMessage()));
        }
    }

    public int cwReleaseDetector() {
        int sfRet = this.faceDetTrack.cwReleaseDetector(this.pDetector);
        return this.abs("cwReleaseDetector", sfRet);
    }

    public int cwResetLivenessTarget() {
        int sfRet = this.faceDetTrack.cwResetLivenessTarget(this.pDetector);
        return this.abs("cwResetLivenessTarget", sfRet);
    }

    public int cwVerifyBestImg() {
        return this.faceDetTrack.cwVerifyBestImg(this.pDetector);
    }

    public int cwFaceDetectTrack(byte[] data, long time, int width, int height, int format, int angle, int mirror, int op) {
        long start = System.currentTimeMillis();
        int result = this.faceDetTrack.cwFaceDetectTrack(this.pDetector, data, time, width, height, format, angle, mirror, op, this.stageflag, faceInfos);
        if (TestLog.isDebug) {
            ++TestLog.sfFrame;
            TestLog.logSf();
        }
        this.faceNum = FaceDetTrack.getInstance().mFaceNum;
        return result;
    }

    private void processVideoFrame(Frame frame) {
        if (frame.data == null || !this.bDetecting) {
            return;
        }
        this.faceNum = 0;
        Long startTime = System.currentTimeMillis();
        if (faceInfos == null) {
            faceInfos = new FaceInfo[maxFaceNum];
        }
        if (!this.bDetecting) {
            return;
        }
        int result = this.cwFaceDetectTrack(frame.data, frame.time, this.frameW, this.frameH, this.frameFormat, this.frameAngle, this.frameMirror, this.op);
        if (!this.bDetecting) {
            return;
        }
        TestLog.netE(TAG, "time=" + (System.currentTimeMillis() - startTime));
        this.doFaceInfo();
        if (this.mPushFrame && this.mWorkType == DetectType.LIVE_DETECT) {
            this.doLivessDetect(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doFaceInfo() {
        this.faceNum = FaceDetTrack.getInstance().mFaceNum;
        CloudwalkSDK cloudwalkSDK = this;
        synchronized (cloudwalkSDK) {
            if (this.faceInfoCallback == null) {
                return;
            }
            if (this.faceInfoCallback != null) {
                this.faceInfoCallback.detectFaceInfo(faceInfos, this.faceNum);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doLivessDetect(int result) {
        if (result >= 20000) {
            CloudwalkSDK cloudwalkSDK = this;
            synchronized (cloudwalkSDK) {
                if (this.livessCallBack != null) {
                    this.livessCallBack.detectInfo(result);
                    if (this.stageflag != 0 && this.stageflag != 1 && result == 20002) {
                        this.livessCallBack.OnActionNotStandard(700);
                    }
                }
            }
        }
        if (result > 1) {
            CloudwalkSDK cloudwalkSDK = this;
            synchronized (cloudwalkSDK) {
                if (this.livessCallBack != null) {
                    this.livessCallBack.detectInfo(result);
                }
            }
        }
        if (result == 1) {
            this.mFrameQueue.clear();
            this.cwResetLiving();
            if (this.stageflag == 1) {
                CloudwalkSDK cloudwalkSDK = this;
                synchronized (cloudwalkSDK) {
                    if (this.livessCallBack != null) {
                        this.livessCallBack.detectReady();
                    }
                }
                this.stageflag = 0;
            } else if (this.stageflag == 2 || this.stageflag == 4 || this.stageflag == 8 || this.stageflag == 16 || this.stageflag == 32 || this.stageflag == 64) {
                this.dolivess();
                this.stageflag = 0;
            }
        } else if (result != 0 && result < 0) {
            CloudwalkSDK cloudwalkSDK = this;
            synchronized (cloudwalkSDK) {
                if (this.livessCallBack != null) {
                    if (result == -4) {
                        this.livessCallBack.OnActionNotStandard(704);
                    } else if (result == -7) {
                        this.livessCallBack.OnActionNotStandard(702);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dolivess() {
        if (this.livessCallBack != null) {
            Bitmap bmp = null;
            Bitmap imageData = null;
            boolean isFront = this.frameMirror == 1;
            switch (this.livessType) {
                case 1000: {
                    TestLog.netd(TAG, "LivessType.LIVESS_HEAD_LEFT");
                    bmp = Utils.yuv2Img(this.mPreviewFrame.data, 17, this.frameW, this.frameH, 95);
                    imageData = Utils.rotaingImageView(bmp, this.frameAngle, this.frameMirror);
                    CloudwalkSDK cloudwalkSDK = this;
                    synchronized (cloudwalkSDK) {
                        if (this.livessCallBack != null) {
                            if (imageData != null) {
                                this.livessCallBack.detectLivess(604, Utils.bitmapToByte(imageData, Bitmap.CompressFormat.JPEG));
                            } else {
                                this.livessCallBack.detectLivess(604, null);
                            }
                        }
                    }
                    this.livessType = 0;
                    break;
                }
                case 1001: {
                    TestLog.netd(TAG, "LivessType.LIVESS_HEAD_RIGHT");
                    bmp = Utils.yuv2Img(this.mPreviewFrame.data, 17, this.frameW, this.frameH, 95);
                    imageData = Utils.rotaingImageView(bmp, this.frameAngle, this.frameMirror);
                    CloudwalkSDK cloudwalkSDK = this;
                    synchronized (cloudwalkSDK) {
                        if (this.livessCallBack != null) {
                            if (imageData != null) {
                                this.livessCallBack.detectLivess(605, Utils.bitmapToByte(imageData, Bitmap.CompressFormat.JPEG));
                            } else {
                                this.livessCallBack.detectLivess(605, null);
                            }
                        }
                    }
                    this.livessType = 0;
                    break;
                }
                case 1004: {
                    TestLog.netd(TAG, "LivessType.LIVESS_EYE");
                    bmp = Utils.yuv2Img(this.mPreviewFrame.data, 17, this.frameW, this.frameH, 95);
                    imageData = Utils.rotaingImageView(bmp, this.frameAngle, this.frameMirror);
                    CloudwalkSDK cloudwalkSDK = this;
                    synchronized (cloudwalkSDK) {
                        if (this.livessCallBack != null) {
                            if (imageData != null) {
                                this.livessCallBack.detectLivess(601, Utils.bitmapToByte(imageData, Bitmap.CompressFormat.JPEG));
                            } else {
                                this.livessCallBack.detectLivess(601, null);
                            }
                        }
                    }
                    this.livessType = 0;
                    break;
                }
                case 1005: {
                    TestLog.netd(TAG, "LivessType.LIVESS_MOUTH");
                    bmp = Utils.yuv2Img(this.mPreviewFrame.data, 17, this.frameW, this.frameH, 95);
                    imageData = Utils.rotaingImageView(bmp, this.frameAngle, this.frameMirror);
                    CloudwalkSDK cloudwalkSDK = this;
                    synchronized (cloudwalkSDK) {
                        if (this.livessCallBack != null) {
                            if (imageData != null) {
                                this.livessCallBack.detectLivess(600, Utils.bitmapToByte(imageData, Bitmap.CompressFormat.JPEG));
                            } else {
                                this.livessCallBack.detectLivess(600, null);
                            }
                        }
                    }
                    this.livessType = 0;
                    break;
                }
                case 1002: {
                    TestLog.netd(TAG, "LivessType.LIVESS_HEAD_UP");
                    bmp = Utils.yuv2Img(this.mPreviewFrame.data, 17, this.frameW, this.frameH, 95);
                    imageData = Utils.rotaingImageView(bmp, this.frameAngle, this.frameMirror);
                    CloudwalkSDK cloudwalkSDK = this;
                    synchronized (cloudwalkSDK) {
                        if (this.livessCallBack != null) {
                            if (imageData != null) {
                                this.livessCallBack.detectLivess(602, Utils.bitmapToByte(imageData, Bitmap.CompressFormat.JPEG));
                            } else {
                                this.livessCallBack.detectLivess(602, null);
                            }
                        }
                    }
                    this.livessType = 0;
                    break;
                }
                case 1003: {
                    TestLog.netd(TAG, "LivessType.LIVESS_HEAD_DOWN");
                    bmp = Utils.yuv2Img(this.mPreviewFrame.data, 17, this.frameW, this.frameH, 95);
                    imageData = Utils.rotaingImageView(bmp, this.frameAngle, this.frameMirror);
                    CloudwalkSDK cloudwalkSDK = this;
                    synchronized (cloudwalkSDK) {
                        if (this.livessCallBack != null) {
                            if (imageData != null) {
                                this.livessCallBack.detectLivess(603, Utils.bitmapToByte(imageData, Bitmap.CompressFormat.JPEG));
                            } else {
                                this.livessCallBack.detectLivess(603, null);
                            }
                        }
                    }
                    this.livessType = 0;
                }
            }
            Utils.recycleBitmap(bmp);
            Utils.recycleBitmap(imageData);
        }
    }

    public void setWorkType(DetectType type) {
        this.mWorkType = type;
    }

    public void setPushFrame(boolean pushFrame) {
        this.mPushFrame = pushFrame;
    }

    public void setStageflag(int stageflag) {
        this.cwResetLiving();
        this.stageflag = stageflag;
        this.mPushFrame = true;
        this.mFrameQueue.clear();
    }

    public void setTotalStep(int totalStep) {
        this.faceLivingImgs = null;
    }

    private int abs(String metName, int sfRet) {
        int ret = 0;
        if (sfRet != 0) {
            TestLog.netE("ret", metName + "\u53d8\u6362\u524dsfRet=" + sfRet);
            ret = Math.abs(sfRet);
            TestLog.netE("ret", metName + "\u53d8\u6362\u540eret=" + ret);
        }
        return ret;
    }

    static {
        param = new FaceParam();
        maxFaceNum = 2;
        faceInfos = new FaceInfo[maxFaceNum];
        param = new FaceParam();
        faceInfos = new FaceInfo[maxFaceNum];
        for (int i = 0; i < maxFaceNum; ++i) {
            CloudwalkSDK.faceInfos[i] = new FaceInfo();
        }
    }

    class VideoRecordRunnable
    implements Runnable {
        private PriorityBlockingQueue<Frame> mFrameQueue;

        public VideoRecordRunnable(PriorityBlockingQueue<Frame> mFrameQueue) {
            this.mFrameQueue = mFrameQueue;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            while (CloudwalkSDK.this.bDetecting) {
                try {
                    switch (CloudwalkSDK.this.mWorkType) {
                        case LIVE_DETECT: {
                            if (!CloudwalkSDK.this.mPushFrame) break;
                            CloudwalkSDK.this.mPreviewFrame = this.mFrameQueue.take();
                            this.mFrameQueue.clear();
                            CloudwalkSDK.this.processVideoFrame(CloudwalkSDK.this.mPreviewFrame);
                            break;
                        }
                        case REATIME_ANALYZE: {
                            CloudwalkSDK.this.mPreviewFrame = this.mFrameQueue.take();
                            this.mFrameQueue.clear();
                            CloudwalkSDK.this.processVideoFrame(CloudwalkSDK.this.mPreviewFrame);
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (CloudwalkSDK.this.bDetecting) continue;
                    CloudwalkSDK.this.bDetecting = false;
                    break;
                }
            }
            int ret = CloudwalkSDK.this.cwReleaseDetector();
        }
    }

    private class Frame
    implements Comparable<Frame> {
        byte[] data;
        long time;

        public Frame(byte[] data, long time) {
            this.data = data;
            this.time = time;
        }

        @Override
        public int compareTo(Frame o) {
            return this.time < o.time ? 1 : (this.time > o.time ? -1 : 0);
        }
    }

    public static enum DetectType {
        LIVE_DETECT,
        REATIME_ANALYZE;

    }
}

