/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject.camera;

import android.content.Context;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import cn.cloudwalk.CloudwalkSDK;
import cn.cloudwalk.libproject.camera.CameraConfigurationManager;
import cn.cloudwalk.libproject.camera.Delegate;
import cn.cloudwalk.libproject.util.LogUtils;

public class CameraPreview
extends SurfaceView
implements SurfaceHolder.Callback,
Camera.PreviewCallback {
    private static final String TAG = LogUtils.makeLogTag("CameraPreview");
    private Camera mCamera;
    Delegate mDelegate;
    private int orientation;
    private int mFrameCount = 0;
    int imageAngle = 0;
    private static final int DEFAULT_EXPOSURE = 0;
    private static final int DEFAULT_EXPOSURE_STEP = 1;
    private boolean mPushFrame = true;
    int caremaId = 1;
    private boolean mPreviewing = true;
    private boolean mSurfaceCreated = false;
    private CameraConfigurationManager mCameraConfigurationManager;
    Context context;
    int reqPrevW = 640;
    int reqPrevH = 480;

    public void setScreenOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getCaremaId() {
        return this.caremaId;
    }

    public void setCaremaId(int caremaId) {
        this.caremaId = caremaId;
    }

    public void setReqPrevWH(int reqPrevW, int reqPrevH) {
        this.reqPrevW = reqPrevW;
        this.reqPrevH = reqPrevH;
    }

    public CameraPreview(Context context) {
        super(context);
        this.context = context;
        this.mFrameCount = 0;
    }

    public CameraPreview(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.context = context;
        this.mFrameCount = 0;
    }

    public CameraPreview(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.mFrameCount = 0;
    }

    public void setCamera(Camera camera) {
        this.mCamera = camera;
        if (this.mCamera != null) {
            this.mCameraConfigurationManager = new CameraConfigurationManager(this.getContext());
            this.getHolder().addCallback((SurfaceHolder.Callback)this);
            if (this.mPreviewing) {
                this.requestLayout();
            } else {
                this.showCameraPreview();
            }
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.mSurfaceCreated = true;
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i2, int i3) {
        if (surfaceHolder.getSurface() == null) {
            return;
        }
        this.stopCameraPreview();
        this.showCameraPreview();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mSurfaceCreated = false;
        this.stopCameraPreview();
    }

    public void showCameraPreview() {
        if (this.mCamera != null) {
            try {
                this.mPreviewing = true;
                this.mCamera.setPreviewDisplay(this.getHolder());
                int degree = this.mCameraConfigurationManager.setCameraParametersForPreviewCallBack(this.mCamera, this.caremaId, this.reqPrevW, this.reqPrevH);
                this.imageAngle = this.getImageAngle(degree);
                this.mCamera.startPreview();
                this.mCamera.setPreviewCallback((Camera.PreviewCallback)this);
            }
            catch (Exception e) {
                LogUtils.LOGE(TAG, e.toString());
            }
        }
    }

    public void stopCameraPreview() {
        if (this.mCamera != null) {
            try {
                this.mPreviewing = false;
                this.mCamera.cancelAutoFocus();
                this.mCamera.setPreviewCallback(null);
                this.mCamera.stopPreview();
            }
            catch (Exception e) {
                LogUtils.LOGE(TAG, e.toString());
            }
        }
    }

    public void increaseExposure() {
        try {
            int current;
            Camera.Parameters params;
            if (this.mCamera != null && ((params = this.mCamera.getParameters()).getMaxExposureCompensation() != 0 || params.getMinExposureCompensation() != 0) && (current = params.getExposureCompensation()) + 1 <= params.getMaxExposureCompensation()) {
                params.setExposureCompensation(current + 1);
                this.mCamera.setParameters(params);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void decreaseExposure() {
        try {
            int current;
            Camera.Parameters params;
            if (this.mCamera != null && ((params = this.mCamera.getParameters()).getMaxExposureCompensation() != 0 || params.getMinExposureCompensation() != 0) && (current = params.getExposureCompensation()) - 1 >= params.getMinExposureCompensation()) {
                params.setExposureCompensation(current - 1);
                this.mCamera.setParameters(params);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openFlashlight() {
        if (this.flashLightAvaliable()) {
            this.mCameraConfigurationManager.openFlashlight(this.mCamera);
        }
    }

    public void closeFlashlight() {
        if (this.flashLightAvaliable()) {
            this.mCameraConfigurationManager.closeFlashlight(this.mCamera);
        }
    }

    private boolean flashLightAvaliable() {
        return this.mCamera != null && this.mPreviewing && this.mSurfaceCreated && this.getContext().getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }

    private int getImageAngle(int degree) {
        int angle = 0;
        switch (degree) {
            case 0: {
                angle = 0;
                break;
            }
            case 90: {
                angle = 3;
                break;
            }
            case 180: {
                angle = 2;
                break;
            }
            case 270: {
                angle = 1;
            }
        }
        return angle;
    }

    public Camera.Size getPreviewSize() {
        Camera.Parameters parameters = this.mCamera.getParameters();
        return parameters.getPreviewSize();
    }

    public void setDelegate(Delegate mDelegate) {
        this.mDelegate = mDelegate;
    }

    public void cwStartCamera() {
        block3: {
            if (this.mCamera != null) {
                return;
            }
            try {
                this.mCamera = Camera.open((int)this.caremaId);
            }
            catch (Exception e) {
                if (this.mDelegate == null) break block3;
                this.mDelegate.onOpenCameraError();
            }
        }
        this.setCamera(this.mCamera);
    }

    public void cwStopCamera() {
        if (this.mCamera != null) {
            this.stopCameraPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        ++this.mFrameCount;
        if (this.mFrameCount < 10) {
            return;
        }
        if (this.caremaId == 1) {
            if (1 == this.orientation) {
                CloudwalkSDK.getInstance().cwPushFrame(data, this.reqPrevW, this.reqPrevH, 5, this.imageAngle, 1);
            } else {
                CloudwalkSDK.getInstance().cwPushFrame(data, this.reqPrevW, this.reqPrevH, 5, this.imageAngle, 1);
            }
        } else if (1 == this.orientation) {
            CloudwalkSDK.getInstance().cwPushFrame(data, this.reqPrevW, this.reqPrevH, 5, this.imageAngle, 0);
        } else {
            CloudwalkSDK.getInstance().cwPushFrame(data, this.reqPrevW, this.reqPrevH, 5, this.imageAngle, 0);
        }
    }

    public int switchCarema() {
        this.cwStopCamera();
        this.caremaId = this.caremaId == 1 ? 0 : 1;
        this.cwStartCamera();
        return this.caremaId;
    }

    public void setPushFrame(boolean mPushFrame) {
        this.mPushFrame = mPushFrame;
    }
}

