/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.ProgressBar;

public class HorizontalProgressBarWithNumber
extends ProgressBar {
    private static final int DEFAULT_TEXT_SIZE = 22;
    private static final int DEFAULT_TEXT_COLOR = -16723594;
    private static final int DEFAULT_COLOR_UNREACHED_COLOR = -16723594;
    private static final int DEFAULT_HEIGHT_REACHED_PROGRESS_BAR = 2;
    private static final int DEFAULT_HEIGHT_UNREACHED_PROGRESS_BAR = 2;
    private static final int DEFAULT_SIZE_TEXT_OFFSET = 10;
    private static final int DEFAULT_REACHEDBAR_COLOR = -1;
    protected Paint mPaint = new Paint();
    protected int mTextColor = -16723594;
    protected int mTextSize = this.sp2px(22);
    protected int mTextOffset = this.dp2px(10);
    protected int mReachedProgressBarHeight = this.dp2px(2);
    protected int mReachedBarColor = -1;
    protected int mUnReachedBarColor = -16723594;
    protected int mUnReachedProgressBarHeight = this.dp2px(2);
    protected int mRealWidth;
    protected boolean mIfDrawText = true;
    protected static final int VISIBLE = 0;

    public HorizontalProgressBarWithNumber(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HorizontalProgressBarWithNumber(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.obtainStyledAttributes(attrs);
        this.mPaint.setTextSize((float)this.mTextSize);
        this.mPaint.setColor(this.mTextColor);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = this.measureHeight(heightMeasureSpec);
        this.setMeasuredDimension(width, height);
        this.mRealWidth = this.getMeasuredWidth() - this.getPaddingRight() - this.getPaddingLeft();
    }

    private int measureHeight(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            float textHeight = this.mPaint.descent() - this.mPaint.ascent();
            result = (int)((float)(this.getPaddingTop() + this.getPaddingBottom()) + Math.max((float)Math.max(this.mReachedProgressBarHeight, this.mUnReachedProgressBarHeight), Math.abs(textHeight)));
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    private void obtainStyledAttributes(AttributeSet attrs) {
        this.mUnReachedBarColor = -16723594;
        boolean textVisible = false;
        if (textVisible) {
            this.mIfDrawText = false;
        }
    }

    protected synchronized void onDraw(Canvas canvas) {
        float endX;
        canvas.save();
        canvas.translate((float)this.getPaddingLeft(), (float)(this.getHeight() / 2));
        boolean noNeedBg = false;
        float radio = (float)this.getProgress() * 1.0f / (float)this.getMax();
        float progressPosX = (int)((float)this.mRealWidth * radio);
        String text = this.getProgress() + "%";
        float textWidth = this.mPaint.measureText(text);
        float textHeight = (this.mPaint.descent() + this.mPaint.ascent()) / 2.0f;
        if (progressPosX + textWidth > (float)this.mRealWidth) {
            progressPosX = (float)this.mRealWidth - textWidth;
            noNeedBg = true;
        }
        if ((endX = progressPosX - (float)(this.mTextOffset / 2)) > 0.0f) {
            this.mPaint.setColor(this.mReachedBarColor);
            this.mPaint.setStrokeWidth((float)this.mReachedProgressBarHeight);
            canvas.drawLine(0.0f, 0.0f, endX, 0.0f, this.mPaint);
        }
        if (this.mIfDrawText) {
            this.mPaint.setColor(this.mTextColor);
            canvas.drawText(text, progressPosX, -textHeight, this.mPaint);
        }
        if (!noNeedBg) {
            float start = progressPosX + (float)(this.mTextOffset / 2) + textWidth;
            this.mPaint.setColor(this.mUnReachedBarColor);
            this.mPaint.setStrokeWidth((float)this.mUnReachedProgressBarHeight);
            canvas.drawLine(start, 0.0f, (float)this.mRealWidth, 0.0f, this.mPaint);
        }
        canvas.restore();
    }

    protected int dp2px(int dpVal) {
        return (int)TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    protected int sp2px(int spVal) {
        return (int)TypedValue.applyDimension((int)2, (float)spVal, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }
}

