/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject.camera;

import android.content.Context;
import android.graphics.Paint;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import cn.cloudwalk.BankOcrSDK;
import cn.cloudwalk.IDCardSDK;
import cn.cloudwalk.TestLog;
import cn.cloudwalk.libproject.camera.CameraConfigurationManager;
import cn.cloudwalk.libproject.camera.Delegate;
import cn.cloudwalk.libproject.util.LogUtils;

public class AutoFocusCameraPreview
extends SurfaceView
implements SurfaceHolder.Callback,
Camera.PreviewCallback {
    private static final String TAG = LogUtils.makeLogTag("AutoFocusCameraPreview");
    private Camera mCamera;
    int caremaId = 0;
    public static final int COLORTYPE_BGR = 1;
    public static final int COLORTYPE_BGRA = 2;
    public static final int COLORTYPE_YUV = 3;
    public static final int COLORTYPE_NV21 = 4;
    public static final int COLORTYPE_NV12 = 5;
    private int left_topx;
    private int left_topy;
    private int right_bottomx;
    private int right_bottomy;
    private int width;
    private int height;
    private int ocrRectH;
    private int ocrRectW;
    private boolean mPreviewing = true;
    private boolean mSurfaceCreated = false;
    int mScreenW = 0;
    int mScreenH = 0;
    Context context;
    float touchX;
    float touchY;
    Paint paint = new Paint();
    private CameraConfigurationManager mCameraConfigurationManager;
    int mFlag = -1;
    boolean mAutoRatio;
    private boolean mIsAutoMode = true;
    private Runnable doAutoFocus = new Runnable(){

        @Override
        public void run() {
            if (AutoFocusCameraPreview.this.mCamera != null && AutoFocusCameraPreview.this.mPreviewing && AutoFocusCameraPreview.this.mSurfaceCreated) {
                AutoFocusCameraPreview.this.autoFocus();
            }
        }
    };
    protected boolean isTouch = false;
    private boolean isFocusedOk = false;
    Camera.AutoFocusCallback autoFocusCB = new Camera.AutoFocusCallback(){

        public void onAutoFocus(boolean success, Camera camera) {
            AutoFocusCameraPreview.this.isFocusedOk = success;
            if (success) {
                AutoFocusCameraPreview.this.mDelegate.onFocused();
                AutoFocusCameraPreview.this.isTouch = false;
                if (AutoFocusCameraPreview.this.mIsAutoMode) {
                    AutoFocusCameraPreview.this.postDelayed(AutoFocusCameraPreview.this.doAutoFocus, 4000L);
                }
                LogUtils.LOGE("\u5bf9\u7126", "\u6210\u529f");
            } else {
                AutoFocusCameraPreview.this.postDelayed(AutoFocusCameraPreview.this.doAutoFocus, 2000L);
                LogUtils.LOGE("\u5bf9\u7126", "\u5931\u8d25");
            }
        }
    };
    Delegate mDelegate;
    SizeCallback _sizeCb = null;
    int mPerSecFrames = 0;
    int mCounter = 0;
    long mTimmer = 0L;

    public void setFlag(int flag) {
        this.mFlag = flag;
    }

    public void setAutoRatio(boolean mAutoRatio) {
        this.mAutoRatio = mAutoRatio;
    }

    public AutoFocusCameraPreview(Context context) {
        super(context);
        this.context = context;
    }

    public AutoFocusCameraPreview(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.context = context;
    }

    public AutoFocusCameraPreview(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.setKeepScreenOn(true);
    }

    public void setCamera(Camera camera) {
        this.mCamera = camera;
        if (this.mCamera != null) {
            this.mCameraConfigurationManager = new CameraConfigurationManager(this.getContext());
            this.mCameraConfigurationManager.initFromCameraParameters(this.mCamera);
            this.getHolder().addCallback((SurfaceHolder.Callback)this);
            if (this.mPreviewing) {
                this.requestLayout();
            } else {
                this.showCameraPreview();
            }
        }
    }

    public void setScreenSize(int screenW, int screenH) {
        this.mScreenW = screenW;
        this.mScreenH = screenH;
    }

    private void autoFocus() {
        try {
            if (this.mCamera != null) {
                this.mCamera.autoFocus(this.autoFocusCB);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.isTouch = true;
        this.touchX = event.getX();
        this.touchY = event.getY();
        this.mDelegate.onFocus(this.touchX, this.touchY);
        this.autoFocus();
        return super.onTouchEvent(event);
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.mSurfaceCreated = true;
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i2, int i3) {
        if (surfaceHolder.getSurface() == null) {
            return;
        }
        this.stopCameraPreview();
        this.showCameraPreview();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mSurfaceCreated = false;
        this.stopCameraPreview();
    }

    public void showCameraPreview() {
        if (this.mCamera != null) {
            try {
                this.mPreviewing = true;
                this.mCamera.setPreviewDisplay(this.getHolder());
                this.mCameraConfigurationManager.setDesiredCameraParameters(this.mCamera, this.caremaId, this.mIsAutoMode);
                this.mCamera.startPreview();
                this.mCamera.setPreviewCallback((Camera.PreviewCallback)this);
                if (this.mIsAutoMode) {
                    this.isFocusedOk = false;
                    this.postDelayed(this.doAutoFocus, 1000L);
                }
            }
            catch (Exception e) {
                LogUtils.LOGE(TAG, e.toString());
            }
        }
    }

    public void stopCameraPreview() {
        if (this.mCamera != null) {
            try {
                if (this.mIsAutoMode) {
                    this.isFocusedOk = false;
                    this.removeCallbacks(this.doAutoFocus);
                }
                this.mPreviewing = false;
                this.mCamera.cancelAutoFocus();
                this.mCamera.setPreviewCallback(null);
                this.mCamera.stopPreview();
            }
            catch (Exception e) {
                LogUtils.LOGE(TAG, e.toString());
            }
        }
    }

    public void openFlashlight() {
        if (this.flashLightAvaliable()) {
            this.mCameraConfigurationManager.openFlashlight(this.mCamera);
        }
    }

    public void closeFlashlight() {
        if (this.flashLightAvaliable()) {
            this.mCameraConfigurationManager.closeFlashlight(this.mCamera);
        }
    }

    private boolean flashLightAvaliable() {
        return this.mCamera != null && this.mPreviewing && this.mSurfaceCreated && this.getContext().getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }

    public Camera.Size getPreviewSize() {
        Camera.Parameters parameters = this.mCamera.getParameters();
        return parameters.getPreviewSize();
    }

    public void setDelegate(Delegate mDelegate) {
        this.mDelegate = mDelegate;
    }

    public void cwStartCamera() {
        block3: {
            if (this.mCamera != null) {
                return;
            }
            try {
                this.mCamera = Camera.open((int)this.caremaId);
            }
            catch (Exception e) {
                if (this.mDelegate == null) break block3;
                this.mDelegate.onOpenCameraError();
            }
        }
        this.setCamera(this.mCamera);
    }

    public void cwStopCamera() {
        if (this.mCamera != null) {
            this.stopCameraPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    public void setSizeCallback(SizeCallback cb) {
        this._sizeCb = cb;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        float ratio = 1.58f;
        this.width = w;
        this.height = h;
        if (this.getResources().getConfiguration().orientation == 2) {
            this.ocrRectW = this.width * 70 / 100;
            this.ocrRectH = (int)((float)this.ocrRectW / ratio);
        } else if (2 == this.mFlag && this.mAutoRatio) {
            this.ocrRectH = this.height * 70 / 100;
            this.ocrRectW = (int)((float)this.ocrRectH / ratio);
        } else {
            this.ocrRectW = this.width * 90 / 100;
            this.ocrRectH = (int)((float)this.ocrRectW / ratio);
        }
        if (null != this._sizeCb) {
            this._sizeCb.onSizeChange(this.width, this.height, this.ocrRectW, this.ocrRectH);
        }
    }

    protected void doSizeCalc(int nPictureW, int nPictureH) {
        float ratioW = 1.0f * (float)nPictureW / (float)this.width;
        float ratioH = 1.0f * (float)nPictureH / (float)this.height;
        int det = 0;
        int l = (this.width - this.ocrRectW) / 2 - det;
        int t = (this.height - this.ocrRectH) / 2 - det;
        int r = l + this.ocrRectW + det;
        int b = t + this.ocrRectH + det;
        this.left_topx = (int)((float)l * ratioW);
        this.left_topy = (int)((float)t * ratioH);
        this.right_bottomx = (int)((float)r * ratioW);
        this.right_bottomy = (int)((float)b * ratioH);
        TestLog.LogE((String)"\u5916\u6846\u5c3a\u5bf8", (String)(this.width + "x" + this.height));
        TestLog.LogE((String)"\u5185\u6846\u5c3a\u5bf8", (String)(this.ocrRectW + "x" + this.ocrRectH));
        TestLog.LogE((String)"\u5750\u6807", (String)String.format("\u5185\u6846\u539f\u59cb %d,%d,%d,%d \u8f6c\u6362\u540e %d,%d,%d,%d", l, t, r, b, this.left_topx, this.left_topy, this.right_bottomx, this.right_bottomy));
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        if (0 == this.mCounter++) {
            this.mTimmer = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.mTimmer >= 60000L) {
            this.mPerSecFrames = this.mCounter / 60;
            Log.w((String)"\u5e27\u7387/s", (String)("" + this.mPerSecFrames));
            this.mTimmer = System.currentTimeMillis();
            this.mCounter = 0;
        }
        Camera.Size size = this.getPreviewSize();
        int preWidth = size.width;
        int preHeight = size.height;
        if (this.isFocusedOk) {
            int w = preWidth;
            int h = preHeight;
            if (this.getResources().getConfiguration().orientation != 2 && w > h) {
                int tmp = w;
                w = h;
                h = tmp;
            }
            this.doSizeCalc(w, h);
            if (2 == this.mFlag) {
                BankOcrSDK.getInstance((Context)this.context).cwPushFrame(data, w, h, 4, this.left_topx, this.left_topy, this.right_bottomx, this.right_bottomy, this.getResources().getConfiguration().orientation);
            } else if (1 == this.mFlag || 0 == this.mFlag) {
                IDCardSDK.getInstance((Context)this.context).cwPushFrame(data, w, h, 4, this.mFlag, this.left_topx, this.left_topy, this.right_bottomx, this.right_bottomy);
            }
        }
    }

    public static byte[] rotateNV21Degree90(byte[] data, int imageWidth, int imageHeight) {
        int y;
        int x;
        byte[] yuv = new byte[imageWidth * imageHeight * 3 / 2];
        int i = 0;
        for (x = 0; x < imageWidth; ++x) {
            for (y = imageHeight - 1; y >= 0; --y) {
                yuv[i] = data[y * imageWidth + x];
                ++i;
            }
        }
        i = imageWidth * imageHeight * 3 / 2 - 1;
        for (x = imageWidth - 1; x > 0; x -= 2) {
            for (y = 0; y < imageHeight / 2; ++y) {
                yuv[i] = data[imageWidth * imageHeight + y * imageWidth + x];
                yuv[--i] = data[imageWidth * imageHeight + y * imageWidth + (x - 1)];
                --i;
            }
        }
        return yuv;
    }

    public static interface SizeCallback {
        public void onSizeChange(int var1, int var2, int var3, int var4);
    }
}

