/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import cn.cloudwalk.TestLog;
import cn.cloudwalk.jni.FaceLivingImg;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class Utils {
    Utils() {
    }

    static Bitmap yuv2Img(byte[] frameData, int yuvFormat, int prevWidth, int prevHeight, int quality) {
        Long start = System.currentTimeMillis();
        Bitmap img = null;
        try {
            YuvImage image = new YuvImage(frameData, yuvFormat, prevWidth, prevHeight, null);
            if (image != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                image.compressToJpeg(new Rect(0, 0, prevWidth, prevHeight), quality, (OutputStream)stream);
                img = BitmapFactory.decodeByteArray((byte[])stream.toByteArray(), (int)0, (int)stream.size());
                stream.close();
            }
        }
        catch (Exception ex) {
            TestLog.netE("ContentValues", "yuv2Img\u5f02\u5e38:" + ex.getMessage());
        }
        TestLog.netE("ContentValues", "yuv2Img" + (System.currentTimeMillis() - start));
        return img;
    }

    static Bitmap byteArrayBGRToBitmap(byte[] data, int width, int height) {
        if (data == null) {
            return null;
        }
        int frameSize = width * height;
        int[] rgba = new int[frameSize];
        for (int i = 0; i < height * width; ++i) {
            int r = 0xFF & data[i * 3];
            int g = 0xFF & data[i * 3 + 1];
            int b = 0xFF & data[i * 3 + 2];
            int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
            int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
            b = b < 0 ? 0 : (b > 255 ? 255 : b);
            rgba[i] = -16777216 + (b << 16) + (g << 8) + r;
        }
        Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bmp.setPixels(rgba, 0, width, 0, 0, width, height);
        return bmp;
    }

    static String cwGetFaceLivingImgInfo(FaceLivingImg faceLivingImg) {
        String keypt_X = "";
        String keypt_Y = "";
        if (faceLivingImg != null && faceLivingImg.pointX != null && faceLivingImg.pointY != null) {
            for (int i = 0; i < faceLivingImg.pointX.length; ++i) {
                if (i >= faceLivingImg.pointY.length) continue;
                keypt_X = keypt_X + faceLivingImg.pointX[i] + ",";
                keypt_Y = keypt_Y + faceLivingImg.pointY[i] + ",";
            }
            return keypt_X + keypt_Y + faceLivingImg.keyptScore + "," + faceLivingImg.pitch + "," + faceLivingImg.yaw + "," + faceLivingImg.roll;
        }
        return "";
    }

    static Bitmap rotaingImageView(Bitmap bitmap, int frameAngle, int frameMirror) {
        long start = System.currentTimeMillis();
        Matrix matrix = new Matrix();
        if (frameMirror == 1) {
            matrix.postScale(-1.0f, 1.0f);
            if (frameAngle == 1) {
                matrix.postRotate(270.0f);
            }
            if (frameAngle == 2) {
                matrix.postRotate(180.0f);
            }
            if (frameAngle == 3) {
                matrix.postRotate(90.0f);
            }
        } else {
            if (frameAngle == 1) {
                matrix.postRotate(270.0f);
            }
            if (frameAngle == 2) {
                matrix.postRotate(180.0f);
            }
            if (frameAngle == 3) {
                matrix.postRotate(90.0f);
            }
        }
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        TestLog.netE("2222", "rotaingImageView" + (System.currentTimeMillis() - start));
        return resizedBitmap;
    }

    static void saveJPGE_After(Bitmap bitmap, String path, int quality) {
        File file = new File(path);
        try {
            FileOutputStream out = new FileOutputStream(file);
            if (bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)out)) {
                out.flush();
                out.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static byte[] bitmapToByte(Bitmap b, Bitmap.CompressFormat format) {
        long start = System.currentTimeMillis();
        if (b == null) {
            return null;
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        b.compress(format, 80, (OutputStream)o);
        byte[] data = o.toByteArray();
        TestLog.netE("2222", "bitmapToByte" + (System.currentTimeMillis() - start));
        return data;
    }

    static void recycleBitmap(Bitmap bmpToRecycle) {
        if (bmpToRecycle != null && !bmpToRecycle.isRecycled()) {
            bmpToRecycle.recycle();
            bmpToRecycle = null;
        }
    }
}

