/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtil {
    public static final String TAG = "FileUtil";
    public static final File parentPath = Environment.getExternalStorageDirectory();
    public static final String DST_FOLDER_NAME = "FaceRecog";

    public static void mkDir(String dirPath) {
        String[] dirArray = dirPath.split("/");
        String pathTemp = "";
        for (int i = 1; i < dirArray.length; ++i) {
            pathTemp = pathTemp + "/" + dirArray[i];
            File newF = new File(dirArray[0] + pathTemp);
            if (newF.exists()) continue;
            newF.mkdir();
        }
    }

    public static String readRawFileToString(String rawFileName, AssetManager assetManager) {
        InputStream inputStream = null;
        try {
            inputStream = assetManager.open(rawFileName);
        }
        catch (IOException e) {
            Log.e((String)"tag", (String)e.getMessage());
        }
        if (inputStream != null) {
            return FileUtil.inputStreamToString(inputStream);
        }
        return null;
    }

    public static byte[] readRawFileToByteArray(String rawFileName, AssetManager assetManager) {
        InputStream inputStream = null;
        try {
            inputStream = assetManager.open(rawFileName);
        }
        catch (IOException e) {
            Log.e((String)"tag", (String)e.getMessage());
        }
        if (inputStream != null) {
            return FileUtil.inputStreamToByteArray(inputStream);
        }
        return null;
    }

    public static void copyRawFileToSdcard(String rawFileName, AssetManager assetManager, String outPutFileAbs) {
        InputStream inputStream = null;
        try {
            inputStream = assetManager.open(rawFileName);
        }
        catch (IOException e) {
            Log.e((String)"tag", (String)e.getMessage());
        }
        if (inputStream != null) {
            FileUtil.inputStreamToFile(inputStream, outPutFileAbs);
        }
    }

    public static String inputStreamToString(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int len = 0;
        try {
            while ((len = inputStream.read(buf)) != -1) {
                outputStream.write(buf, 0, len);
            }
            outputStream.close();
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputStream.toString();
    }

    public static byte[] inputStreamToByteArray(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int len = 0;
        try {
            while ((len = inputStream.read(buf)) != -1) {
                outputStream.write(buf, 0, len);
            }
            outputStream.close();
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputStream.toByteArray();
    }

    public static void inputStreamToFile(InputStream inputStream, String absPath) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int len = 0;
        try {
            while ((len = inputStream.read(buf)) != -1) {
                outputStream.write(buf, 0, len);
            }
            outputStream.close();
            inputStream.close();
            byte[] imgBytes = outputStream.toByteArray();
            try (FileOutputStream fos = new FileOutputStream(absPath, false);){
                fos.write(imgBytes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    FileUtil.deleteFile(files[i]);
                }
            }
            file.delete();
        }
    }

    public static void assetsDataToDest(Context context, String origin, String destination) throws IOException {
        InputStream input = context.getAssets().open(origin);
        try (FileOutputStream output = new FileOutputStream(destination);){
            byte[] buffer = new byte[1024];
            int length = input.read(buffer);
            while (length > 0) {
                ((OutputStream)output).write(buffer, 0, length);
                length = input.read(buffer);
            }
            output.flush();
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unZipFolder(String zipFileString, String outPathString) throws Exception {
        try (ZipInputStream inZip = new ZipInputStream(new FileInputStream(zipFileString));){
            ZipEntry zipEntry;
            String szName = "";
            while ((zipEntry = inZip.getNextEntry()) != null) {
                szName = zipEntry.getName();
                if (zipEntry.isDirectory()) {
                    szName = szName.substring(0, szName.length() - 1);
                    File folder = new File(outPathString + File.separator + szName);
                    folder.mkdirs();
                    continue;
                }
                File file = new File(outPathString + File.separator + szName);
                file.createNewFile();
                try {
                    FileOutputStream out = new FileOutputStream(file);
                    Throwable throwable = null;
                    try {
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = inZip.read(buffer)) != -1) {
                            out.write(buffer, 0, len);
                            out.flush();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

