/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import cn.cloudwalk.libproject.util.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

public class ImgUtil {
    private static final String TAG = LogUtils.makeLogTag("ImgUtil");
    public static final int COLOR_FormatI420 = 1;
    public static final int COLOR_FormatNV21 = 2;

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int inSampleSizeH = Math.round((float)height / (float)reqHeight);
            int inSampleSizeW = Math.round((float)width / (float)reqWidth);
            inSampleSize = Math.max(inSampleSizeH, inSampleSizeW);
        }
        if (inSampleSize > 1 && inSampleSize % 2 == 1) {
            ++inSampleSize;
        }
        while (width / inSampleSize > reqWidth || height / inSampleSize > reqHeight) {
            ++inSampleSize;
        }
        return inSampleSize;
    }

    public static Bitmap decodeSampledBitmapFromResource(Resources res, int resId, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
        options.inSampleSize = ImgUtil.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
    }

    public static Bitmap decodeSampledBitmapFromPath(String filePath, int reqWidth, int reqHeight, Bitmap.Config config) {
        int inSampleSize;
        Bitmap bitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        options.inSampleSize = inSampleSize = ImgUtil.calculateInSampleSize(options, reqWidth, reqHeight);
        try {
            options.inJustDecodeBounds = false;
            if (config == null) {
                config = Bitmap.Config.RGB_565;
            }
            options.inPreferredConfig = config;
            bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            try {
                options.inSampleSize = inSampleSize + 2;
                options.inJustDecodeBounds = false;
                if (config == null) {
                    config = Bitmap.Config.RGB_565;
                }
                options.inPreferredConfig = config;
                bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            }
            catch (OutOfMemoryError e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        return bitmap;
    }

    public static Bitmap byteArrayBGRToBitmap(byte[] data, int width, int height) {
        int frameSize = width * height;
        int[] rgba = new int[frameSize];
        for (int i = 0; i < height * width; ++i) {
            int r = 0xFF & data[i * 3];
            int g = 0xFF & data[i * 3 + 1];
            int b = 0xFF & data[i * 3 + 2];
            int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
            int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
            b = b < 0 ? 0 : (b > 255 ? 255 : b);
            rgba[i] = -16777216 + (b << 16) + (g << 8) + r;
        }
        Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bmp.setPixels(rgba, 0, width, 0, 0, width, height);
        return bmp;
    }

    public static Bitmap zoomPic(String imgPath, int w, int h, Bitmap.Config config) {
        Bitmap bitmap = ImgUtil.decodeSampledBitmapFromPath(imgPath, w, h, config);
        return bitmap;
    }

    public static Bitmap zoomBitmap(Bitmap bitmap, int w, int h) {
        Bitmap newbmp = null;
        try {
            if (bitmap != null) {
                int width = bitmap.getWidth();
                int height = bitmap.getHeight();
                if (width < w && height < h) {
                    return bitmap;
                }
                Matrix matrix = new Matrix();
                float scaleWidht = (float)w / (float)width;
                float scaleHeight = (float)h / (float)height;
                if (scaleWidht > scaleHeight) {
                    matrix.postScale(scaleHeight, scaleHeight);
                } else {
                    matrix.postScale(scaleWidht, scaleWidht);
                }
                newbmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
                bitmap.recycle();
                bitmap = null;
            }
        }
        catch (Error e) {
            e.printStackTrace();
        }
        return newbmp;
    }

    public static Bitmap toGrayscale(Bitmap bmpOriginal) {
        Bitmap bmpGrayscale = null;
        try {
            int height = bmpOriginal.getHeight();
            int width = bmpOriginal.getWidth();
            bmpGrayscale = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
            Canvas c = new Canvas(bmpGrayscale);
            Paint paint = new Paint();
            ColorMatrix cm = new ColorMatrix();
            cm.setSaturation(0.0f);
            ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
            paint.setColorFilter((ColorFilter)f);
            c.drawBitmap(bmpOriginal, 0.0f, 0.0f, paint);
        }
        catch (Error e) {
            e.printStackTrace();
        }
        return bmpGrayscale;
    }

    public static int[] scaleImageSize(int[] img_size, int square_size) {
        if (img_size[0] <= square_size && img_size[1] <= square_size) {
            return img_size;
        }
        double ratio = (double)square_size / (double)Math.max(img_size[0], img_size[1]);
        return new int[]{(int)((double)img_size[0] * ratio), (int)((double)img_size[1] * ratio)};
    }

    public static Bitmap createImageThumbnail(Context context, String largeImagePath, int square_size) throws IOException {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inSampleSize = 1;
        Bitmap cur_bitmap = ImgUtil.getBitmapByPath(largeImagePath, opts);
        if (cur_bitmap == null) {
            return null;
        }
        int[] cur_img_size = new int[]{cur_bitmap.getWidth(), cur_bitmap.getHeight()};
        int[] new_img_size = ImgUtil.scaleImageSize(cur_img_size, square_size);
        if (new_img_size[0] > square_size) {
            return ImgUtil.zoomBitmap(cur_bitmap, new_img_size[0], new_img_size[1]);
        }
        return cur_bitmap;
    }

    public static void savePNG_After(Bitmap bitmap, String path, int quality) {
        File file = new File(path);
        try {
            FileOutputStream out = new FileOutputStream(file);
            if (bitmap.compress(Bitmap.CompressFormat.PNG, quality, (OutputStream)out)) {
                out.flush();
                out.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Bitmap jpgByteArrayToBitmap(byte[] data) {
        Bitmap bitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPurgeable = true;
        bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        return bitmap;
    }

    public static void saveJPGE_After(Bitmap bitmap, String path, int quality) {
        File file = new File(path);
        try {
            FileOutputStream out = new FileOutputStream(file);
            if (bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)out)) {
                out.flush();
                out.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Bitmap drawableToBitmapByBD(Drawable drawable2) {
        BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
        return bitmapDrawable.getBitmap();
    }

    public static Drawable bitmapToDrawableByBD(Bitmap bitmap) {
        BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
        return drawable2;
    }

    public static Bitmap bytesToBimap(byte[] b) {
        if (b.length != 0) {
            return BitmapFactory.decodeByteArray((byte[])b, (int)0, (int)b.length);
        }
        return null;
    }

    public static byte[] bitmapToByte(Bitmap b, Bitmap.CompressFormat format, int quality) {
        if (b == null) {
            return null;
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        b.compress(format, quality, (OutputStream)o);
        byte[] data = o.toByteArray();
        try {
            o.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    private static void scanPhoto(Context ctx, String imgFileName) {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        File file = new File(imgFileName);
        Uri contentUri = Uri.fromFile((File)file);
        mediaScanIntent.setData(contentUri);
        ctx.sendBroadcast(mediaScanIntent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap getBitmapByFile(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            Bitmap bitmap2;
            Bitmap bitmap = bitmap2 = BitmapFactory.decodeStream((InputStream)fis);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap getBitmapByPath(String filePath) {
        return ImgUtil.getBitmapByPath(filePath, null);
    }

    public static String getTempFileName() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_SS");
        String fileName = format.format(new Timestamp(System.currentTimeMillis()));
        return fileName;
    }

    public static Bitmap getBitmapByPath(String filePath, BitmapFactory.Options opts) {
        Bitmap bitmap = null;
        File file = new File(filePath);
        try (FileInputStream fis = new FileInputStream(file);){
            bitmap = BitmapFactory.decodeStream((InputStream)fis, null, (BitmapFactory.Options)opts);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    private static String getPathDeprecated(Context context, Uri uri) {
        if (uri == null) {
            return null;
        }
        String[] projection = new String[]{"_data"};
        Cursor cursor = context.getContentResolver().query(uri, projection, null, null, null);
        if (cursor != null) {
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            return cursor.getString(column_index);
        }
        return uri.getPath();
    }

    public static String getSmartFilePath(Context context, Uri uri) {
        if (Build.VERSION.SDK_INT < 19) {
            return ImgUtil.getPathDeprecated(context, uri);
        }
        return ImgUtil.getPath(context, uri);
    }

    @SuppressLint(value={"NewApi"})
    public static String getPath(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (ImgUtil.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (ImgUtil.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                    return ImgUtil.getDataColumn(context, contentUri, null, null);
                }
                if (ImgUtil.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return ImgUtil.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                return ImgUtil.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                return string2;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static String md5(String paramString) {
        try {
            MessageDigest localMessageDigest = MessageDigest.getInstance("MD5");
            localMessageDigest.update(paramString.getBytes());
            String returnStr = ImgUtil.byteToHexString(localMessageDigest.digest());
            return returnStr;
        }
        catch (Exception e) {
            return paramString;
        }
    }

    public static void startImgIntent(Activity act, int requestCode) {
        if (Build.VERSION.SDK_INT < 19) {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.GET_CONTENT");
            intent.setType("image/*");
            act.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"\u9009\u62e9\u56fe\u7247"), requestCode);
        } else {
            Intent intent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            intent.setType("image/*");
            act.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"\u9009\u62e9\u56fe\u7247"), requestCode);
        }
    }

    public static String byteToHexString(byte[] b) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            hexString.append(hex.toUpperCase());
        }
        return hexString.toString();
    }

    public static int readPictureDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    public static Bitmap rotaingImageView(int angle, Bitmap bitmap) {
        Bitmap resizedBitmap = null;
        try {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)angle);
            resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (Error e) {
            e.printStackTrace();
        }
        return resizedBitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String saveImageToGallery(Context ctx, Bitmap source, String title, String description) {
        String stringUrl;
        Uri url;
        block8: {
            ContentResolver cr = ctx.getContentResolver();
            ContentValues values = new ContentValues();
            values.put("title", title);
            values.put("_display_name", title);
            values.put("description", description);
            values.put("mime_type", "image/jpeg");
            values.put("date_added", Long.valueOf(System.currentTimeMillis()));
            values.put("datetaken", Long.valueOf(System.currentTimeMillis()));
            url = null;
            stringUrl = null;
            try {
                url = cr.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
                if (source != null) {
                    try (OutputStream imageOut = cr.openOutputStream(url);){
                        source.compress(Bitmap.CompressFormat.JPEG, 50, imageOut);
                    }
                    long id2 = ContentUris.parseId((Uri)url);
                    Bitmap miniThumb = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)cr, (long)id2, (int)1, null);
                    ImgUtil.storeThumbnail(cr, miniThumb, id2, 50.0f, 50.0f, 3);
                    break block8;
                }
                cr.delete(url, null, null);
                url = null;
            }
            catch (Exception e) {
                if (url == null) break block8;
                cr.delete(url, null, null);
                url = null;
            }
        }
        if (url != null) {
            stringUrl = url.toString();
        }
        return stringUrl;
    }

    private static final Bitmap storeThumbnail(ContentResolver cr, Bitmap source, long id2, float width, float height, int kind) {
        try {
            Matrix matrix = new Matrix();
            float scaleX = width / (float)source.getWidth();
            float scaleY = height / (float)source.getHeight();
            matrix.setScale(scaleX, scaleY);
            Bitmap thumb = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
            ContentValues values = new ContentValues(4);
            values.put("kind", Integer.valueOf(kind));
            values.put("image_id", Integer.valueOf((int)id2));
            values.put("height", Integer.valueOf(thumb.getHeight()));
            values.put("width", Integer.valueOf(thumb.getWidth()));
            Uri url = cr.insert(MediaStore.Images.Thumbnails.EXTERNAL_CONTENT_URI, values);
            OutputStream thumbOut = cr.openOutputStream(url);
            thumb.compress(Bitmap.CompressFormat.JPEG, 100, thumbOut);
            thumbOut.close();
            return thumb;
        }
        catch (Exception ex) {
            return null;
        }
        catch (Error ex) {
            return null;
        }
    }

    public static void saveImageToGallery(Context context, Bitmap bmp, String dirPath) {
        String fileName = System.currentTimeMillis() + ".jpg";
        File file = new File(dirPath, fileName);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            bmp.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            MediaStore.Images.Media.insertImage((ContentResolver)context.getContentResolver(), (String)file.getAbsolutePath(), (String)fileName, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        context.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse((String)("file://" + file.getAbsolutePath()))));
    }

    public static Bitmap addRects(Rect[] rects, Bitmap src) {
        Bitmap newBM = null;
        try {
            int w = src.getWidth();
            int h = src.getHeight();
            Paint paint = new Paint();
            int color2 = Color.rgb((int)98, (int)212, (int)68);
            paint.setColor(color2);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(9.0f);
            paint.setAlpha(180);
            newBM = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_4444);
            Canvas canvas = new Canvas(newBM);
            canvas.drawBitmap(src, 0.0f, 0.0f, null);
            int len = rects.length;
            for (int i = 0; i < len; ++i) {
                canvas.drawRect(rects[i], paint);
            }
        }
        catch (Error e) {
            e.printStackTrace();
        }
        return newBM;
    }

    public static File weixinCompress(File file, String thumbFilePath) {
        double size;
        String filePath = file.getAbsolutePath();
        int angle = ImgUtil.getImageSpinAngle(filePath);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inSampleSize = 1;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int width = options.outWidth;
        int height = options.outHeight;
        int thumbW = width % 2 == 1 ? width + 1 : width;
        int thumbH = height % 2 == 1 ? height + 1 : height;
        width = thumbW > thumbH ? thumbH : thumbW;
        height = thumbW > thumbH ? thumbW : thumbH;
        double scale = (double)width / (double)height;
        if (scale <= 1.0 && scale > 0.5625) {
            if (height < 1664) {
                if (file.length() / 1024L < 150L) {
                    return file;
                }
                size = (double)(width * height) / Math.pow(1664.0, 2.0) * 150.0;
                size = size < 60.0 ? 60.0 : size;
            } else if (height >= 1664 && height < 4990) {
                thumbW = width / 2;
                thumbH = height / 2;
                size = (double)(thumbW * thumbH) / Math.pow(2495.0, 2.0) * 300.0;
                size = size < 60.0 ? 60.0 : size;
            } else if (height >= 4990 && height < 10240) {
                thumbW = width / 4;
                thumbH = height / 4;
                size = (double)(thumbW * thumbH) / Math.pow(2560.0, 2.0) * 300.0;
                size = size < 100.0 ? 100.0 : size;
            } else {
                int multiple = height / 1280 == 0 ? 1 : height / 1280;
                thumbW = width / multiple;
                thumbH = height / multiple;
                size = (double)(thumbW * thumbH) / Math.pow(2560.0, 2.0) * 300.0;
                size = size < 100.0 ? 100.0 : size;
            }
        } else if (scale <= 0.5625 && scale > 0.5) {
            if (height < 1280 && file.length() / 1024L < 200L) {
                return file;
            }
            int multiple = height / 1280 == 0 ? 1 : height / 1280;
            thumbW = width / multiple;
            thumbH = height / multiple;
            size = (double)(thumbW * thumbH) / 3686400.0 * 400.0;
            size = size < 100.0 ? 100.0 : size;
        } else {
            int multiple = (int)Math.ceil((double)height / (1280.0 / scale));
            thumbW = width / multiple;
            size = (double)(thumbW * (thumbH = height / multiple)) / (1280.0 * (1280.0 / scale)) * 500.0;
            size = size < 100.0 ? 100.0 : size;
        }
        return ImgUtil.compress(filePath, thumbFilePath, thumbW, thumbH, angle, (long)size);
    }

    private static int getImageSpinAngle(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    private static Bitmap compress(String imagePath, int width, int height) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        int outH = options.outHeight;
        int outW = options.outWidth;
        int inSampleSize = 1;
        if (outH > height || outW > width) {
            int halfH = outH / 2;
            int halfW = outW / 2;
            while (halfH / inSampleSize > height && halfW / inSampleSize > width) {
                inSampleSize *= 2;
            }
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        int heightRatio = (int)Math.ceil((float)options.outHeight / (float)height);
        int widthRatio = (int)Math.ceil((float)options.outWidth / (float)width);
        if (heightRatio > 1 || widthRatio > 1) {
            options.inSampleSize = heightRatio > widthRatio ? heightRatio : widthRatio;
        }
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
    }

    private static File compress(String largeImagePath, String thumbFilePath, int width, int height, int angle, long size) {
        Bitmap thbBitmap = ImgUtil.compress(largeImagePath, width, height);
        if (angle > 0) {
            thbBitmap = ImgUtil.rotatingImage(angle, thbBitmap);
        }
        return ImgUtil.saveImage(thumbFilePath, thbBitmap, size);
    }

    private static Bitmap rotatingImage(int angle, Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private static File saveImage(String filePath, Bitmap bitmap, long size) {
        File result = new File(filePath.substring(0, filePath.lastIndexOf("/")));
        if (!result.exists() && !result.mkdirs()) {
            return null;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int options = 100;
        bitmap.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)stream);
        while ((long)(stream.toByteArray().length / 1024) > size && options > 6) {
            stream.reset();
            bitmap.compress(Bitmap.CompressFormat.JPEG, options -= 6, (OutputStream)stream);
        }
        LogUtils.LOGE(TAG, "jpg\u4fdd\u5b58\u8d28\u91cf:" + options + "\u56fe\u7247\u5927\u5c0f:" + bitmap.getWidth() + ";" + bitmap.getHeight());
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            fos.write(stream.toByteArray());
            fos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new File(filePath);
    }
}

