/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject.util;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Environment;
import android.util.Log;
import cn.cloudwalk.libproject.util.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Util {
    public static final String AppName = "FaceRecog";
    public static final String FACE_THRESHOLD = "0";
    private static final String TAG = "Util";
    private static boolean DEBUG = true;

    public static boolean isChineseLanguage() {
        Locale l = Locale.getDefault();
        String language = l.getLanguage();
        String country = l.getCountry().toLowerCase();
        boolean isChineseLanguage = "zh".equals(language);
        return isChineseLanguage;
    }

    public static String getTimeStamp() {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
    }

    public static String getFilePath(String suffix) {
        String filePath = FileUtil.parentPath + File.separator + AppName + File.separator + Util.getTimeStamp() + "" + suffix;
        Log.e((String)TAG, (String)filePath);
        return filePath;
    }

    public static String getBeBetweenTime(long start_time) {
        long video_time = System.currentTimeMillis() - start_time;
        int secs = (int)((video_time /= 1000L) % 60L);
        int mins = (int)((video_time /= 60L) % 60L);
        long hours = video_time /= 60L;
        return hours + ":" + String.format("%02d", mins) + ":" + String.format("%02d", secs);
    }

    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        byte[] data = outStream.toByteArray();
        outStream.close();
        inStream.close();
        return data;
    }

    public static final String MD5(String pwd) {
        char[] md5String = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        try {
            byte[] btInput = pwd.getBytes();
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = md5String[byte0 >>> 4 & 0xF];
                str[k++] = md5String[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDiskCacheDir(Context context) {
        String cachePath = null;
        if ("mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable()) {
            cachePath = context.getExternalCacheDir().getPath();
        }
        if (cachePath == null) {
            cachePath = context.getCacheDir().getPath();
        }
        return cachePath;
    }

    public static byte[] getBytesFromStream(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int len = 0;
        while ((len = is.read(b, 0, 1024)) != -1) {
            baos.write(b, 0, len);
            baos.flush();
        }
        byte[] bytes = baos.toByteArray();
        baos.close();
        return bytes;
    }

    public static boolean isScreenPortrait(Context ctx) {
        Configuration mConfiguration = ctx.getResources().getConfiguration();
        int ori = mConfiguration.orientation;
        if (ori == 2) {
            return false;
        }
        if (ori == 1) {
            return true;
        }
        return true;
    }

    public static int getStatusBarHeight(Context ctx) {
        Class<?> c = null;
        Object obj = null;
        Field field = null;
        int x = 0;
        int sbar = 40;
        try {
            c = Class.forName("com.android.internal.R$dimen");
            obj = c.newInstance();
            field = c.getField("status_bar_height");
            x = Integer.parseInt(field.get(obj).toString());
            sbar = ctx.getResources().getDimensionPixelSize(x);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return sbar;
    }

    public static String bytes2kb(long bytes) {
        BigDecimal filesize = new BigDecimal(bytes);
        BigDecimal megabyte = new BigDecimal(0x100000);
        float returnValue = filesize.divide(megabyte, 2, 0).floatValue();
        if (returnValue > 1.0f) {
            return returnValue + "MB";
        }
        BigDecimal kilobyte = new BigDecimal(1024);
        returnValue = filesize.divide(kilobyte, 2, 0).floatValue();
        return returnValue + "KB";
    }
}

