/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import com.baidu.idl.face.platform.utils.DensityUtils;

public class FaceDetectRoundView
extends View {
    private static final String TAG = FaceDetectRoundView.class.getSimpleName();
    public static final float SURFACE_HEIGHT = 1000.0f;
    public static final float SURFACE_RATIO = 0.75f;
    public static final float WIDTH_SPACE_RATIO = 0.33f;
    public static final float HEIGHT_RATIO = 0.1f;
    public static final float HEIGHT_EXT_RATIO = 0.2f;
    public static final int CIRCLE_SPACE = 5;
    public static final int PATH_SPACE = 16;
    public static final int PATH_SMALL_SPACE = 12;
    public static final int PATH_WIDTH = 4;
    public static final int COLOR_BG = Color.parseColor((String)"#2F2F33");
    public static final int COLOR_RECT = Color.parseColor((String)"#FFFFFF");
    public static final int COLOR_ROUND = Color.parseColor((String)"#FFA800");
    private PathEffect mFaceRoundPathEffect = null;
    private Paint mBGPaint;
    private Paint mPathPaint;
    private Paint mFaceRectPaint;
    private Paint mFaceRoundPaint;
    private Rect mFaceRect;
    private Rect mFaceDetectRect;
    private float mX;
    private float mY;
    private float mR;
    private boolean mIsDrawDash = true;

    public FaceDetectRoundView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setLayerType(1, null);
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        float pathSpace = DensityUtils.dip2px((Context)context, (float)16.0f);
        float pathSmallSpace = DensityUtils.dip2px((Context)context, (float)12.0f);
        float pathWidth = DensityUtils.dip2px((Context)context, (float)4.0f);
        this.mFaceRoundPathEffect = new DashPathEffect(new float[]{pathSpace, (float)dm.heightPixels < 1000.0f ? pathSmallSpace : pathSpace}, 1.0f);
        this.mBGPaint = new Paint(1);
        this.mBGPaint.setColor(COLOR_BG);
        this.mBGPaint.setStyle(Paint.Style.FILL);
        this.mBGPaint.setAntiAlias(true);
        this.mBGPaint.setDither(true);
        this.mPathPaint = new Paint(1);
        this.mPathPaint.setColor(COLOR_ROUND);
        this.mPathPaint.setStrokeWidth(pathWidth);
        this.mPathPaint.setStyle(Paint.Style.STROKE);
        this.mPathPaint.setAntiAlias(true);
        this.mPathPaint.setDither(true);
        this.mFaceRectPaint = new Paint(1);
        this.mFaceRectPaint.setColor(COLOR_RECT);
        this.mFaceRectPaint.setStrokeWidth(pathWidth);
        this.mFaceRectPaint.setStyle(Paint.Style.STROKE);
        this.mFaceRectPaint.setAntiAlias(true);
        this.mFaceRectPaint.setDither(true);
        this.mFaceRoundPaint = new Paint(1);
        this.mFaceRoundPaint.setColor(COLOR_ROUND);
        this.mFaceRoundPaint.setStyle(Paint.Style.FILL);
        this.mFaceRoundPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.mFaceRoundPaint.setAntiAlias(true);
        this.mFaceRoundPaint.setDither(true);
    }

    public void processDrawState(boolean isDrawDash) {
        this.mIsDrawDash = isDrawDash;
        this.postInvalidate();
    }

    public float getRound() {
        return this.mR;
    }

    public Rect getFaceRoundRect() {
        if (this.mFaceRect != null) {
            Log.e((String)TAG, (String)this.mFaceRect.toString());
        }
        return this.mFaceRect;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        float canvasWidth = right - left;
        float canvasHeight = bottom - top;
        float x = canvasWidth / 2.0f;
        float y = canvasHeight / 2.0f - canvasHeight / 2.0f * 0.1f;
        float r = canvasWidth / 2.0f - canvasWidth / 2.0f * 0.33f;
        if (this.mFaceRect == null) {
            this.mFaceRect = new Rect((int)(x - r), (int)(y - r), (int)(x + r), (int)(y + r));
        }
        if (this.mFaceDetectRect == null) {
            float hr = r + r * 0.2f;
            this.mFaceDetectRect = new Rect((int)(x - r), (int)(y - hr), (int)(x + r), (int)(y + hr));
        }
        this.mX = x;
        this.mY = y;
        this.mR = r;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawColor(0);
        canvas.drawPaint(this.mBGPaint);
        if (this.mIsDrawDash) {
            this.mPathPaint.setPathEffect(this.mFaceRoundPathEffect);
        } else {
            this.mPathPaint.setPathEffect(null);
        }
        canvas.drawCircle(this.mX, this.mY, this.mR + 5.0f, this.mPathPaint);
        canvas.drawCircle(this.mX, this.mY, this.mR, this.mFaceRoundPaint);
    }

    public static Rect getPreviewDetectRect(int w, int pw, int ph) {
        float round = (float)(w / 2) - (float)(w / 2) * 0.33f;
        float x = pw / 2;
        float y = (float)(ph / 2) - (float)(ph / 2) * 0.1f;
        float r = (float)(pw / 2) > round ? round : (float)(pw / 2);
        float hr = r + r * 0.2f;
        Rect rect = new Rect((int)(x - r), (int)(y - hr), (int)(x + r), (int)(y + hr));
        return rect;
    }
}

