/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.hardware.Camera;
import android.media.AudioManager;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.baidu.idl.face.platform.FaceConfig;
import com.baidu.idl.face.platform.FaceSDKManager;
import com.baidu.idl.face.platform.FaceStatusNewEnum;
import com.baidu.idl.face.platform.IDetectStrategy;
import com.baidu.idl.face.platform.IDetectStrategyCallback;
import com.baidu.idl.face.platform.model.ImageInfo;
import com.baidu.idl.face.platform.ui.FaceSDKResSettings;
import com.baidu.idl.face.platform.ui.R;
import com.baidu.idl.face.platform.ui.utils.BrightnessUtils;
import com.baidu.idl.face.platform.ui.utils.CameraUtils;
import com.baidu.idl.face.platform.ui.utils.VolumeUtils;
import com.baidu.idl.face.platform.ui.widget.FaceDetectRoundView;
import com.baidu.idl.face.platform.utils.APIUtils;
import com.baidu.idl.face.platform.utils.Base64Utils;
import com.baidu.idl.face.platform.utils.CameraPreviewUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FaceDetectActivity
extends Activity
implements SurfaceHolder.Callback,
Camera.PreviewCallback,
Camera.ErrorCallback,
VolumeUtils.VolumeCallback,
IDetectStrategyCallback {
    public static final String TAG = FaceDetectActivity.class.getSimpleName();
    protected View mRootView;
    protected FrameLayout mFrameLayout;
    protected SurfaceView mSurfaceView;
    protected SurfaceHolder mSurfaceHolder;
    protected ImageView mCloseView;
    protected ImageView mSoundView;
    protected ImageView mSuccessView;
    protected TextView mTipsTopView;
    protected FaceDetectRoundView mFaceDetectRoundView;
    protected LinearLayout mImageLayout;
    protected LinearLayout mImageLayout2;
    private View mViewBg;
    protected FaceConfig mFaceConfig;
    protected IDetectStrategy mIDetectStrategy;
    private Rect mPreviewRect = new Rect();
    protected int mDisplayWidth = 0;
    protected int mDisplayHeight = 0;
    protected int mSurfaceWidth = 0;
    protected int mSurfaceHeight = 0;
    protected Drawable mTipsIcon;
    protected volatile boolean mIsEnableSound = true;
    protected HashMap<String, String> mBase64ImageMap = new HashMap();
    protected boolean mIsCreateSurface = false;
    protected volatile boolean mIsCompletion = false;
    protected Camera mCamera;
    protected Camera.Parameters mCameraParam;
    protected int mCameraId;
    protected int mPreviewWidth;
    protected int mPreviewHight;
    protected int mPreviewDegree;
    protected BroadcastReceiver mVolumeReceiver;
    private String mBmpStr;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setScreenBright();
        this.getWindow().addFlags(128);
        this.setContentView(R.layout.activity_face_detect_v3100);
        DisplayMetrics dm = new DisplayMetrics();
        Display display = this.getWindowManager().getDefaultDisplay();
        display.getMetrics(dm);
        this.mDisplayWidth = dm.widthPixels;
        this.mDisplayHeight = dm.heightPixels;
        FaceSDKResSettings.initializeResId();
        this.mFaceConfig = FaceSDKManager.getInstance().getFaceConfig();
        AudioManager am = (AudioManager)this.getSystemService("audio");
        int vol = am.getStreamVolume(3);
        this.mIsEnableSound = vol > 0 ? this.mFaceConfig.isSound() : false;
        this.mRootView = this.findViewById(R.id.detect_root_layout);
        this.mFrameLayout = (FrameLayout)this.mRootView.findViewById(R.id.detect_surface_layout);
        this.mSurfaceView = new SurfaceView((Context)this);
        this.mSurfaceHolder = this.mSurfaceView.getHolder();
        this.mSurfaceHolder.setSizeFromLayout();
        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.mSurfaceHolder.setType(3);
        int w = this.mDisplayWidth;
        int h = this.mDisplayHeight;
        FrameLayout.LayoutParams cameraFL = new FrameLayout.LayoutParams((int)((float)w * 0.75f), (int)((float)h * 0.75f), 17);
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)cameraFL);
        this.mFrameLayout.addView((View)this.mSurfaceView);
        this.mRootView.findViewById(R.id.detect_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaceDetectActivity.this.onBackPressed();
            }
        });
        this.mFaceDetectRoundView = (FaceDetectRoundView)this.mRootView.findViewById(R.id.detect_face_round);
        this.mFaceDetectRoundView.setIsActiveLive(false);
        this.mCloseView = (ImageView)this.mRootView.findViewById(R.id.detect_close);
        this.mSoundView = (ImageView)this.mRootView.findViewById(R.id.detect_sound);
        this.mSoundView.setImageResource(this.mIsEnableSound ? R.mipmap.icon_titlebar_voice2 : R.drawable.collect_image_voice_selector);
        this.mSoundView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaceDetectActivity.this.mIsEnableSound = !FaceDetectActivity.this.mIsEnableSound;
                FaceDetectActivity.this.mSoundView.setImageResource(FaceDetectActivity.this.mIsEnableSound ? R.mipmap.icon_titlebar_voice2 : R.drawable.collect_image_voice_selector);
                if (FaceDetectActivity.this.mIDetectStrategy != null) {
                    FaceDetectActivity.this.mIDetectStrategy.setDetectStrategySoundEnable(FaceDetectActivity.this.mIsEnableSound);
                }
            }
        });
        this.mTipsTopView = (TextView)this.mRootView.findViewById(R.id.detect_top_tips);
        this.mSuccessView = (ImageView)this.mRootView.findViewById(R.id.detect_success_image);
        this.mImageLayout = (LinearLayout)this.mRootView.findViewById(R.id.detect_result_image_layout);
        this.mImageLayout2 = (LinearLayout)this.mRootView.findViewById(R.id.detect_result_image_layout2);
        this.mViewBg = this.findViewById(R.id.view_bg);
        if (this.mBase64ImageMap != null) {
            this.mBase64ImageMap.clear();
        }
    }

    private void setScreenBright() {
        int currentBright = BrightnessUtils.getScreenBrightness(this);
        BrightnessUtils.setBrightness(this, currentBright + 100);
    }

    public void onResume() {
        super.onResume();
        this.setVolumeControlStream(3);
        this.mVolumeReceiver = VolumeUtils.registerVolumeReceiver((Context)this, this);
        if (this.mFaceDetectRoundView != null) {
            this.mFaceDetectRoundView.setTipTopText("\u8bf7\u5c06\u8138\u79fb\u5165\u53d6\u666f\u6846");
        }
        this.startPreview();
    }

    public void onPause() {
        if (this.mIDetectStrategy != null) {
            this.mIDetectStrategy.reset();
        }
        super.onPause();
        VolumeUtils.unRegisterVolumeReceiver((Context)this, this.mVolumeReceiver);
        this.mVolumeReceiver = null;
        this.mIsCompletion = false;
        this.stopPreview();
    }

    public void onStop() {
        super.onStop();
    }

    public void finish() {
        super.finish();
    }

    @Override
    public void volumeChanged() {
        try {
            AudioManager am = (AudioManager)this.getSystemService("audio");
            if (am != null) {
                int cv = am.getStreamVolume(3);
                this.mIsEnableSound = cv > 0;
                this.mSoundView.setImageResource(this.mIsEnableSound ? R.mipmap.icon_titlebar_voice2 : R.mipmap.icon_titlebar_voice1);
                if (this.mIDetectStrategy != null) {
                    this.mIDetectStrategy.setDetectStrategySoundEnable(this.mIsEnableSound);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Camera open() {
        Camera camera;
        int index;
        int numCameras = Camera.getNumberOfCameras();
        if (numCameras == 0) {
            return null;
        }
        for (index = 0; index < numCameras; ++index) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)index, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing == 1) break;
        }
        if (index < numCameras) {
            camera = Camera.open((int)index);
            this.mCameraId = index;
        } else {
            camera = Camera.open((int)0);
            this.mCameraId = 0;
        }
        return camera;
    }

    protected void startPreview() {
        if (this.mSurfaceView != null && this.mSurfaceView.getHolder() != null) {
            this.mSurfaceHolder = this.mSurfaceView.getHolder();
            this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        }
        if (this.mCamera == null) {
            try {
                this.mCamera = this.open();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.mCamera == null) {
            return;
        }
        if (this.mCameraParam == null) {
            this.mCameraParam = this.mCamera.getParameters();
        }
        this.mCameraParam.setPictureFormat(256);
        int degree = this.displayOrientation((Context)this);
        this.mCamera.setDisplayOrientation(degree);
        this.mCameraParam.set("rotation", degree);
        this.mPreviewDegree = degree;
        if (this.mIDetectStrategy != null) {
            this.mIDetectStrategy.setPreviewDegree(degree);
        }
        Point point = CameraPreviewUtils.getBestPreview((Camera.Parameters)this.mCameraParam, (Point)new Point(this.mDisplayWidth, this.mDisplayHeight));
        this.mPreviewWidth = point.x;
        this.mPreviewHight = point.y;
        this.mPreviewRect.set(0, 0, this.mPreviewHight, this.mPreviewWidth);
        this.mCameraParam.setPreviewSize(this.mPreviewWidth, this.mPreviewHight);
        this.mCamera.setParameters(this.mCameraParam);
        try {
            this.mCamera.setPreviewDisplay(this.mSurfaceHolder);
            this.mCamera.stopPreview();
            this.mCamera.setErrorCallback((Camera.ErrorCallback)this);
            this.mCamera.setPreviewCallback((Camera.PreviewCallback)this);
            this.mCamera.startPreview();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            CameraUtils.releaseCamera(this.mCamera);
            this.mCamera = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            CameraUtils.releaseCamera(this.mCamera);
            this.mCamera = null;
        }
    }

    protected void stopPreview() {
        if (this.mCamera != null) {
            try {
                this.mCamera.setErrorCallback(null);
                this.mCamera.setPreviewCallback(null);
                this.mCamera.stopPreview();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                CameraUtils.releaseCamera(this.mCamera);
                this.mCamera = null;
            }
        }
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.removeCallback((SurfaceHolder.Callback)this);
        }
        if (this.mIDetectStrategy != null) {
            this.mIDetectStrategy.reset();
            this.mIDetectStrategy = null;
        }
    }

    private int displayOrientation(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        int rotation = windowManager.getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
                break;
            }
            default: {
                degrees = 0;
            }
        }
        int result = (0 - degrees + 360) % 360;
        if (APIUtils.hasGingerbread()) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)this.mCameraId, (Camera.CameraInfo)info);
            if (info.facing == 1) {
                result = (info.orientation + degrees) % 360;
                result = (360 - result) % 360;
            } else {
                result = (info.orientation - degrees + 360) % 360;
            }
        }
        return result;
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mIsCreateSurface = true;
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.mSurfaceWidth = width;
        this.mSurfaceHeight = height;
        if (holder.getSurface() == null) {
            return;
        }
        this.startPreview();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mIsCreateSurface = false;
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        if (this.mIsCompletion) {
            return;
        }
        if (this.mIDetectStrategy == null && this.mFaceDetectRoundView != null && this.mFaceDetectRoundView.getRound() > 0.0f) {
            this.mIDetectStrategy = FaceSDKManager.getInstance().getDetectStrategyModule();
            this.mIDetectStrategy.setPreviewDegree(this.mPreviewDegree);
            this.mIDetectStrategy.setDetectStrategySoundEnable(this.mIsEnableSound);
            Rect detectRect = FaceDetectRoundView.getPreviewDetectRect(this.mDisplayWidth, this.mPreviewHight, this.mPreviewWidth);
            this.mIDetectStrategy.setDetectStrategyConfig(this.mPreviewRect, detectRect, (IDetectStrategyCallback)this);
        }
        if (this.mIDetectStrategy != null) {
            this.mIDetectStrategy.detectStrategy(data);
        }
    }

    public void onError(int error, Camera camera) {
    }

    public void onDetectCompletion(FaceStatusNewEnum status, String message, HashMap<String, ImageInfo> base64ImageCropMap, HashMap<String, ImageInfo> base64ImageSrcMap) {
        if (this.mIsCompletion) {
            return;
        }
        this.onRefreshView(status, message);
        if (status == FaceStatusNewEnum.OK) {
            this.mIsCompletion = true;
            this.saveImage(base64ImageCropMap, base64ImageSrcMap);
        }
    }

    private void onRefreshView(FaceStatusNewEnum status, String message) {
        switch (status) {
            case OK: {
                this.mFaceDetectRoundView.setTipTopText(message);
                break;
            }
            case DetectRemindCodePitchOutofUpRange: 
            case DetectRemindCodePitchOutofDownRange: 
            case DetectRemindCodeYawOutofLeftRange: 
            case DetectRemindCodeYawOutofRightRange: {
                this.mFaceDetectRoundView.setTipTopText(message);
                break;
            }
            default: {
                this.mFaceDetectRoundView.setTipTopText(message);
            }
        }
    }

    private void saveImage(HashMap<String, ImageInfo> imageCropMap, HashMap<String, ImageInfo> imageSrcMap) {
        if (imageCropMap != null && imageCropMap.size() > 0) {
            ArrayList<Map.Entry<String, ImageInfo>> list1 = new ArrayList<Map.Entry<String, ImageInfo>>(imageCropMap.entrySet());
            Collections.sort(list1, new Comparator<Map.Entry<String, ImageInfo>>(){

                @Override
                public int compare(Map.Entry<String, ImageInfo> o1, Map.Entry<String, ImageInfo> o2) {
                    String[] key1 = o1.getKey().split("_");
                    String score1 = key1[2];
                    String[] key2 = o2.getKey().split("_");
                    String score2 = key2[2];
                    return Float.valueOf(score2).compareTo(Float.valueOf(score1));
                }
            });
        }
        if (imageSrcMap != null && imageSrcMap.size() > 0) {
            ArrayList<Map.Entry<String, ImageInfo>> list2 = new ArrayList<Map.Entry<String, ImageInfo>>(imageSrcMap.entrySet());
            Collections.sort(list2, new Comparator<Map.Entry<String, ImageInfo>>(){

                @Override
                public int compare(Map.Entry<String, ImageInfo> o1, Map.Entry<String, ImageInfo> o2) {
                    String[] key1 = o1.getKey().split("_");
                    String score1 = key1[2];
                    String[] key2 = o2.getKey().split("_");
                    String score2 = key2[2];
                    return Float.valueOf(score2).compareTo(Float.valueOf(score1));
                }
            });
            this.mBmpStr = ((ImageInfo)((Map.Entry)list2.get(0)).getValue()).getBase64();
        }
    }

    private static Bitmap base64ToBitmap(String base64Data) {
        byte[] bytes = Base64Utils.decode((String)base64Data, (int)2);
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    private void saveAllImage(HashMap<String, ImageInfo> imageCropMap, HashMap<String, ImageInfo> imageSrcMap) {
        if (imageCropMap != null && imageCropMap.size() > 0) {
            ArrayList<Map.Entry<String, ImageInfo>> list1 = new ArrayList<Map.Entry<String, ImageInfo>>(imageCropMap.entrySet());
            Collections.sort(list1, new Comparator<Map.Entry<String, ImageInfo>>(){

                @Override
                public int compare(Map.Entry<String, ImageInfo> o1, Map.Entry<String, ImageInfo> o2) {
                    String[] key1 = o1.getKey().split("_");
                    String score1 = key1[2];
                    String[] key2 = o2.getKey().split("_");
                    String score2 = key2[2];
                    return Float.valueOf(score2).compareTo(Float.valueOf(score1));
                }
            });
            this.mBmpStr = ((ImageInfo)((Map.Entry)list1.get(0)).getValue()).getBase64();
            this.setImageView1(list1);
        }
        if (imageSrcMap != null && imageSrcMap.size() > 0) {
            ArrayList<Map.Entry<String, ImageInfo>> list2 = new ArrayList<Map.Entry<String, ImageInfo>>(imageSrcMap.entrySet());
            Collections.sort(list2, new Comparator<Map.Entry<String, ImageInfo>>(){

                @Override
                public int compare(Map.Entry<String, ImageInfo> o1, Map.Entry<String, ImageInfo> o2) {
                    String[] key1 = o1.getKey().split("_");
                    String score1 = key1[2];
                    String[] key2 = o2.getKey().split("_");
                    String score2 = key2[2];
                    return Float.valueOf(score2).compareTo(Float.valueOf(score1));
                }
            });
            this.mBmpStr = ((ImageInfo)((Map.Entry)list2.get(0)).getValue()).getBase64();
            this.setImageView2(list2);
        }
    }

    private void setImageView1(List<Map.Entry<String, ImageInfo>> list) {
        Bitmap bmp = null;
        this.mImageLayout.removeAllViews();
        for (Map.Entry<String, ImageInfo> entry : list) {
            bmp = FaceDetectActivity.base64ToBitmap(entry.getValue().getBase64());
            ImageView iv = new ImageView((Context)this);
            iv.setImageBitmap(bmp);
            this.mImageLayout.addView((View)iv, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(300, 300));
        }
    }

    private void setImageView2(List<Map.Entry<String, ImageInfo>> list) {
        Bitmap bmp = null;
        this.mImageLayout2.removeAllViews();
        for (Map.Entry<String, ImageInfo> entry : list) {
            bmp = FaceDetectActivity.base64ToBitmap(entry.getValue().getBase64());
            ImageView iv = new ImageView((Context)this);
            iv.setImageBitmap(bmp);
            this.mImageLayout2.addView((View)iv, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(300, 300));
        }
    }
}

