/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.Camera;
import android.media.AudioManager;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.baidu.idl.face.platform.FaceConfig;
import com.baidu.idl.face.platform.FaceSDKManager;
import com.baidu.idl.face.platform.FaceStatusNewEnum;
import com.baidu.idl.face.platform.ILivenessStrategy;
import com.baidu.idl.face.platform.ILivenessStrategyCallback;
import com.baidu.idl.face.platform.ILivenessViewCallback;
import com.baidu.idl.face.platform.LivenessTypeEnum;
import com.baidu.idl.face.platform.model.ImageInfo;
import com.baidu.idl.face.platform.ui.FaceSDKResSettings;
import com.baidu.idl.face.platform.ui.R;
import com.baidu.idl.face.platform.ui.utils.BrightnessUtils;
import com.baidu.idl.face.platform.ui.utils.CameraUtils;
import com.baidu.idl.face.platform.ui.utils.FaceInfoCache;
import com.baidu.idl.face.platform.ui.utils.VolumeUtils;
import com.baidu.idl.face.platform.ui.widget.FaceDetectRoundView;
import com.baidu.idl.face.platform.utils.APIUtils;
import com.baidu.idl.face.platform.utils.Base64Utils;
import com.baidu.idl.face.platform.utils.CameraPreviewUtils;
import com.baidu.idl.face.platform.utils.DensityUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FaceLivenessActivity
extends Activity
implements SurfaceHolder.Callback,
Camera.PreviewCallback,
Camera.ErrorCallback,
VolumeUtils.VolumeCallback,
ILivenessStrategyCallback,
ILivenessViewCallback {
    public static final String TAG = FaceLivenessActivity.class.getSimpleName();
    protected View mRootView;
    protected FrameLayout mFrameLayout;
    protected SurfaceView mSurfaceView;
    protected SurfaceHolder mSurfaceHolder;
    protected ImageView mCloseView;
    protected ImageView mSoundView;
    protected ImageView mSuccessView;
    protected TextView mTipsTopView;
    protected FaceDetectRoundView mFaceDetectRoundView;
    protected LinearLayout mImageLayout;
    protected LinearLayout mImageLayout2;
    private RelativeLayout mRelativeAddImageView;
    private ImageView mImageAnim;
    private View mViewBg;
    protected FaceConfig mFaceConfig;
    protected ILivenessStrategy mILivenessStrategy;
    private Rect mPreviewRect = new Rect();
    protected int mDisplayWidth = 0;
    protected int mDisplayHeight = 0;
    protected int mSurfaceWidth = 0;
    protected int mSurfaceHeight = 0;
    protected Drawable mTipsIcon;
    protected volatile boolean mIsEnableSound = true;
    protected boolean mIsCreateSurface = false;
    protected boolean mIsCompletion = false;
    protected Camera mCamera;
    protected Camera.Parameters mCameraParam;
    protected int mCameraId;
    protected int mPreviewWidth;
    protected int mPreviewHight;
    protected int mPreviewDegree;
    protected BroadcastReceiver mVolumeReceiver;
    private String mBmpStr;
    private Context mContext;
    private AnimationDrawable mAnimationDrawable;
    private LivenessTypeEnum mLivenessType = null;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setScreenBright();
        this.getWindow().addFlags(128);
        this.setContentView(R.layout.activity_face_liveness_v3100);
        this.mContext = this;
        DisplayMetrics dm = new DisplayMetrics();
        Display display = this.getWindowManager().getDefaultDisplay();
        display.getMetrics(dm);
        this.mDisplayWidth = dm.widthPixels;
        this.mDisplayHeight = dm.heightPixels;
        FaceSDKResSettings.initializeResId();
        this.mFaceConfig = FaceSDKManager.getInstance().getFaceConfig();
        AudioManager am = (AudioManager)this.getSystemService("audio");
        int vol = am.getStreamVolume(3);
        this.mIsEnableSound = vol > 0 ? this.mFaceConfig.isSound() : false;
        this.mRootView = this.findViewById(R.id.liveness_root_layout);
        this.mFrameLayout = (FrameLayout)this.mRootView.findViewById(R.id.liveness_surface_layout);
        this.mSurfaceView = new SurfaceView((Context)this);
        this.mSurfaceHolder = this.mSurfaceView.getHolder();
        this.mSurfaceHolder.setSizeFromLayout();
        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.mSurfaceHolder.setType(3);
        this.initPreview();
        this.mRootView.findViewById(R.id.liveness_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaceLivenessActivity.this.onBackPressed();
            }
        });
        this.mFaceDetectRoundView = (FaceDetectRoundView)this.mRootView.findViewById(R.id.liveness_face_round);
        this.mFaceDetectRoundView.setIsActiveLive(true);
        this.mCloseView = (ImageView)this.mRootView.findViewById(R.id.liveness_close);
        this.mSoundView = (ImageView)this.mRootView.findViewById(R.id.liveness_sound);
        this.mSoundView.setImageResource(this.mIsEnableSound ? R.mipmap.ic_enable_sound : R.mipmap.ic_disable_sound);
        this.mSoundView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaceLivenessActivity.this.mIsEnableSound = !FaceLivenessActivity.this.mIsEnableSound;
                FaceLivenessActivity.this.mSoundView.setImageResource(FaceLivenessActivity.this.mIsEnableSound ? R.mipmap.ic_enable_sound : R.mipmap.ic_disable_sound);
                if (FaceLivenessActivity.this.mILivenessStrategy != null) {
                    FaceLivenessActivity.this.mILivenessStrategy.setLivenessStrategySoundEnable(FaceLivenessActivity.this.mIsEnableSound);
                }
            }
        });
        this.mTipsTopView = (TextView)this.mRootView.findViewById(R.id.liveness_top_tips);
        this.mSuccessView = (ImageView)this.mRootView.findViewById(R.id.liveness_success_image);
        this.mImageLayout = (LinearLayout)this.mRootView.findViewById(R.id.liveness_result_image_layout);
        this.mImageLayout2 = (LinearLayout)this.mRootView.findViewById(R.id.liveness_result_image_layout2);
        this.mRelativeAddImageView = (RelativeLayout)this.mRootView.findViewById(R.id.relative_add_image_view);
        this.addImageView();
        this.mViewBg = this.findViewById(R.id.view_live_bg);
    }

    private void initPreview() {
        try {
            this.mCamera = this.open();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int w = (int)((float)this.mDisplayWidth * 0.75f);
        int h = (int)((float)this.mDisplayHeight * 0.75f);
        if (this.mCamera != null) {
            Point point = CameraPreviewUtils.getBestPreview((Camera.Parameters)this.mCamera.getParameters(), (Point)new Point(this.mDisplayWidth, this.mDisplayHeight));
            float scale = (float)point.x / (float)point.y;
            h = (int)((float)w * scale);
        }
        FrameLayout.LayoutParams cameraFL = new FrameLayout.LayoutParams(w, h, 17);
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)cameraFL);
        this.mFrameLayout.addView((View)this.mSurfaceView);
    }

    private void setScreenBright() {
        int currentBright = BrightnessUtils.getScreenBrightness(this);
        BrightnessUtils.setBrightness(this, currentBright + 100);
    }

    private void addImageView() {
        this.mFaceDetectRoundView.post(new Runnable(){

            @Override
            public void run() {
                FaceLivenessActivity.this.mImageAnim = new ImageView((Context)FaceLivenessActivity.this);
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.height = DensityUtils.dip2px((Context)FaceLivenessActivity.this.mContext, (float)110.0f);
                layoutParams.width = DensityUtils.dip2px((Context)FaceLivenessActivity.this.mContext, (float)87.0f);
                float halfHeight = FaceLivenessActivity.this.mFaceDetectRoundView.getHeight() / 2;
                layoutParams.setMargins(0, (int)(halfHeight - halfHeight * 0.1f) - layoutParams.height / 2, 0, 0);
                layoutParams.addRule(14);
                FaceLivenessActivity.this.mImageAnim.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                FaceLivenessActivity.this.mImageAnim.setScaleType(ImageView.ScaleType.FIT_XY);
                FaceLivenessActivity.this.mRelativeAddImageView.addView((View)FaceLivenessActivity.this.mImageAnim);
            }
        });
    }

    public void onResume() {
        super.onResume();
        this.setVolumeControlStream(3);
        this.mVolumeReceiver = VolumeUtils.registerVolumeReceiver((Context)this, this);
        if (this.mFaceDetectRoundView != null) {
            this.mFaceDetectRoundView.setTipTopText("\u8bf7\u5c06\u8138\u79fb\u5165\u53d6\u666f\u6846");
        }
        this.startPreview();
    }

    protected void onRestart() {
        super.onRestart();
        Log.e((String)TAG, (String)"onRestart");
    }

    public void onPause() {
        if (this.mILivenessStrategy != null) {
            this.mILivenessStrategy.reset();
        }
        VolumeUtils.unRegisterVolumeReceiver((Context)this, this.mVolumeReceiver);
        this.mVolumeReceiver = null;
        this.mFaceDetectRoundView.setProcessCount(0, this.mFaceConfig.getLivenessTypeList().size());
        super.onPause();
        this.stopPreview();
        this.mIsCompletion = false;
    }

    public void onStop() {
        super.onStop();
    }

    public void finish() {
        super.finish();
    }

    @Override
    public void volumeChanged() {
        try {
            AudioManager am = (AudioManager)this.getSystemService("audio");
            if (am != null) {
                int cv = am.getStreamVolume(3);
                this.mIsEnableSound = cv > 0;
                this.mSoundView.setImageResource(this.mIsEnableSound ? R.mipmap.icon_titlebar_voice2 : R.mipmap.icon_titlebar_voice1);
                if (this.mILivenessStrategy != null) {
                    this.mILivenessStrategy.setLivenessStrategySoundEnable(this.mIsEnableSound);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Camera open() {
        Camera camera;
        int index;
        int numCameras = Camera.getNumberOfCameras();
        if (numCameras == 0) {
            return null;
        }
        for (index = 0; index < numCameras; ++index) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)index, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing == 1) break;
        }
        if (index < numCameras) {
            camera = Camera.open((int)index);
            this.mCameraId = index;
        } else {
            camera = Camera.open((int)0);
            this.mCameraId = 0;
        }
        return camera;
    }

    protected void startPreview() {
        if (this.mSurfaceView != null && this.mSurfaceView.getHolder() != null) {
            this.mSurfaceHolder = this.mSurfaceView.getHolder();
            this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        }
        if (this.mCamera == null) {
            try {
                this.mCamera = this.open();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.mCamera == null) {
            return;
        }
        if (this.mCameraParam == null) {
            this.mCameraParam = this.mCamera.getParameters();
        }
        this.mCameraParam.setPictureFormat(256);
        int degree = this.displayOrientation((Context)this);
        this.mCamera.setDisplayOrientation(degree);
        this.mCameraParam.set("rotation", degree);
        this.mPreviewDegree = degree;
        Point point = CameraPreviewUtils.getBestPreview((Camera.Parameters)this.mCameraParam, (Point)new Point(this.mDisplayWidth, this.mDisplayHeight));
        this.mPreviewWidth = point.x;
        this.mPreviewHight = point.y;
        Log.e((String)TAG, (String)("x = " + this.mPreviewWidth + " y = " + this.mPreviewHight));
        if (this.mILivenessStrategy != null) {
            this.mILivenessStrategy.setPreviewDegree(degree);
        }
        this.mPreviewRect.set(0, 0, this.mPreviewHight, this.mPreviewWidth);
        this.mCameraParam.setPreviewSize(this.mPreviewWidth, this.mPreviewHight);
        this.mCamera.setParameters(this.mCameraParam);
        try {
            this.mCamera.setPreviewDisplay(this.mSurfaceHolder);
            this.mCamera.stopPreview();
            this.mCamera.setErrorCallback((Camera.ErrorCallback)this);
            this.mCamera.setPreviewCallback((Camera.PreviewCallback)this);
            this.mCamera.startPreview();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            CameraUtils.releaseCamera(this.mCamera);
            this.mCamera = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            CameraUtils.releaseCamera(this.mCamera);
            this.mCamera = null;
        }
    }

    protected void stopPreview() {
        if (this.mCamera != null) {
            try {
                this.mCamera.setErrorCallback(null);
                this.mCamera.setPreviewCallback(null);
                this.mCamera.stopPreview();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                CameraUtils.releaseCamera(this.mCamera);
                this.mCamera = null;
            }
        }
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.removeCallback((SurfaceHolder.Callback)this);
        }
        if (this.mILivenessStrategy != null) {
            this.mILivenessStrategy = null;
        }
    }

    private int displayOrientation(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        int rotation = windowManager.getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
                break;
            }
            default: {
                degrees = 0;
            }
        }
        int result = (0 - degrees + 360) % 360;
        if (APIUtils.hasGingerbread()) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)this.mCameraId, (Camera.CameraInfo)info);
            if (info.facing == 1) {
                result = (info.orientation + degrees) % 360;
                result = (360 - result) % 360;
            } else {
                result = (info.orientation - degrees + 360) % 360;
            }
        }
        return result;
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mIsCreateSurface = true;
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.mSurfaceWidth = width;
        this.mSurfaceHeight = height;
        if (holder.getSurface() == null) {
            return;
        }
        this.startPreview();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mIsCreateSurface = false;
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        if (this.mIsCompletion) {
            return;
        }
        if (this.mILivenessStrategy == null) {
            this.mILivenessStrategy = FaceSDKManager.getInstance().getLivenessStrategyModule((ILivenessViewCallback)this);
            this.mILivenessStrategy.setPreviewDegree(this.mPreviewDegree);
            this.mILivenessStrategy.setLivenessStrategySoundEnable(this.mIsEnableSound);
            Rect detectRect = FaceDetectRoundView.getPreviewDetectRect(this.mDisplayWidth, this.mPreviewHight, this.mPreviewWidth);
            this.mILivenessStrategy.setLivenessStrategyConfig(this.mFaceConfig.getLivenessTypeList(), this.mPreviewRect, detectRect, (ILivenessStrategyCallback)this);
        }
        this.mILivenessStrategy.livenessStrategy(data);
    }

    public void onError(int error, Camera camera) {
    }

    public void onLivenessCompletion(FaceStatusNewEnum status, String message, HashMap<String, ImageInfo> base64ImageCropMap, HashMap<String, ImageInfo> base64ImageSrcMap, int currentLivenessCount) {
        if (this.mIsCompletion) {
            return;
        }
        this.onRefreshView(status, message, currentLivenessCount);
        if (status == FaceStatusNewEnum.OK) {
            this.mIsCompletion = true;
            this.saveImage(base64ImageCropMap, base64ImageSrcMap);
        }
    }

    private void onRefreshView(FaceStatusNewEnum status, String message, int currentLivenessCount) {
        switch (status) {
            case OK: 
            case FaceLivenessActionComplete: 
            case DetectRemindCodeTooClose: 
            case DetectRemindCodeTooFar: 
            case DetectRemindCodeBeyondPreviewFrame: 
            case DetectRemindCodeNoFaceDetected: {
                this.mFaceDetectRoundView.setTipTopText(message);
                this.mFaceDetectRoundView.setTipSecondText("");
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList().size());
                break;
            }
            case FaceLivenessActionTypeLiveEye: 
            case FaceLivenessActionTypeLiveMouth: 
            case FaceLivenessActionTypeLivePitchUp: 
            case FaceLivenessActionTypeLivePitchDown: 
            case FaceLivenessActionTypeLiveYawLeft: 
            case FaceLivenessActionTypeLiveYawRight: 
            case FaceLivenessActionTypeLiveYaw: {
                this.mFaceDetectRoundView.setTipTopText(message);
                this.mFaceDetectRoundView.setTipSecondText("");
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList().size());
                if (this.mAnimationDrawable != null) {
                    this.mAnimationDrawable.stop();
                }
                if (this.mRelativeAddImageView.getVisibility() != 0) break;
                this.mRelativeAddImageView.setVisibility(8);
                break;
            }
            case DetectRemindCodePitchOutofUpRange: 
            case DetectRemindCodePitchOutofDownRange: 
            case DetectRemindCodeYawOutofLeftRange: 
            case DetectRemindCodeYawOutofRightRange: {
                this.mFaceDetectRoundView.setTipTopText("");
                this.mFaceDetectRoundView.setTipSecondText(message);
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList().size());
                break;
            }
            case FaceLivenessActionCodeTimeout: {
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList().size());
                break;
            }
            default: {
                this.mFaceDetectRoundView.setTipTopText("");
                this.mFaceDetectRoundView.setTipSecondText(message);
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList().size());
            }
        }
    }

    private void loadAnimSource() {
    }

    private void saveImage(HashMap<String, ImageInfo> imageCropMap, HashMap<String, ImageInfo> imageSrcMap) {
        if (imageCropMap != null && imageCropMap.size() > 0) {
            ArrayList<Map.Entry<String, ImageInfo>> list1 = new ArrayList<Map.Entry<String, ImageInfo>>(imageCropMap.entrySet());
            Collections.sort(list1, new Comparator<Map.Entry<String, ImageInfo>>(){

                @Override
                public int compare(Map.Entry<String, ImageInfo> o1, Map.Entry<String, ImageInfo> o2) {
                    String[] key1 = o1.getKey().split("_");
                    String score1 = key1[2];
                    String[] key2 = o2.getKey().split("_");
                    String score2 = key2[2];
                    return Float.valueOf(score2).compareTo(Float.valueOf(score1));
                }
            });
        }
        if (imageSrcMap != null && imageSrcMap.size() > 0) {
            ArrayList<Map.Entry<String, ImageInfo>> list2 = new ArrayList<Map.Entry<String, ImageInfo>>(imageSrcMap.entrySet());
            Collections.sort(list2, new Comparator<Map.Entry<String, ImageInfo>>(){

                @Override
                public int compare(Map.Entry<String, ImageInfo> o1, Map.Entry<String, ImageInfo> o2) {
                    String[] key1 = o1.getKey().split("_");
                    String score1 = key1[2];
                    String[] key2 = o2.getKey().split("_");
                    String score2 = key2[2];
                    return Float.valueOf(score2).compareTo(Float.valueOf(score1));
                }
            });
            this.mBmpStr = ((ImageInfo)((Map.Entry)list2.get(0)).getValue()).getBase64();
            this.setImageView2(list2);
            this.saveImageToStorage(this.mBmpStr);
        }
    }

    private static Bitmap base64ToBitmap(String base64Data) {
        byte[] bytes = Base64Utils.decode((String)base64Data, (int)2);
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public void setCurrentLiveType(LivenessTypeEnum liveType) {
        this.mLivenessType = liveType;
    }

    public void viewReset() {
        this.mFaceDetectRoundView.setProcessCount(0, 1);
    }

    private void saveAllImage(HashMap<String, ImageInfo> imageCropMap, HashMap<String, ImageInfo> imageSrcMap) {
        if (imageCropMap != null && imageCropMap.size() > 0) {
            ArrayList<Map.Entry<String, ImageInfo>> list1 = new ArrayList<Map.Entry<String, ImageInfo>>(imageCropMap.entrySet());
            Collections.sort(list1, new Comparator<Map.Entry<String, ImageInfo>>(){

                @Override
                public int compare(Map.Entry<String, ImageInfo> o1, Map.Entry<String, ImageInfo> o2) {
                    String[] key1 = o1.getKey().split("_");
                    String score1 = key1[2];
                    String[] key2 = o2.getKey().split("_");
                    String score2 = key2[2];
                    return Float.valueOf(score2).compareTo(Float.valueOf(score1));
                }
            });
            this.mBmpStr = ((ImageInfo)((Map.Entry)list1.get(0)).getValue()).getBase64();
            this.setImageView1(list1);
        }
        if (imageSrcMap != null && imageSrcMap.size() > 0) {
            ArrayList<Map.Entry<String, ImageInfo>> list2 = new ArrayList<Map.Entry<String, ImageInfo>>(imageSrcMap.entrySet());
            Collections.sort(list2, new Comparator<Map.Entry<String, ImageInfo>>(){

                @Override
                public int compare(Map.Entry<String, ImageInfo> o1, Map.Entry<String, ImageInfo> o2) {
                    String[] key1 = o1.getKey().split("_");
                    String score1 = key1[2];
                    String[] key2 = o2.getKey().split("_");
                    String score2 = key2[2];
                    return Float.valueOf(score2).compareTo(Float.valueOf(score1));
                }
            });
            this.mBmpStr = ((ImageInfo)((Map.Entry)list2.get(0)).getValue()).getBase64();
        }
    }

    private void setImageView1(List<Map.Entry<String, ImageInfo>> list) {
        Bitmap bmp = null;
        this.mImageLayout.removeAllViews();
        for (Map.Entry<String, ImageInfo> entry : list) {
            bmp = FaceLivenessActivity.base64ToBitmap(entry.getValue().getBase64());
            ImageView iv = new ImageView((Context)this);
            iv.setImageBitmap(bmp);
            this.mImageLayout.addView((View)iv, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(300, 300));
        }
    }

    private void setImageView2(List<Map.Entry<String, ImageInfo>> list) {
        Bitmap bmp = null;
        this.mImageLayout2.removeAllViews();
        for (Map.Entry<String, ImageInfo> entry : list) {
            bmp = FaceLivenessActivity.base64ToBitmap(entry.getValue().getBase64());
            ImageView iv = new ImageView((Context)this);
            iv.setImageBitmap(bmp);
            this.mImageLayout2.addView((View)iv, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(300, 300));
        }
    }

    private void saveImageToStorage(String mBmpStr) {
        FaceInfoCache.getInStance().setFaceInfoStr(mBmpStr);
        Intent intent = new Intent();
        intent.setAction("com.xdja.face_result");
        intent.putExtra("success", true);
        this.sendBroadcast(intent);
        this.finish();
    }
}

