/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui.utils;

import android.app.Activity;
import android.content.ContentResolver;
import android.net.Uri;
import android.provider.Settings;
import android.util.Log;
import android.view.WindowManager;

public class BrightnessUtils {
    private static final String TAG = "BrightnessUtils";

    public static boolean isAutoBrightness(ContentResolver aContentResolver) {
        boolean automicBrightness = false;
        try {
            automicBrightness = Settings.System.getInt((ContentResolver)aContentResolver, (String)"screen_brightness_mode") == 1;
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
        }
        return automicBrightness;
    }

    public static int getScreenBrightness(Activity activity) {
        int nowBrightnessValue = 0;
        ContentResolver resolver = activity.getContentResolver();
        try {
            nowBrightnessValue = Settings.System.getInt((ContentResolver)resolver, (String)"screen_brightness");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nowBrightnessValue;
    }

    public static void setBrightness(Activity activity, int brightness) {
        WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
        lp.screenBrightness = Float.valueOf(brightness).floatValue() * 0.003921569f;
        Log.d((String)TAG, (String)("set  lp.screenBrightness == " + lp.screenBrightness));
        activity.getWindow().setAttributes(lp);
    }

    public static void stopAutoBrightness(Activity activity) {
        Settings.System.putInt((ContentResolver)activity.getContentResolver(), (String)"screen_brightness_mode", (int)0);
    }

    public static void startAutoBrightness(Activity activity) {
        Settings.System.putInt((ContentResolver)activity.getContentResolver(), (String)"screen_brightness_mode", (int)1);
    }

    public static void saveBrightness(ContentResolver resolver, int brightness) {
        Uri uri = Settings.System.getUriFor((String)"screen_brightness");
        Settings.System.putInt((ContentResolver)resolver, (String)"screen_brightness", (int)brightness);
        resolver.notifyChange(uri, null);
    }
}

