/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.baidu.idl.face.platform.utils.DensityUtils;

public class FaceDetectRoundView
extends View {
    private static final String TAG = FaceDetectRoundView.class.getSimpleName();
    public static final float SURFACE_HEIGHT = 1000.0f;
    public static final float SURFACE_RATIO = 0.75f;
    public static final float WIDTH_SPACE_RATIO = 0.33f;
    public static final float HEIGHT_RATIO = 0.1f;
    public static final float HEIGHT_EXT_RATIO = 0.2f;
    public static final int PATH_SPACE = 16;
    public static final int PATH_SMALL_SPACE = 12;
    public static final int CIRCLE_LINE_WIDTH = 3;
    public static final int COLOR_BG = Color.parseColor((String)"#2F2F33");
    public static final int COLOR_ROUND = Color.parseColor((String)"#FFA800");
    public static final int COLOR_CIRCLE_LINE = Color.parseColor((String)"#CCCCCC");
    public static final int COLOR_CIRCLE_SELECT_LINE = Color.parseColor((String)"#00BAF2");
    private Paint mBGPaint;
    private Paint mFaceRoundPaint;
    private Paint mCircleLinePaint;
    private Paint mCircleLineSelectPaint;
    private Rect mFaceRect;
    private Rect mFaceDetectRect;
    private Paint mTextSecondPaint;
    private Paint mTextTopPaint;
    private float mX;
    private float mY;
    private float mR;
    private int mTotalActiveCount;
    private int mSuccessActiveCount;
    private boolean mIsActiveLive;
    private String mTipSecondText;
    private String mTipTopText;

    public FaceDetectRoundView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setLayerType(1, null);
        float circleLineWidth = DensityUtils.dip2px((Context)context, (float)3.0f);
        this.mBGPaint = new Paint(1);
        this.mBGPaint.setColor(COLOR_BG);
        this.mBGPaint.setStyle(Paint.Style.FILL);
        this.mBGPaint.setAntiAlias(true);
        this.mBGPaint.setDither(true);
        this.mFaceRoundPaint = new Paint(1);
        this.mFaceRoundPaint.setColor(COLOR_ROUND);
        this.mFaceRoundPaint.setStyle(Paint.Style.FILL);
        this.mFaceRoundPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.mFaceRoundPaint.setAntiAlias(true);
        this.mFaceRoundPaint.setDither(true);
        this.mCircleLinePaint = new Paint(1);
        this.mCircleLinePaint.setColor(COLOR_CIRCLE_LINE);
        this.mCircleLinePaint.setStrokeWidth(circleLineWidth);
        this.mCircleLinePaint.setStyle(Paint.Style.STROKE);
        this.mCircleLinePaint.setAntiAlias(true);
        this.mCircleLinePaint.setDither(true);
        this.mCircleLineSelectPaint = new Paint(1);
        this.mCircleLineSelectPaint.setColor(COLOR_CIRCLE_SELECT_LINE);
        this.mCircleLineSelectPaint.setStrokeWidth(circleLineWidth);
        this.mCircleLineSelectPaint.setStyle(Paint.Style.STROKE);
        this.mCircleLineSelectPaint.setAntiAlias(true);
        this.mCircleLineSelectPaint.setDither(true);
        this.mTextSecondPaint = new Paint(1);
        this.mTextSecondPaint.setColor(Color.parseColor((String)"#ffffff"));
        this.mTextSecondPaint.setTextSize((float)DensityUtils.dip2px((Context)this.getContext(), (float)16.0f));
        this.mTextSecondPaint.setTextAlign(Paint.Align.CENTER);
        this.mTextSecondPaint.setAntiAlias(true);
        this.mTextSecondPaint.setDither(true);
        this.mTextTopPaint = new Paint(1);
        this.mTextTopPaint.setColor(Color.parseColor((String)"#ffffff"));
        this.mTextTopPaint.setTextSize((float)DensityUtils.dip2px((Context)this.getContext(), (float)22.0f));
        this.mTextTopPaint.setTextAlign(Paint.Align.CENTER);
        this.mTextTopPaint.setAntiAlias(true);
        this.mTextTopPaint.setDither(true);
    }

    public void setProcessCount(int successActiveCount, int totalActiveCount) {
        this.mSuccessActiveCount = successActiveCount;
        this.mTotalActiveCount = totalActiveCount;
        this.postInvalidate();
    }

    public void setIsActiveLive(boolean isActiveLive) {
        this.mIsActiveLive = isActiveLive;
    }

    public void setTipTopText(String tipTopText) {
        this.mTipTopText = tipTopText;
        if (!TextUtils.isEmpty((CharSequence)tipTopText)) {
            this.invalidate();
        }
    }

    public void setTipSecondText(String tipSecondText) {
        this.mTipSecondText = tipSecondText;
        if (!TextUtils.isEmpty((CharSequence)tipSecondText)) {
            this.invalidate();
        }
    }

    public float getRound() {
        return this.mR;
    }

    public Rect getFaceRoundRect() {
        if (this.mFaceRect != null) {
            Log.e((String)TAG, (String)this.mFaceRect.toString());
        }
        return this.mFaceRect;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        float canvasWidth = (float)right - (float)left;
        float canvasHeight = (float)bottom - (float)top;
        float x = canvasWidth / 2.0f;
        float y = canvasHeight / 2.0f - canvasHeight / 2.0f * 0.1f;
        float r = canvasWidth / 2.0f - canvasWidth / 2.0f * 0.33f;
        if (this.mFaceRect == null) {
            this.mFaceRect = new Rect((int)(x - r), (int)(y - r), (int)(x + r), (int)(y + r));
        }
        if (this.mFaceDetectRect == null) {
            float hr = r + r * 0.2f;
            this.mFaceDetectRect = new Rect((int)(x - r), (int)(y - hr), (int)(x + r), (int)(y + hr));
        }
        this.mX = x;
        this.mY = y;
        this.mR = r;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawColor(0);
        canvas.drawPaint(this.mBGPaint);
        canvas.drawCircle(this.mX, this.mY, this.mR, this.mFaceRoundPaint);
        if (!TextUtils.isEmpty((CharSequence)this.mTipSecondText)) {
            canvas.drawText(this.mTipSecondText, this.mX, this.mY - this.mR - 40.0f - 25.0f - 59.0f, this.mTextSecondPaint);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mTipTopText)) {
            canvas.drawText(this.mTipTopText, this.mX, this.mY - this.mR - 40.0f - 25.0f - 59.0f - 90.0f, this.mTextTopPaint);
        }
        if (this.mIsActiveLive) {
            canvas.translate(this.mX, this.mY);
            this.drawCircleLine(canvas);
            this.drawSuccessCircleLine(canvas);
        }
    }

    private void drawCircleLine(Canvas canvas) {
        canvas.save();
        canvas.rotate(-90.0f);
        for (int j = 0; j < 360; j += 6) {
            canvas.drawLine(this.mR + 40.0f, 0.0f, this.mR + 40.0f + 25.0f, 0.0f, this.mCircleLinePaint);
            canvas.rotate(6.0f);
        }
        canvas.restore();
    }

    private void drawSuccessCircleLine(Canvas canvas) {
        int degree = (int)((float)this.mSuccessActiveCount / (float)this.mTotalActiveCount * 360.0f);
        canvas.save();
        canvas.rotate(-90.0f);
        for (int j = 0; j < degree; j += 6) {
            canvas.drawLine(this.mR + 40.0f, 0.0f, this.mR + 40.0f + 25.0f, 0.0f, this.mCircleLineSelectPaint);
            canvas.rotate(6.0f);
        }
        canvas.restore();
    }

    public static Rect getPreviewDetectRect(int w, int pw, int ph) {
        float round = (float)w / 2.0f - (float)w / 2.0f * 0.33f;
        float x = (float)pw / 2.0f;
        float y = (float)ph / 2.0f - (float)ph / 2.0f * 0.1f;
        float r = (float)pw / 2.0f > round ? round : (float)pw / 2.0f;
        float hr = r + r * 0.2f;
        Rect rect = new Rect((int)(x - r), (int)(y - hr), (int)(x + r), (int)(y + hr));
        return rect;
    }
}

