/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform;

import android.content.Context;
import com.baidu.aip.face.stat.Ast;
import com.baidu.idl.face.platform.FaceConfig;
import com.baidu.idl.face.platform.IDetect;
import com.baidu.idl.face.platform.IDetectStrategy;
import com.baidu.idl.face.platform.ILiveness;
import com.baidu.idl.face.platform.ILivenessStrategy;
import com.baidu.idl.face.platform.decode.FaceModule;
import com.baidu.idl.face.platform.strategy.FaceDetectStrategyExtModule;
import com.baidu.idl.face.platform.strategy.FaceLivenessStrategyExtModule;
import com.baidu.idl.facesdk.FaceSDK;
import com.baidu.idl.facesdk.FaceTracker;

public class FaceSDKManager {
    private static FaceSDKManager instance = null;
    private Context mContext;
    private FaceTracker mFaceTracker;
    private boolean mInitFlag = false;
    private FaceConfig mFaceConfig = new FaceConfig();

    private FaceSDKManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FaceSDKManager getInstance() {
        if (instance != null) return instance;
        Class<FaceSDKManager> clazz = FaceSDKManager.class;
        synchronized (FaceSDKManager.class) {
            if (instance != null) return instance;
            instance = new FaceSDKManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initialize(Context context, String licenseID) {
        this.initialize(context, licenseID, "");
    }

    public void initialize(Context context, String licenseID, String licenseFileName) {
        this.mContext = context;
        FaceSDK.initLicense((Context)context, (String)licenseID, (String)licenseFileName, (boolean)true);
        this.mFaceTracker = new FaceTracker(context);
        this.mFaceTracker.set_isFineAlign(false);
        this.mFaceTracker.set_isVerifyLive(true);
        this.mFaceTracker.set_DetectMethodType(1);
        this.mFaceTracker.set_isCheckQuality(true);
        this.mFaceTracker.set_notFace_thr(0.6f);
        this.mFaceTracker.set_min_face_size(200);
        this.mFaceTracker.set_cropFaceSize(400);
        this.mFaceTracker.set_illum_thr(40.0f);
        this.mFaceTracker.set_blur_thr(0.5f);
        this.mFaceTracker.set_occlu_thr(0.5f);
        this.mFaceTracker.set_max_reg_img_num(1);
        this.mFaceTracker.set_eulur_angle_thr(10, 10, 10);
        this.mFaceTracker.set_track_by_detection_interval(800);
        FaceSDK.setNumberOfThreads((int)2);
        Ast.getInstance().init(context.getApplicationContext(), "3.3.0.0", "facenormal");
        this.mInitFlag = true;
    }

    public FaceTracker getFaceTracker() {
        return this.mFaceTracker;
    }

    public FaceConfig getFaceConfig() {
        return this.mFaceConfig;
    }

    public void setFaceConfig(FaceConfig config) {
        this.mFaceConfig = config;
        this.setSDKValue(this.mFaceConfig);
    }

    private void setSDKValue(FaceConfig options) {
        if (this.mFaceTracker != null && options != null) {
            this.mFaceTracker.set_isCheckQuality(options.isCheckFaceQuality);
            this.mFaceTracker.set_notFace_thr(options.notFaceValue);
            this.mFaceTracker.set_min_face_size(options.minFaceSize);
            this.mFaceTracker.set_cropFaceSize(options.cropFaceValue);
            this.mFaceTracker.set_illum_thr(options.brightnessValue);
            this.mFaceTracker.set_blur_thr(options.blurnessValue);
            this.mFaceTracker.set_occlu_thr(options.occlusionValue);
            this.mFaceTracker.set_isVerifyLive(options.isVerifyLive);
            this.mFaceTracker.set_max_reg_img_num(options.maxCropImageNum);
            this.mFaceTracker.set_eulur_angle_thr(options.headPitchValue, options.headYawValue, options.headRollValue);
            FaceSDK.setNumberOfThreads((int)options.faceDecodeNumberOfThreads);
        }
    }

    public IDetect getDetectModule() {
        return new FaceModule(this.mFaceTracker);
    }

    public ILiveness getLivenessModule() {
        return new FaceModule(this.mFaceTracker);
    }

    public IDetectStrategy getDetectStrategyModule() {
        FaceDetectStrategyExtModule module = new FaceDetectStrategyExtModule(this.mContext, this.mFaceTracker);
        module.setConfigValue(this.mFaceConfig);
        return module;
    }

    public ILivenessStrategy getLivenessStrategyModule() {
        FaceLivenessStrategyExtModule module = new FaceLivenessStrategyExtModule(this.mContext, this.mFaceTracker);
        module.setConfigValue(this.mFaceConfig);
        return module;
    }

    public static boolean isLicenseSuccess() {
        return FaceSDK.getAuthorityStatus() == 0;
    }

    public static String getVersion() {
        return "3.1.0.0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release() {
        Class<FaceSDKManager> clazz = FaceSDKManager.class;
        synchronized (FaceSDKManager.class) {
            Ast.getInstance().immediatelyUpload();
            if (instance != null) {
                FaceSDKManager.instance.mInitFlag = false;
                FaceSDKManager.instance.mFaceTracker = null;
                FaceSDKManager.instance.mContext = null;
                instance = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

