/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.strategy;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.Log;
import com.baidu.idl.face.platform.FaceConfig;
import com.baidu.idl.face.platform.FaceEnvironment;
import com.baidu.idl.face.platform.FaceStatusEnum;
import com.baidu.idl.face.platform.ILivenessStrategy;
import com.baidu.idl.face.platform.ILivenessStrategyCallback;
import com.baidu.idl.face.platform.LivenessTypeEnum;
import com.baidu.idl.face.platform.common.LogHelper;
import com.baidu.idl.face.platform.common.SoundPoolHelper;
import com.baidu.idl.face.platform.model.FaceExtInfo;
import com.baidu.idl.face.platform.model.FaceModel;
import com.baidu.idl.face.platform.strategy.DetectStrategy;
import com.baidu.idl.face.platform.strategy.FaceStrategyModule;
import com.baidu.idl.face.platform.strategy.LivenessStatusStrategy;
import com.baidu.idl.face.platform.utils.BitmapUtils;
import com.baidu.idl.facesdk.FaceTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class FaceLivenessStrategyExtModule
extends FaceStrategyModule
implements ILivenessStrategy {
    private static final String TAG = FaceLivenessStrategyExtModule.class.getSimpleName();
    private Context mContext;
    private Rect mPreviewRect;
    private Rect mDetectRect;
    private DetectStrategy mDetectStrategy;
    private LivenessStatusStrategy mLivenessStrategy;
    private SoundPoolHelper mSoundPlayHelper = null;
    private volatile boolean mIsEnableSound = true;
    private boolean mIsFirstTipsed = false;
    private boolean mIsFirstLivenessSuccessTipsed = false;
    protected HashMap<String, String> mBase64ImageMap = new HashMap();
    protected HashMap<FaceStatusEnum, String> mTipsMap = new HashMap();
    private long mLivenessTipsTime = 0L;
    private long mLivenessTipsDurationTime = 0L;
    private volatile LivenessStatus mLivenessStatus = LivenessStatus.LivenessReady;
    private ILivenessStrategyCallback mILivenessStrategyCallback;

    public FaceLivenessStrategyExtModule(Context context, FaceTracker tracker) {
        super(tracker);
        LogHelper.addLog("appid", context.getPackageName());
        this.mContext = context;
        this.mDetectStrategy = new DetectStrategy();
        this.mLivenessStrategy = new LivenessStatusStrategy();
        this.mSoundPlayHelper = new SoundPoolHelper(context);
        this.mLaunchTime = System.currentTimeMillis();
    }

    public void setConfigValue(FaceConfig config) {
        if (config != null && this.mDetectStrategy != null) {
            this.mDetectStrategy.setHeadAngle(config.getHeadPitchValue(), config.getHeadYawValue(), config.getHeadRollValue());
        }
    }

    @Override
    public void setLivenessStrategyConfig(List<LivenessTypeEnum> livenessList, Rect previewRect, Rect detectRect, ILivenessStrategyCallback callback) {
        this.mLivenessStrategy.setLivenessList(livenessList);
        this.mPreviewRect = previewRect;
        this.mDetectRect = detectRect;
        this.mILivenessStrategyCallback = callback;
    }

    @Override
    public void setLivenessStrategySoundEnable(boolean flag) {
        this.mIsEnableSound = flag;
    }

    @Override
    public void setPreviewDegree(int degree) {
        if (this.mFaceModule != null) {
            this.mFaceModule.setPreviewDegree(degree);
        }
    }

    @Override
    public String getBestFaceImage() {
        String encodeImage = "";
        if (this.mFaceModule != null && this.mFaceModule.getBestFaceImage() != null && this.mFaceModule.getBestFaceImage().length > 0) {
            try {
                int[] image = this.mFaceModule.getBestFaceImage();
                int w = this.mPreviewRect.height();
                int h = this.mPreviewRect.width();
                Bitmap bmp = Bitmap.createBitmap((int)h, (int)w, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bmp.setPixels(image, 0, h, 0, 0, h, w);
                encodeImage = BitmapUtils.bitmapToJpegBase64(bmp, 100);
                if (encodeImage != null && encodeImage.length() > 0) {
                    encodeImage = encodeImage.replace("\\/", "/");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return encodeImage;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.mLivenessStrategy != null && !this.mIsCompletion) {
            this.mLivenessStrategy.reset();
        }
        if (this.mBase64ImageMap != null && !this.mIsCompletion) {
            this.mBase64ImageMap.clear();
        }
        if (this.mSoundPlayHelper != null) {
            this.mSoundPlayHelper.release();
        }
    }

    @Override
    public void livenessStrategy(byte[] imageData) {
        if (!this.mIsFirstTipsed) {
            this.mIsFirstTipsed = true;
            this.processUITips(FaceStatusEnum.Detect_FacePointOut);
            return;
        }
        if (this.mIsProcessing) {
            this.process(imageData);
        }
    }

    @Override
    protected void processStrategy(byte[] imageData) {
        FaceModel model = this.mFaceModule.detect(imageData, this.mPreviewRect.height(), this.mPreviewRect.width());
        this.processUIStrategy(new UILivenessResultRunnable(model));
    }

    private void processUIResult(FaceModel model) {
        if (!this.mIsProcessing) {
            return;
        }
        if (System.currentTimeMillis() - this.mLaunchTime > FaceEnvironment.TIME_MODULE && FaceEnvironment.TIME_MODULE != 0L) {
            this.mIsProcessing = false;
            this.processUICallback(FaceStatusEnum.Error_Timeout);
            return;
        }
        FaceExtInfo faceInfo = null;
        FaceStatusEnum decodeStatus = FaceStatusEnum.Detect_NoFace;
        LivenessTypeEnum livenessType = this.mLivenessStrategy.getCurrentLivenessType();
        if (model != null && model.getFaceInfos() != null && model.getFaceInfos().length > 0) {
            decodeStatus = model.getFaceModuleState();
            faceInfo = model.getFaceInfos()[0];
            LogHelper.addLogWithKey("ftm", System.currentTimeMillis());
        } else if (this.mDetectStrategy != null) {
            this.mDetectStrategy.reset();
        }
        if (faceInfo != null) {
            decodeStatus = this.mDetectStrategy.checkDetect(this.mPreviewRect, this.mDetectRect, faceInfo.getPitch(), faceInfo.getYaw(), faceInfo.getLandmarksOutOfDetectCount(this.mDetectRect), faceInfo.getFaceWidth(), decodeStatus);
        }
        if (decodeStatus != FaceStatusEnum.OK) {
            if (this.mDetectStrategy.isTimeout()) {
                this.mIsProcessing = false;
                this.processUICallback(FaceStatusEnum.Error_DetectTimeout);
                return;
            }
            switch (decodeStatus) {
                case Detect_NoFace: 
                case Detect_FacePointOut: {
                    if (this.mNoFaceTime == 0L) {
                        this.mNoFaceTime = System.currentTimeMillis();
                    }
                    if (System.currentTimeMillis() - this.mNoFaceTime > FaceEnvironment.TIME_DETECT_MODULE) {
                        this.mIsProcessing = false;
                        this.processUICallback(FaceStatusEnum.Error_DetectTimeout);
                        return;
                    }
                    if (FaceStatusEnum.Detect_NoFace == decodeStatus) {
                        if (this.mIsFirstLivenessSuccessTipsed && this.mNoFaceTime != 0L && System.currentTimeMillis() - this.mNoFaceTime < FaceEnvironment.TIME_DETECT_NO_FACE_CONTINUOUS) {
                            return;
                        }
                        this.mIsFirstLivenessSuccessTipsed = false;
                        this.mDetectStrategy.reset();
                        this.mLivenessStatus = LivenessStatus.LivenessReady;
                        this.mLivenessStrategy.reset();
                        if (this.mBase64ImageMap != null) {
                            this.mBase64ImageMap.clear();
                        }
                    } else {
                        this.mDetectStrategy.reset();
                        this.mLivenessStatus = LivenessStatus.LivenessReady;
                        this.mLivenessStrategy.resetState();
                    }
                    this.processUITips(decodeStatus);
                    break;
                }
                default: {
                    this.processUITips(decodeStatus);
                    this.mDetectStrategy.reset();
                    this.mLivenessStatus = LivenessStatus.LivenessReady;
                    this.mLivenessStrategy.resetState();
                    break;
                }
            }
        } else if (faceInfo != null && decodeStatus == FaceStatusEnum.OK) {
            if (this.mLivenessStrategy.getCurrentLivenessStatus() == FaceStatusEnum.Liveness_HeadLeftRight || this.mLivenessStrategy.getCurrentLivenessStatus() == FaceStatusEnum.Liveness_HeadLeft || this.mLivenessStrategy.getCurrentLivenessStatus() == FaceStatusEnum.Liveness_HeadRight) {
                long du;
                if (this.mLivenessStatus == LivenessStatus.LivenessTips && (du = System.currentTimeMillis() - this.mLivenessTipsTime) > this.mLivenessTipsDurationTime) {
                    this.mLivenessStrategy.processLiveness(faceInfo);
                }
            } else {
                this.mLivenessStrategy.processLiveness(faceInfo);
            }
            if (this.mLivenessStrategy.isCurrentLivenessSuccess()) {
                this.saveLivenessImage(this.mLivenessStrategy.getCurrentLivenessType(), model.getArgbImage(), this.mPreviewRect);
            }
            this.mNoFaceTime = 0L;
            this.mDetectStrategy.setLiveness(livenessType);
            LogHelper.addLogWithKey("btm", System.currentTimeMillis());
            if (this.mLivenessStrategy.isTimeout()) {
                this.mIsProcessing = false;
                this.processUICallback(FaceStatusEnum.Error_LivenessTimeout);
                return;
            }
            Log.e((String)TAG, (String)"switch =========================");
            switch (this.mLivenessStatus) {
                case LivenessReady: {
                    Log.e((String)TAG, (String)("switch " + this.mLivenessStatus.name() + "-" + (Object)((Object)this.mLivenessStrategy.getCurrentLivenessStatus())));
                    if (!this.processUITips(this.mLivenessStrategy.getCurrentLivenessStatus())) break;
                    if (this.mLivenessTipsDurationTime == 0L) {
                        this.mLivenessTipsDurationTime = this.mSoundPlayHelper.getPlayDuration();
                    }
                    this.mLivenessStatus = LivenessStatus.LivenessTips;
                    this.mLivenessTipsTime = System.currentTimeMillis();
                    break;
                }
                case LivenessTips: {
                    Log.e((String)TAG, (String)("switch " + this.mLivenessStatus.name() + "-" + (Object)((Object)this.mLivenessStrategy.getCurrentLivenessStatus())));
                    if (this.mLivenessStrategy.isCurrentLivenessSuccess()) {
                        this.mLivenessStatus = LivenessStatus.LivenessOK;
                        this.mLivenessTipsTime = 0L;
                        this.mLivenessTipsDurationTime = 0L;
                        break;
                    }
                    this.processUITips(this.mLivenessStrategy.getCurrentLivenessStatus());
                    break;
                }
                case LivenessOK: {
                    Log.e((String)TAG, (String)("switch " + this.mLivenessStatus.name() + "-" + (Object)((Object)this.mLivenessStrategy.getCurrentLivenessStatus())));
                    if (!this.processUITips(FaceStatusEnum.Liveness_OK)) break;
                    if (!this.mIsFirstLivenessSuccessTipsed) {
                        this.mIsFirstLivenessSuccessTipsed = true;
                    }
                    if (this.mLivenessStrategy.nextLiveness()) {
                        this.mLivenessStatus = LivenessStatus.LivenessReady;
                        this.mLivenessTipsTime = 0L;
                        this.mLivenessTipsDurationTime = 0L;
                        break;
                    }
                    if (!this.mLivenessStrategy.isLivenessSuccess()) break;
                    this.processUICallback(FaceStatusEnum.OK);
                    break;
                }
            }
        }
    }

    private void saveLivenessImage(LivenessTypeEnum type, int[] argbByte, Rect roundRect) {
        if (!this.mBase64ImageMap.containsKey(type.name())) {
            Bitmap image = BitmapUtils.createLivenessBitmap(this.mContext, argbByte, roundRect);
            String imageEncode = BitmapUtils.bitmapToJpegBase64(image, 80);
            if (imageEncode != null && imageEncode.length() > 0) {
                imageEncode = imageEncode.replace("\\/", "/");
                this.mBase64ImageMap.put(type.name(), imageEncode);
            }
            if (image != null && !image.isRecycled()) {
                image.recycle();
                image = null;
            }
        }
    }

    private boolean processUITips(FaceStatusEnum status) {
        boolean flag = false;
        if (status != null) {
            this.mSoundPlayHelper.setEnableSound(this.mIsEnableSound);
            flag = this.mSoundPlayHelper.playSound(status);
            if (flag) {
                LogHelper.addTipsLogWithKey(status.name());
                this.processUICallback(status);
            }
        }
        return flag;
    }

    private void processUICallback(FaceStatusEnum status) {
        if (status == FaceStatusEnum.Error_DetectTimeout || status == FaceStatusEnum.Error_LivenessTimeout || status == FaceStatusEnum.Error_Timeout) {
            LogHelper.addLogWithKey("etm", System.currentTimeMillis());
            LogHelper.sendLog();
        }
        if (status == FaceStatusEnum.OK || status == FaceStatusEnum.Liveness_Completion) {
            Log.e((String)TAG, (String)"processUICompletion");
            this.mIsProcessing = false;
            this.mIsCompletion = true;
            LogHelper.addLogWithKey("etm", System.currentTimeMillis());
            LogHelper.addLogWithKey("finish", 1);
            LogHelper.sendLog();
            if (this.mILivenessStrategyCallback != null) {
                ArrayList<String> imageList = this.mFaceModule.getDetectBestImageList();
                for (int i = 0; i < imageList.size(); ++i) {
                    this.mBase64ImageMap.put("bestImage" + i, imageList.get(i));
                }
                this.mILivenessStrategyCallback.onLivenessCompletion(status, this.getStatusTextResId(status), this.mBase64ImageMap);
            }
        } else if (this.mILivenessStrategyCallback != null) {
            this.mILivenessStrategyCallback.onLivenessCompletion(status, this.getStatusTextResId(status), null);
        }
    }

    private String getStatusTextResId(FaceStatusEnum status) {
        String tips = "";
        if (this.mTipsMap.containsKey((Object)status)) {
            tips = this.mTipsMap.get((Object)status);
        } else {
            int resId = FaceEnvironment.getTipsId(status);
            if (resId > 0) {
                tips = this.mContext.getResources().getString(resId);
                this.mTipsMap.put(status, tips);
            }
        }
        return tips;
    }

    private class UILivenessResultRunnable
    implements Runnable {
        private final FaceModel mModel;

        public UILivenessResultRunnable(FaceModel model) {
            this.mModel = model;
        }

        @Override
        public void run() {
            FaceLivenessStrategyExtModule.this.processUIResult(this.mModel);
        }
    }

    private static enum LivenessStatus {
        LivenessReady,
        LivenessTips,
        LivenessOK,
        LivenessOKTips;

    }
}

