/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.strategy;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.text.TextUtils;
import com.baidu.idl.face.platform.FaceConfig;
import com.baidu.idl.face.platform.FaceEnvironment;
import com.baidu.idl.face.platform.FaceStatusEnum;
import com.baidu.idl.face.platform.ILivenessStrategy;
import com.baidu.idl.face.platform.ILivenessStrategyCallback;
import com.baidu.idl.face.platform.LivenessTypeEnum;
import com.baidu.idl.face.platform.common.LogHelper;
import com.baidu.idl.face.platform.common.SoundPoolHelper;
import com.baidu.idl.face.platform.model.FaceExtInfo;
import com.baidu.idl.face.platform.model.FaceModel;
import com.baidu.idl.face.platform.strategy.DetectStrategy;
import com.baidu.idl.face.platform.strategy.FaceStrategyModule;
import com.baidu.idl.face.platform.strategy.LivenessStrategy;
import com.baidu.idl.face.platform.utils.BitmapUtils;
import com.baidu.idl.facesdk.FaceTracker;
import java.util.HashMap;
import java.util.List;

@Deprecated
public final class FaceLivenessStrategyModule
extends FaceStrategyModule
implements ILivenessStrategy {
    private static final String TAG = FaceLivenessStrategyModule.class.getSimpleName();
    private Context mContext;
    private Rect mPreviewRect;
    private Rect mDetectRect;
    private DetectStrategy mDetectStrategy;
    private LivenessStrategy mLivenessStrategy;
    private SoundPoolHelper mSoundPlayHelper = null;
    private volatile boolean mIsEnableSound = true;
    private volatile boolean mIsTipsed = false;
    private boolean mIsFirstTipsed = false;
    protected int[] mBestFaceImage;
    protected HashMap<String, String> mBase64ImageMap = new HashMap();
    protected HashMap<FaceStatusEnum, String> mTipsMap = new HashMap();
    private ILivenessStrategyCallback mILivenessStrategyCallback;

    public FaceLivenessStrategyModule(Context context, FaceTracker tracker) {
        super(tracker);
        LogHelper.addLog("appid", context.getPackageName());
        this.mContext = context;
        this.mDetectStrategy = new DetectStrategy();
        this.mLivenessStrategy = new LivenessStrategy();
        this.mSoundPlayHelper = new SoundPoolHelper(context);
        this.mLaunchTime = System.currentTimeMillis();
    }

    public void setConfigValue(FaceConfig config) {
        if (config != null && this.mDetectStrategy != null) {
            this.mDetectStrategy.setHeadAngle(config.getHeadPitchValue(), config.getHeadYawValue(), config.getHeadRollValue());
        }
    }

    @Override
    public void setLivenessStrategyConfig(List<LivenessTypeEnum> livenessList, Rect previewRect, Rect detectRect, ILivenessStrategyCallback callback) {
        this.mLivenessStrategy.setLivenessList(livenessList);
        this.mPreviewRect = previewRect;
        this.mDetectRect = detectRect;
        this.mILivenessStrategyCallback = callback;
    }

    @Override
    public void setLivenessStrategySoundEnable(boolean flag) {
        this.mIsEnableSound = flag;
    }

    @Override
    public void setPreviewDegree(int degree) {
        if (this.mFaceModule != null) {
            this.mFaceModule.setPreviewDegree(degree);
        }
    }

    @Override
    public String getBestFaceImage() {
        String encodeImage = "";
        if (this.mFaceModule != null && this.mFaceModule.getBestFaceImage() != null && this.mFaceModule.getBestFaceImage().length > 0) {
            try {
                int[] image = this.mFaceModule.getBestFaceImage();
                int w = this.mPreviewRect.height();
                int h = this.mPreviewRect.width();
                Bitmap bmp = Bitmap.createBitmap((int)h, (int)w, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bmp.setPixels(image, 0, h, 0, 0, h, w);
                encodeImage = BitmapUtils.bitmapToJpegBase64(bmp, 100);
                if (encodeImage != null && encodeImage.length() > 0) {
                    encodeImage = encodeImage.replace("\\/", "/");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return encodeImage;
    }

    @Override
    public void reset() {
        if (this.mLivenessStrategy != null && !this.mIsCompletion) {
            this.mLivenessStrategy.reset();
        }
        if (this.mBase64ImageMap != null && !this.mIsCompletion) {
            this.mBase64ImageMap.clear();
        }
    }

    @Override
    public void livenessStrategy(byte[] imageData) {
        if (!this.mIsFirstTipsed) {
            this.mIsFirstTipsed = true;
            this.processUITips(FaceStatusEnum.Detect_NoFace);
        }
        if (this.mIsProcessing) {
            this.process(imageData);
        }
    }

    @Override
    protected void processStrategy(byte[] imageData) {
        if (FaceEnvironment.isDebugable()) {
            // empty if block
        }
        FaceModel model = this.mFaceModule.detect(imageData, this.mPreviewRect.height(), this.mPreviewRect.width());
        this.processUIStrategy(new UILivenessResultRunnable(model));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processUIResult(FaceModel model) {
        FaceExtInfo faceInfo;
        if (!this.mIsProcessing) {
            return;
        }
        if (System.currentTimeMillis() - this.mLaunchTime > FaceEnvironment.TIME_MODULE && FaceEnvironment.TIME_MODULE != 0L) {
            this.mIsProcessing = false;
            this.processUICallback(FaceStatusEnum.Error_Timeout);
            return;
        }
        if (System.currentTimeMillis() - this.mLaunchTime < 1600L) {
            return;
        }
        if (model != null && model.getFaceInfos() != null && model.getFaceInfos().length > 0) {
            faceInfo = model.getFaceInfos()[0];
            LogHelper.addLogWithKey("ftm", System.currentTimeMillis());
        } else {
            faceInfo = null;
            if (this.mDetectStrategy != null) {
                this.mDetectStrategy.reset();
            }
        }
        FaceStatusEnum detectStatus = FaceStatusEnum.Detect_NoFace;
        if (faceInfo != null) {
            LivenessTypeEnum livenessType = this.mLivenessStrategy.getCurrentLivenessType();
            this.mDetectStrategy.setLiveness(livenessType);
            detectStatus = this.mDetectStrategy.checkDetect(this.mPreviewRect, this.mDetectRect, faceInfo.getPitch(), faceInfo.getYaw(), faceInfo.getLandmarksOutOfDetectCount(this.mDetectRect), faceInfo.getFaceWidth(), model.getFaceModuleState());
            if (detectStatus == FaceStatusEnum.OK) {
                boolean flag;
                LogHelper.addLogWithKey("btm", System.currentTimeMillis());
                this.mNoFaceTime = 0L;
                if (this.mLivenessStrategy.isTimeout()) {
                    this.mIsProcessing = false;
                    this.processUICallback(FaceStatusEnum.Error_LivenessTimeout);
                    return;
                }
                if (!this.mLivenessStrategy.isCurrentLivenessCheckSuccess()) {
                    FaceStatusEnum livenessStatus = this.mLivenessStrategy.getCurrentLivenessStatus();
                    boolean flag2 = this.processUITips(livenessStatus);
                    if (flag2) {
                        this.mIsTipsed = true;
                    }
                } else if (this.mLivenessStrategy.isLivenessCheckSuccess()) {
                    if (!this.isPrepareDataSuccess(faceInfo.getFaceId())) {
                        return;
                    }
                    boolean flag3 = this.processUITips(FaceStatusEnum.Liveness_OK);
                    if (flag3) {
                        this.processUICompletion(faceInfo.getFaceId(), FaceStatusEnum.OK);
                    }
                } else if (this.mIsTipsed && (flag = this.processUITips(FaceStatusEnum.Liveness_OK))) {
                    this.mLivenessStrategy.nextLiveness();
                    this.mIsTipsed = false;
                }
                if (this.mIsTipsed) {
                    this.mLivenessStrategy.checkLiveness(faceInfo.getLiveInfo());
                }
                if (!this.mLivenessStrategy.isCurrentLivenessCheckSuccess()) return;
                this.saveLivenessImage(livenessType, model.getArgbImage(), this.mPreviewRect);
                LogHelper.addLogWithKey("ptm", System.currentTimeMillis());
                LogHelper.addLivenessLog(livenessType.ordinal());
                return;
            }
            boolean flag = this.processUITips(detectStatus);
            if (flag) {
                if (detectStatus == FaceStatusEnum.Detect_NoFace) {
                    this.mIsTipsed = false;
                    this.mDetectStrategy.reset();
                    this.mLivenessStrategy.reset();
                    if (this.mBase64ImageMap != null) {
                        this.mBase64ImageMap.clear();
                    }
                } else {
                    this.mIsTipsed = false;
                    this.mLivenessStrategy.resetState();
                    this.mNoFaceTime = 0L;
                }
            }
            if (!this.mDetectStrategy.isTimeout()) return;
            this.mIsProcessing = false;
            this.processUICallback(FaceStatusEnum.Error_DetectTimeout);
            return;
        }
        if (detectStatus == FaceStatusEnum.Detect_NoFace) {
            if (this.mNoFaceTime == 0L) {
                this.mNoFaceTime = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - this.mNoFaceTime > FaceEnvironment.TIME_DETECT_MODULE) {
                this.mIsProcessing = false;
                this.processUICallback(FaceStatusEnum.Error_DetectTimeout);
                return;
            }
            if (this.mNoFaceTime == 0L) return;
            if (System.currentTimeMillis() - this.mNoFaceTime <= FaceEnvironment.TIME_DETECT_NO_FACE_CONTINUOUS) return;
            this.mIsTipsed = false;
            this.mDetectStrategy.reset();
            this.mLivenessStrategy.reset();
            if (this.mBase64ImageMap != null) {
                this.mBase64ImageMap.clear();
            }
        } else {
            this.mNoFaceTime = 0L;
        }
        if (this.mDetectStrategy.isTimeout()) {
            this.mIsProcessing = false;
            this.processUICallback(FaceStatusEnum.Error_DetectTimeout);
            return;
        }
        this.processUITips(detectStatus);
    }

    private boolean isPrepareDataSuccess(int faceId) {
        String encodeImage = this.mFaceModule.getDetectBestImage(faceId);
        return !TextUtils.isEmpty((CharSequence)encodeImage);
    }

    private void saveLivenessImage(LivenessTypeEnum type, int[] argbByte, Rect roundRect) {
        if (!this.mBase64ImageMap.containsKey(type.name())) {
            Bitmap image = BitmapUtils.createLivenessBitmap(this.mContext, argbByte, roundRect);
            String imageEncode = BitmapUtils.bitmapToJpegBase64(image, 80);
            if (imageEncode != null && imageEncode.length() > 0) {
                imageEncode = imageEncode.replace("\\/", "/");
                this.mBase64ImageMap.put(type.name(), imageEncode);
            }
            if (image != null && !image.isRecycled()) {
                image.recycle();
                image = null;
            }
        }
    }

    private boolean processUITips(FaceStatusEnum status) {
        boolean flag = false;
        if (status != null) {
            this.mSoundPlayHelper.setEnableSound(this.mIsEnableSound);
            flag = this.mSoundPlayHelper.playSound(status);
            if (flag) {
                LogHelper.addTipsLogWithKey(status.name());
                this.processUICallback(status);
            }
        }
        return flag;
    }

    private void processUICallback(FaceStatusEnum status) {
        if (status == FaceStatusEnum.Error_DetectTimeout || status == FaceStatusEnum.Error_LivenessTimeout || status == FaceStatusEnum.Error_Timeout) {
            LogHelper.addLogWithKey("etm", System.currentTimeMillis());
            LogHelper.sendLog();
        }
        if (this.mILivenessStrategyCallback != null) {
            this.mILivenessStrategyCallback.onLivenessCompletion(status, this.getStatusTextResId(status), null);
        }
    }

    private void processUICompletion(int faceId, FaceStatusEnum status) {
        this.mIsProcessing = false;
        this.mIsCompletion = true;
        LogHelper.addLogWithKey("etm", System.currentTimeMillis());
        LogHelper.addLogWithKey("finish", 1);
        LogHelper.sendLog();
        if (this.mILivenessStrategyCallback != null) {
            String imageEncode = this.mFaceModule.getDetectBestImage(faceId);
            this.mBase64ImageMap.put("bestImage", imageEncode);
            this.processUIStrategyDelay(new Runnable(){

                @Override
                public void run() {
                    FaceLivenessStrategyModule.this.processUITips(FaceStatusEnum.Liveness_Completion);
                }
            }, 500L);
            this.mILivenessStrategyCallback.onLivenessCompletion(status, this.getStatusTextResId(status), this.mBase64ImageMap);
        }
    }

    private String getStatusTextResId(FaceStatusEnum status) {
        String tips = "";
        if (this.mTipsMap.containsKey((Object)status)) {
            tips = this.mTipsMap.get((Object)status);
        } else {
            int resId = FaceEnvironment.getTipsId(status);
            if (resId > 0) {
                tips = this.mContext.getResources().getString(resId);
                this.mTipsMap.put(status, tips);
            }
        }
        return tips;
    }

    private class UILivenessResultRunnable
    implements Runnable {
        private final FaceModel mModel;

        public UILivenessResultRunnable(FaceModel model) {
            this.mModel = model;
        }

        @Override
        public void run() {
            FaceLivenessStrategyModule.this.processUIResult(this.mModel);
        }
    }
}

