/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.strategy;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.baidu.idl.face.platform.common.LogHelper;
import com.baidu.idl.face.platform.decode.FaceModule;
import com.baidu.idl.facesdk.FaceTracker;

abstract class FaceStrategyModule {
    private static final String TAG = FaceStrategyModule.class.getSimpleName();
    protected FaceModule mFaceModule;
    protected byte[] mImageData;
    protected long mLaunchTime = 0L;
    protected long mNoFaceTime = 0L;
    protected Handler mUIHandler = new Handler(Looper.getMainLooper());
    protected volatile boolean mIsProcessing = true;
    protected volatile boolean mIsCompletion = false;
    private static volatile int mProcessCount = 0;

    public FaceStrategyModule(FaceTracker tracker) {
        this.mFaceModule = new FaceModule(tracker);
        LogHelper.clear();
        LogHelper.addLog("ca", "Baidu-IDL-FaceSDK3.1.0.0");
        LogHelper.addLog("system", Build.VERSION.SDK_INT);
        LogHelper.addLog("version", "3.1.0.0");
        LogHelper.addLog("device", Build.MODEL + " " + Build.MANUFACTURER);
        LogHelper.addLog("stm", System.currentTimeMillis());
    }

    protected void process(byte[] imageData) {
        if (mProcessCount > 0) {
            return;
        }
        this.mImageData = imageData;
        new FaceProcessRunnable().run();
        ++mProcessCount;
    }

    protected abstract void processStrategy(byte[] var1);

    protected void processUIStrategy(Runnable runnable) {
        if (this.mUIHandler != null) {
            this.mUIHandler.post(runnable);
        }
    }

    protected void processUIStrategyDelay(Runnable runnable, long delay) {
        if (this.mUIHandler != null) {
            this.mUIHandler.postDelayed(runnable, delay);
        }
    }

    public void reset() {
        mProcessCount = 0;
        if (this.mFaceModule != null) {
            this.mFaceModule.reset();
        }
    }

    private class FaceProcessRunnable
    implements Runnable {
        private FaceProcessRunnable() {
        }

        @Override
        public void run() {
            FaceStrategyModule.this.processStrategy(FaceStrategyModule.this.mImageData);
            --mProcessCount;
        }
    }
}

