/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.strategy;

import android.util.Log;
import com.baidu.idl.face.platform.FaceEnvironment;
import com.baidu.idl.face.platform.FaceStatusEnum;
import com.baidu.idl.face.platform.LivenessTypeEnum;
import com.baidu.idl.face.platform.model.FaceExtInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class LivenessStatusStrategy {
    private static final String TAG = LivenessStatusStrategy.class.getSimpleName();
    private List<LivenessTypeEnum> mLivenessList;
    private long mLivenessDuration = 0L;
    private volatile int mLivenessIndex = 0;
    private boolean mLivenessTimeoutFlag = false;
    private volatile LivenessTypeEnum mCurrentLivenessTypeEnum = null;
    private long mFaceID = -1L;
    private HashMap<LivenessTypeEnum, Boolean> mLivenessStatusMap = new HashMap();

    public LivenessStatusStrategy() {
        this.mLivenessDuration = System.currentTimeMillis();
    }

    public void setLivenessList(List<LivenessTypeEnum> list) {
        if (list != null && list.size() > 0) {
            this.mLivenessList = list;
            this.mCurrentLivenessTypeEnum = this.mLivenessList.get(0);
            this.clearLivenessStatus();
            StringBuilder sd = new StringBuilder();
            for (LivenessTypeEnum type : this.mLivenessList) {
                sd.append(type.name());
                sd.append("-");
            }
        }
    }

    public LivenessTypeEnum getCurrentLivenessType() {
        return this.mCurrentLivenessTypeEnum;
    }

    public FaceStatusEnum getCurrentLivenessStatus() {
        FaceStatusEnum status = null;
        if (this.mCurrentLivenessTypeEnum != null) {
            switch (this.mCurrentLivenessTypeEnum) {
                case Eye: {
                    status = FaceStatusEnum.Liveness_Eye;
                    break;
                }
                case Mouth: {
                    status = FaceStatusEnum.Liveness_Mouth;
                    break;
                }
                case HeadUp: {
                    status = FaceStatusEnum.Liveness_HeadUp;
                    break;
                }
                case HeadDown: {
                    status = FaceStatusEnum.Liveness_HeadDown;
                    break;
                }
                case HeadLeft: {
                    status = FaceStatusEnum.Liveness_HeadLeft;
                    break;
                }
                case HeadRight: {
                    status = FaceStatusEnum.Liveness_HeadRight;
                    break;
                }
                case HeadLeftOrRight: {
                    status = FaceStatusEnum.Liveness_HeadLeftRight;
                    break;
                }
            }
        }
        return status;
    }

    public boolean isLivenessSuccess() {
        boolean flag = true;
        String name = "";
        for (Map.Entry<LivenessTypeEnum, Boolean> entry : this.mLivenessStatusMap.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            flag = false;
            name = entry.getKey().name();
            break;
        }
        return flag;
    }

    public boolean isCurrentLivenessSuccess() {
        boolean flag = this.mLivenessStatusMap.containsKey((Object)this.mCurrentLivenessTypeEnum) ? this.mLivenessStatusMap.get((Object)this.mCurrentLivenessTypeEnum) : false;
        return flag;
    }

    public boolean isTimeout() {
        return this.mLivenessTimeoutFlag;
    }

    public boolean nextLiveness() {
        if (this.mLivenessIndex + 1 < this.mLivenessList.size()) {
            ++this.mLivenessIndex;
            this.mCurrentLivenessTypeEnum = this.mLivenessList.get(this.mLivenessIndex);
            this.mLivenessDuration = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public void processLiveness(FaceExtInfo faceInfo) {
        long t = System.currentTimeMillis();
        if (t - this.mLivenessDuration > FaceEnvironment.TIME_LIVENESS_MODULE) {
            this.mLivenessTimeoutFlag = true;
            return;
        }
        if (faceInfo != null) {
            if ((long)faceInfo.getFaceId() != this.mFaceID) {
                this.mFaceID = faceInfo.getFaceId();
            }
            switch (this.mCurrentLivenessTypeEnum) {
                case Eye: {
                    Log.e((String)TAG, (String)("ext Eye " + faceInfo.isLiveEye()));
                    break;
                }
                case Mouth: {
                    Log.e((String)TAG, (String)("ext Mouth " + faceInfo.isLiveMouth()));
                    break;
                }
                case HeadUp: {
                    Log.e((String)TAG, (String)("ext HeadUp " + faceInfo.isLiveHeadUp()));
                    break;
                }
                case HeadDown: {
                    Log.e((String)TAG, (String)("ext HeadDown " + faceInfo.isLiveHeadDown()));
                    break;
                }
                case HeadLeft: {
                    Log.e((String)TAG, (String)("ext HeadLeft " + faceInfo.isLiveHeadTurnLeft()));
                    break;
                }
                case HeadRight: {
                    Log.e((String)TAG, (String)("ext HeadRight " + faceInfo.isLiveHeadTurnRight()));
                    break;
                }
                case HeadLeftOrRight: {
                    Log.e((String)TAG, (String)("ext HeadLeftOrRight " + faceInfo.isLiveHeadTurnLeft() + "-" + faceInfo.isLiveHeadTurnRight()));
                    break;
                }
            }
            if (this.mLivenessList.contains((Object)LivenessTypeEnum.Eye) && !this.mLivenessStatusMap.containsKey((Object)LivenessTypeEnum.Eye)) {
                this.mLivenessStatusMap.put(LivenessTypeEnum.Eye, faceInfo.isLiveEye());
            } else if (this.mCurrentLivenessTypeEnum == LivenessTypeEnum.Eye && faceInfo.isLiveEye()) {
                this.mLivenessStatusMap.put(LivenessTypeEnum.Eye, faceInfo.isLiveEye());
            }
            if (this.mLivenessList.contains((Object)LivenessTypeEnum.Mouth) && !this.mLivenessStatusMap.containsKey((Object)LivenessTypeEnum.Mouth)) {
                this.mLivenessStatusMap.put(LivenessTypeEnum.Mouth, faceInfo.isLiveMouth());
            } else if (this.mCurrentLivenessTypeEnum == LivenessTypeEnum.Mouth && faceInfo.isLiveMouth()) {
                this.mLivenessStatusMap.put(LivenessTypeEnum.Mouth, faceInfo.isLiveMouth());
            }
            if (this.mLivenessList.contains((Object)LivenessTypeEnum.HeadUp) && !this.mLivenessStatusMap.containsKey((Object)LivenessTypeEnum.HeadUp)) {
                this.mLivenessStatusMap.put(LivenessTypeEnum.HeadUp, faceInfo.isLiveHeadUp());
            } else if (this.mCurrentLivenessTypeEnum == LivenessTypeEnum.HeadUp && faceInfo.isLiveHeadUp()) {
                this.mLivenessStatusMap.put(LivenessTypeEnum.HeadUp, faceInfo.isLiveHeadUp());
            }
            if (this.mLivenessList.contains((Object)LivenessTypeEnum.HeadDown) && !this.mLivenessStatusMap.containsKey((Object)LivenessTypeEnum.HeadDown)) {
                this.mLivenessStatusMap.put(LivenessTypeEnum.HeadDown, faceInfo.isLiveHeadDown());
            } else if (this.mCurrentLivenessTypeEnum == LivenessTypeEnum.HeadDown && faceInfo.isLiveHeadDown()) {
                this.mLivenessStatusMap.put(LivenessTypeEnum.HeadDown, faceInfo.isLiveHeadDown());
            }
            if (this.mLivenessList.contains((Object)LivenessTypeEnum.HeadLeft) && !this.mLivenessStatusMap.containsKey((Object)LivenessTypeEnum.HeadLeft)) {
                this.mLivenessStatusMap.put(LivenessTypeEnum.HeadLeft, faceInfo.isLiveHeadTurnLeft());
            } else if (this.mCurrentLivenessTypeEnum == LivenessTypeEnum.HeadLeft && faceInfo.isLiveHeadTurnLeft()) {
                this.mLivenessStatusMap.put(LivenessTypeEnum.HeadLeft, faceInfo.isLiveHeadTurnLeft());
            }
            if (this.mLivenessList.contains((Object)LivenessTypeEnum.HeadRight) && !this.mLivenessStatusMap.containsKey((Object)LivenessTypeEnum.HeadRight)) {
                this.mLivenessStatusMap.put(LivenessTypeEnum.HeadRight, faceInfo.isLiveHeadTurnRight());
            } else if (this.mCurrentLivenessTypeEnum == LivenessTypeEnum.HeadRight && faceInfo.isLiveHeadTurnRight()) {
                this.mLivenessStatusMap.put(LivenessTypeEnum.HeadRight, faceInfo.isLiveHeadTurnRight());
            }
            if (this.mLivenessList.contains((Object)LivenessTypeEnum.HeadLeftOrRight) && !this.mLivenessStatusMap.containsKey((Object)LivenessTypeEnum.HeadLeftOrRight)) {
                this.mLivenessStatusMap.put(LivenessTypeEnum.HeadLeftOrRight, faceInfo.isLiveHeadTurnLeftOrRight());
            } else if (this.mCurrentLivenessTypeEnum == LivenessTypeEnum.HeadLeftOrRight && faceInfo.isLiveHeadTurnLeftOrRight()) {
                this.mLivenessStatusMap.put(LivenessTypeEnum.HeadLeftOrRight, faceInfo.isLiveHeadTurnLeftOrRight());
            }
        }
    }

    private void clearLivenessStatus() {
        this.mLivenessStatusMap.clear();
        for (int i = 0; i < this.mLivenessList.size(); ++i) {
            this.mLivenessStatusMap.put(this.mLivenessList.get(i), false);
        }
    }

    public void reset() {
        this.mLivenessIndex = 0;
        this.clearLivenessStatus();
        if (this.mLivenessList != null && this.mLivenessIndex < this.mLivenessList.size()) {
            this.mCurrentLivenessTypeEnum = this.mLivenessList.get(this.mLivenessIndex);
        }
        this.mLivenessDuration = System.currentTimeMillis();
        this.mLivenessTimeoutFlag = false;
    }

    public void resetState() {
        this.mLivenessDuration = System.currentTimeMillis();
        this.mLivenessTimeoutFlag = false;
    }
}

