/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import com.baidu.idl.face.platform.utils.Base64Utils;
import com.baidu.idl.face.platform.utils.DensityUtils;
import com.baidu.idl.face.platform.utils.ImageExif;
import com.baidu.idl.face.platform.utils.IoUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class BitmapUtils {
    private static final String TAG = "ImageUtils";
    private static final int QUALITY = 100;
    public static final int ROTATE0 = 0;
    public static final int ROTATE90 = 90;
    public static final int ROTATE180 = 180;
    public static final int ROTATE270 = 270;
    public static final int ROTATE360 = 360;
    public static final int PIC_COMPRESS_SIZE = 4;
    public static final int IMAGEBOUND = 128;
    public static final int MAXLENTH = 1024;
    private static final int DEFAULT_MAX_SIZE_CELL_NETWORK = 600;
    private static final int QUESTION_MAX_SIZE_CELL_NETWORK = 1024;
    private static final int QUESTION_IMAGE_JPG_QUALITY = 75;
    private static final int DEFAULT_IMAGE_JPG_QUALITY = 50;
    private static final int CONNECTTIMEOUT = 3000;
    public static final String IMAGE_KEY_SUFFIX = "jpg";
    private static final int DEFAULT_JPEG_QUALITY = 90;

    private BitmapUtils() {
    }

    public static Bitmap createBitmap(Context context, byte[] data, float orientation) {
        Bitmap bitmap = null;
        Bitmap transformed = null;
        BitmapFactory.Options opts = new BitmapFactory.Options();
        try {
            int width = DensityUtils.getDisplayWidth(context);
            int hight = DensityUtils.getDisplayHeight(context);
            int min = Math.min(width, hight);
            opts.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
            opts.inSampleSize = BitmapUtils.computeSampleSize(opts, min, 0x100000);
            opts.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
            transformed = BitmapUtils.rotateBitmap(orientation, bitmap);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            if (bitmap != null && !bitmap.isRecycled()) {
                bitmap.recycle();
                bitmap = null;
            }
            if (transformed != null && !transformed.isRecycled()) {
                transformed.recycle();
                transformed = null;
            }
            opts.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
            opts.inSampleSize = BitmapUtils.computeSampleSize(opts, -1, opts.outWidth * opts.outHeight / 4);
            opts.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
            transformed = BitmapUtils.rotateBitmap(orientation, bitmap);
        }
        if (transformed != bitmap && bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
        return transformed;
    }

    public static Bitmap rotateBitmap(float orientation, Bitmap bitmap) {
        Bitmap transformed;
        Matrix m = new Matrix();
        if (orientation == 0.0f) {
            transformed = bitmap;
        } else {
            m.setRotate(orientation);
            transformed = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
        }
        return transformed;
    }

    public static int computeSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int roundedSize;
        int initialSize = BitmapUtils.computeInitialSampleSize(options, minSideLength, maxNumOfPixels);
        if (initialSize <= 8) {
            for (roundedSize = 1; roundedSize < initialSize; roundedSize <<= 1) {
            }
        } else {
            roundedSize = (initialSize + 7) / 8 * 8;
        }
        return roundedSize;
    }

    public static int computeInitialSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int upperBound;
        double w = options.outWidth;
        double h = options.outHeight;
        int lowerBound = maxNumOfPixels == -1 ? 1 : (int)Math.ceil(Math.sqrt(w * h / (double)maxNumOfPixels));
        int n = upperBound = minSideLength == -1 ? 128 : (int)Math.min(Math.floor(w / (double)minSideLength), Math.floor(h / (double)minSideLength));
        if (upperBound < lowerBound) {
            return lowerBound;
        }
        if (maxNumOfPixels == -1 && minSideLength == -1) {
            return 1;
        }
        if (minSideLength == -1) {
            return lowerBound;
        }
        return upperBound;
    }

    public static int decodeImageDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                    break;
                }
                default: {
                    degree = 0;
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            degree = 0;
        }
        return degree;
    }

    public static String bitmapToJpegBase64(Bitmap bitmap, int quality, float maxSize) {
        try {
            float scale = maxSize / (float)Math.max(bitmap.getWidth(), bitmap.getHeight());
            if (scale < 1.0f) {
                bitmap = BitmapUtils.scale(bitmap, scale);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)out);
            byte[] data = out.toByteArray();
            out.close();
            return Base64Utils.encodeToString(data, 2);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String bitmapToJpegBase64(Context context, String type, Bitmap bitmap) {
        float maxSize = (float)BitmapUtils.getSizeParams(context, type) * 1.0f;
        int quality = BitmapUtils.getQuealityParams(context, type);
        try {
            float scale = maxSize / (float)Math.max(bitmap.getWidth(), bitmap.getHeight());
            if (scale < 1.0f) {
                bitmap = BitmapUtils.scale(bitmap, scale);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)out);
            byte[] data = out.toByteArray();
            out.close();
            return Base64Utils.encodeToString(data, 2);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static int getSizeParams(Context context, String type) {
        int maxSize = 600;
        if (type == null) {
            return maxSize;
        }
        maxSize = 600;
        return maxSize;
    }

    private static int getQuealityParams(Context context, String type) {
        int quality = 50;
        if (type == null) {
            return quality;
        }
        return quality;
    }

    private static Bitmap scale(Bitmap bitmap, float scale) {
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static Bitmap scale(Bitmap bitmap, int w, int h) {
        if (bitmap == null) {
            return null;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = (float)w / (float)width;
        float scaleHeight = (float)h / (float)height;
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }

    public static Bitmap calculateInSampleSize(Bitmap resBitmap, int desWidth, int desHeight) {
        int resWidth = resBitmap.getWidth();
        int resHeight = resBitmap.getHeight();
        if (resHeight > desHeight || resWidth > desWidth) {
            float heightRatio = (float)desHeight / (float)resHeight;
            float widthRatio = (float)desWidth / (float)resWidth;
            float scale = heightRatio < widthRatio ? heightRatio : widthRatio;
            return BitmapUtils.scale(resBitmap, scale);
        }
        return resBitmap;
    }

    public static int decodeImageDegree(byte[] jpeg) {
        int degree = ImageExif.getOrientation(jpeg);
        return degree;
    }

    public static Bitmap createBitmap(Context context, String filename, int orientatoin) {
        Bitmap bitmap = null;
        Bitmap transformed = null;
        BitmapFactory.Options opts = new BitmapFactory.Options();
        try {
            int width = DensityUtils.getDisplayWidth(context);
            int hight = DensityUtils.getDisplayHeight(context);
            int min = Math.min(width, hight);
            opts.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)opts);
            opts.inSampleSize = BitmapUtils.computeSampleSize(opts, min, 0x100000);
            opts.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)opts);
            transformed = BitmapUtils.rotateBitmap(orientatoin, bitmap);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            if (bitmap != null) {
                bitmap.recycle();
            }
            opts.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)opts);
            opts.inSampleSize = BitmapUtils.computeSampleSize(opts, -1, opts.outWidth * opts.outHeight / 4);
            opts.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)opts);
            transformed = BitmapUtils.rotateBitmap(orientatoin, bitmap);
        }
        if (transformed != bitmap && bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
        return transformed;
    }

    public static Bitmap createBitmap(Context context, byte[] imageByte, int orientatoin) {
        Bitmap bitmap = null;
        Bitmap transformed = null;
        BitmapFactory.Options opts = new BitmapFactory.Options();
        try {
            int width = DensityUtils.getDisplayWidth(context);
            int hight = DensityUtils.getDisplayHeight(context);
            int min = Math.min(width, hight);
            opts.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeByteArray((byte[])imageByte, (int)0, (int)imageByte.length);
            transformed = BitmapUtils.rotateBitmap(orientatoin, bitmap);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            if (bitmap != null) {
                bitmap.recycle();
            }
            opts.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])imageByte, (int)0, (int)imageByte.length, (BitmapFactory.Options)opts);
            opts.inSampleSize = BitmapUtils.computeSampleSize(opts, -1, opts.outWidth * opts.outHeight / 4);
            opts.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeByteArray((byte[])imageByte, (int)0, (int)imageByte.length, (BitmapFactory.Options)opts);
            transformed = BitmapUtils.rotateBitmap(orientatoin, bitmap);
        }
        if (transformed != bitmap && bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
        return transformed;
    }

    public static Bitmap createBitmap(Context context, int[] argbByte, Rect roundRect, Rect cropRect, int orientatoin) {
        Bitmap transformed;
        Bitmap bitmap;
        block3: {
            bitmap = null;
            transformed = null;
            BitmapFactory.Options opts = new BitmapFactory.Options();
            try {
                opts.inJustDecodeBounds = false;
                bitmap = Bitmap.createBitmap((int[])argbByte, (int)roundRect.width(), (int)roundRect.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)cropRect.left, (int)cropRect.top, (int)cropRect.width(), (int)cropRect.height());
                transformed = BitmapUtils.rotateBitmap(orientatoin, bitmap);
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                if (bitmap == null) break block3;
                bitmap.recycle();
            }
        }
        if (transformed != bitmap && bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
        return transformed;
    }

    public static Bitmap createBitmap(Context context, int pw, int ph, int[] argbByte) {
        Bitmap transformed;
        Bitmap bitmap;
        block3: {
            bitmap = null;
            transformed = null;
            BitmapFactory.Options opts = new BitmapFactory.Options();
            try {
                int width = DensityUtils.getDisplayWidth(context);
                int hight = DensityUtils.getDisplayHeight(context);
                int min = Math.min(width, hight);
                opts.inJustDecodeBounds = false;
                bitmap = Bitmap.createBitmap((int[])argbByte, (int)pw, (int)ph, (Bitmap.Config)Bitmap.Config.RGB_565);
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                if (bitmap == null) break block3;
                bitmap.recycle();
            }
        }
        if (transformed != bitmap && bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
        return transformed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String bitmapToJpegBase64(Bitmap bitmap, int quality) {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)out);
            byte[] data = out.toByteArray();
            String string = Base64Utils.encodeToString(data, 2);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static Bitmap loadBitmapFromFile(String path) {
        Bitmap bitmap = null;
        if (path != null) {
            try {
                bitmap = BitmapFactory.decodeFile((String)path);
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return bitmap;
    }

    public static Bitmap loadBitmapFromFile(Context context, String path) {
        Bitmap bitmap = null;
        if (path != null) {
            try {
                int orientatoin = BitmapUtils.decodeImageDegree(path);
                bitmap = BitmapUtils.createBitmap(context, path, orientatoin);
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return bitmap;
    }

    public static boolean saveTakePictureResult(Context context, String folderName, Bitmap image) {
        boolean flag = false;
        File file = null;
        String dir = BitmapUtils.getTakePictureCacheDir(context);
        if (!TextUtils.isEmpty((CharSequence)dir)) {
            file = new File(dir = dir + File.separator + folderName);
            if (BitmapUtils.ensureDirectoryExist(file)) {
                String imageFileName = String.format("B%s.%s", System.currentTimeMillis() / 1000L, IMAGE_KEY_SUFFIX);
                file = new File(folderName + File.separator + imageFileName);
                boolean fileFlag = true;
                try {
                    if (!file.exists()) {
                        fileFlag = file.createNewFile();
                    }
                }
                catch (IOException e) {
                    fileFlag = false;
                }
                if (fileFlag) {
                    BitmapUtils.compressToFile(image, 100, dir + File.separator + imageFileName);
                    flag = true;
                }
            } else {
                flag = false;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    public static String getTakePictureCacheDir(Context context) {
        File cacheDir = null;
        boolean sdcardWriteable = TextUtils.equals((CharSequence)"mounted", (CharSequence)Environment.getExternalStorageState());
        if (sdcardWriteable) {
            cacheDir = Environment.getExternalStorageDirectory();
        }
        return null != cacheDir ? cacheDir.getAbsolutePath() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Uri saveTakePictureImage(byte[] data, String dir, String filename) {
        File file = new File(dir, filename);
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            fout.write(data);
            fout.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                if (file != null && file.exists() && file.isFile()) {
                    file.delete();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Uri uri = null;
            return uri;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Uri.fromFile((File)file);
    }

    public static boolean ensureDirectoryExist(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (SecurityException e) {
                return false;
            }
        }
        return true;
    }

    public static void compressToFile(Bitmap bitmap, String path) {
        BitmapUtils.compressToFile(bitmap, 90, path);
    }

    public static void compressToFile(Bitmap bitmap, int quality, String path) {
        BitmapUtils.compressToFile(bitmap, Bitmap.CompressFormat.JPEG, quality, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void compressToFile(Bitmap bitmap, Bitmap.CompressFormat format, int quality, String path) {
        File f = new File(path);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            bitmap.compress(format, quality, (OutputStream)fos);
            fos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                if (f != null && f.exists() && f.isFile()) {
                    f.delete();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            IoUtils.closeQuietly(fos);
        }
        catch (Exception ex) {
            try {
                if (f != null && f.exists() && f.isFile()) {
                    f.delete();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fos);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly(fos);
        }
        IoUtils.closeQuietly(fos);
    }

    public static Bitmap createLivenessBitmap(Context context, int[] argbByte, Rect roundRect, Rect cropRect, int orientatoin) {
        Bitmap transformed;
        Bitmap bitmap;
        block3: {
            bitmap = null;
            transformed = null;
            BitmapFactory.Options opts = new BitmapFactory.Options();
            try {
                opts.inJustDecodeBounds = false;
                bitmap = Bitmap.createBitmap((int[])argbByte, (int)roundRect.width(), (int)roundRect.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)cropRect.left, (int)cropRect.top, (int)cropRect.width(), (int)cropRect.height());
                transformed = BitmapUtils.rotateBitmap(orientatoin, bitmap);
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                if (bitmap == null) break block3;
                bitmap.recycle();
            }
        }
        if (transformed != bitmap && bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
        return transformed;
    }

    public static Bitmap createLivenessBitmap(Context context, int[] argbByte, Rect roundRect) {
        Bitmap transformed;
        block2: {
            transformed = null;
            try {
                transformed = Bitmap.createBitmap((int[])argbByte, (int)roundRect.width(), (int)roundRect.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                if (transformed == null) break block2;
                transformed.recycle();
            }
        }
        return transformed;
    }
}

