/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.SoundPool;
import android.util.SparseIntArray;
import com.baidu.idl.face.platform.utils.APIUtils;

public final class SoundPlayer {
    private static final boolean DEBUG = false;
    private static final String TAG = SoundPlayer.class.getSimpleName();
    private SoundPool mSoundPool = new SoundPool(5, 3, 0);
    private SparseIntArray mSoundPoolCache = new SparseIntArray();
    public static final int MAX_STREAMS = 5;
    private static SoundPlayer sSoundPlayer;
    private static final long LOAD_SOUND_MILLIS = 100L;
    public static long playTime;

    private SoundPlayer() {
        playTime = 0L;
    }

    @SuppressLint(value={"NewApi"})
    public static void play(Context context, int resId) {
        int id;
        if (null == sSoundPlayer) {
            sSoundPlayer = new SoundPlayer();
        }
        if (0 == (id = SoundPlayer.sSoundPlayer.mSoundPoolCache.get(resId))) {
            final int soundId = SoundPlayer.sSoundPlayer.mSoundPool.load(context, resId, 1);
            SoundPlayer.sSoundPlayer.mSoundPoolCache.put(resId, soundId);
            if (APIUtils.hasFroyo()) {
                SoundPlayer.sSoundPlayer.mSoundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

                    public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                        if (0 == status && soundId == sampleId) {
                            try {
                                playTime = System.currentTimeMillis();
                                sSoundPlayer.mSoundPool.play(soundId, 1.0f, 1.0f, 5, 0, 1.0f);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            } else {
                try {
                    Thread.currentThread().join(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                playTime = System.currentTimeMillis();
                SoundPlayer.sSoundPlayer.mSoundPool.play(soundId, 1.0f, 1.0f, 5, 0, 1.0f);
            }
        } else {
            try {
                SoundPlayer.sSoundPlayer.mSoundPool.play(id, 1.0f, 1.0f, 5, 0, 1.0f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void release() {
        if (null != sSoundPlayer) {
            int n = SoundPlayer.sSoundPlayer.mSoundPoolCache.size();
            for (int i = 0; i < n; ++i) {
                SoundPlayer.sSoundPlayer.mSoundPool.unload(SoundPlayer.sSoundPlayer.mSoundPoolCache.valueAt(i));
            }
            SoundPlayer.sSoundPlayer.mSoundPool.release();
            SoundPlayer.sSoundPlayer.mSoundPool = null;
            SoundPlayer.sSoundPlayer.mSoundPoolCache.clear();
            SoundPlayer.sSoundPlayer.mSoundPoolCache = null;
            sSoundPlayer = null;
        }
    }

    static {
        playTime = 0L;
    }
}

