/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.decode;

import android.graphics.Bitmap;
import com.baidu.idl.face.platform.FaceStatusEnum;
import com.baidu.idl.face.platform.IDetect;
import com.baidu.idl.face.platform.ILiveness;
import com.baidu.idl.face.platform.LivenessTypeEnum;
import com.baidu.idl.face.platform.model.FaceExtInfo;
import com.baidu.idl.face.platform.model.FaceModel;
import com.baidu.idl.face.platform.utils.BitmapUtils;
import com.baidu.idl.facesdk.FaceInfo;
import com.baidu.idl.facesdk.FaceSDK;
import com.baidu.idl.facesdk.FaceTracker;
import com.baidu.idl.facesdk.FaceVerifyData;
import java.util.ArrayList;

public class FaceModule
implements IDetect,
ILiveness {
    private static final String TAG = FaceModule.class.getSimpleName();
    private FaceTracker mFaceTracker;
    private int mImageWidth = 0;
    private int mImageHeight = 0;
    private int[] mArgbData = null;
    private int[] mSaveFaceArgbData = null;
    private int mErrCode = 0;
    private boolean mLivenessFlag = false;
    private FaceModel mFaceModel;
    private FaceExtInfo[] mFaceExtInfos;
    private FaceExtInfo mFaceExtInfo;
    private int mDegree = 90;

    public FaceModule(FaceTracker tracker) {
        this.mFaceTracker = tracker;
        if (this.mFaceTracker != null) {
            this.mFaceTracker.clearTrackedFaces();
        }
    }

    @Override
    public FaceModel detect(byte[] imageData, int imageWidth, int imageHeight) {
        FaceModel model = null;
        if (imageData != null && imageWidth > 0 && imageHeight > 0) {
            model = new FaceModel();
            FaceInfo[] faceInfos = this.faceTrackerDecode(imageData, imageWidth, imageHeight);
            model.setArgbImage(this.mArgbData);
            model.setFaceInfos(this.getExtInfo(faceInfos));
            model.setFaceModuleState(this.getModuleState(this.mErrCode));
            model.setFrameTime(System.currentTimeMillis());
        }
        return model;
    }

    @Override
    public FaceModel liveness(LivenessTypeEnum type, byte[] imageData, int imageWidth, int imageHeight) {
        FaceModel model = null;
        if (imageData != null && type != null && imageWidth > 0 && imageHeight > 0) {
            model = new FaceModel();
            FaceInfo[] faceInfos = this.faceTrackerDecode(imageData, imageWidth, imageHeight);
            model.setArgbImage(this.mArgbData);
            model.setFaceInfos(this.getExtInfo(faceInfos));
            model.setFaceModuleState(this.getModuleState(this.mErrCode));
            model.setFrameTime(System.currentTimeMillis());
        }
        return model;
    }

    private FaceExtInfo[] getExtInfo(FaceInfo[] faceInfos) {
        if (this.mFaceExtInfos == null) {
            this.mFaceExtInfos = new FaceExtInfo[1];
            this.mFaceExtInfo = new FaceExtInfo();
        }
        if (faceInfos != null && faceInfos.length > 0) {
            if (this.mFaceExtInfo == null) {
                this.mFaceExtInfo = new FaceExtInfo();
            }
            this.mFaceExtInfo.addFaceInfo(faceInfos[0]);
            this.mFaceExtInfos[0] = this.mFaceExtInfo;
        } else {
            this.mFaceExtInfos[0] = null;
        }
        return this.mFaceExtInfos;
    }

    private FaceStatusEnum getModuleState(int errCode) {
        FaceStatusEnum status = FaceStatusEnum.Detect_NoFace;
        if (errCode == FaceTracker.ErrCode.OK.ordinal()) {
            status = FaceStatusEnum.OK;
        } else if (errCode == FaceTracker.ErrCode.PITCH_OUT_OF_DOWN_MAX_RANGE.ordinal()) {
            status = FaceStatusEnum.Detect_PitchOutOfDownMaxRange;
        } else if (errCode == FaceTracker.ErrCode.PITCH_OUT_OF_UP_MAX_RANGE.ordinal()) {
            status = FaceStatusEnum.Detect_PitchOutOfUpMaxRange;
        } else if (errCode == FaceTracker.ErrCode.YAW_OUT_OF_LEFT_MAX_RANGE.ordinal()) {
            status = FaceStatusEnum.Detect_PitchOutOfLeftMaxRange;
        } else if (errCode == FaceTracker.ErrCode.YAW_OUT_OF_RIGHT_MAX_RANGE.ordinal()) {
            status = FaceStatusEnum.Detect_PitchOutOfRightMaxRange;
        } else if (errCode == FaceTracker.ErrCode.POOR_ILLUMINATION.ordinal()) {
            status = FaceStatusEnum.Detect_PoorIllumintion;
        } else if (errCode == FaceTracker.ErrCode.NO_FACE_DETECTED.ordinal()) {
            status = FaceStatusEnum.Detect_NoFace;
        } else if (errCode == FaceTracker.ErrCode.DATA_NOT_READY.ordinal()) {
            status = FaceStatusEnum.Detect_DataNotReady;
        } else if (errCode == FaceTracker.ErrCode.DATA_HIT_ONE.ordinal()) {
            status = FaceStatusEnum.Detect_DataHitOne;
        } else if (errCode == FaceTracker.ErrCode.DATA_HIT_LAST.ordinal()) {
            status = FaceStatusEnum.Detect_DataHitLast;
        } else if (errCode == FaceTracker.ErrCode.IMG_BLURED.ordinal()) {
            status = FaceStatusEnum.Detect_ImageBlured;
        } else if (errCode == FaceTracker.ErrCode.OCCLUSION_LEFT_EYE.ordinal()) {
            status = FaceStatusEnum.Detect_OccLeftEye;
        } else if (errCode == FaceTracker.ErrCode.OCCLUSION_RIGHT_EYE.ordinal()) {
            status = FaceStatusEnum.Detect_OccRightEye;
        } else if (errCode == FaceTracker.ErrCode.OCCLUSION_NOSE.ordinal()) {
            status = FaceStatusEnum.Detect_OccNose;
        } else if (errCode == FaceTracker.ErrCode.OCCLUSION_MOUTH.ordinal()) {
            status = FaceStatusEnum.Detect_OccMouth;
        } else if (errCode == FaceTracker.ErrCode.OCCLUSION_LEFT_CONTOUR.ordinal()) {
            status = FaceStatusEnum.Detect_OccLeftContour;
        } else if (errCode == FaceTracker.ErrCode.OCCLUSION_RIGHT_CONTOUR.ordinal()) {
            status = FaceStatusEnum.Detect_OccRightContour;
        } else if (errCode == FaceTracker.ErrCode.OCCLUSION_CHIN_CONTOUR.ordinal()) {
            status = FaceStatusEnum.Detect_OccChin;
        } else if (errCode == FaceTracker.ErrCode.FACE_NOT_COMPLETE.ordinal()) {
            status = FaceStatusEnum.Detect_FaceNotComplete;
        } else if (errCode == FaceTracker.ErrCode.UNKNOW_TYPE.ordinal()) {
            status = FaceStatusEnum.Detect_NoFace;
        }
        return status;
    }

    @Override
    public int[] getBestFaceImage() {
        return this.mSaveFaceArgbData;
    }

    public void setPreviewDegree(int degree) {
        if (degree >= 0 && degree <= 360) {
            this.mDegree = degree;
        }
    }

    public String getDetectBestImage(int faceId) {
        String imageEncode = "";
        FaceVerifyData[] faceVerifyDatas = this.mFaceTracker.get_FaceVerifyData(0);
        if (faceVerifyDatas != null && faceVerifyDatas.length > 0) {
            int index = faceVerifyDatas.length - 1;
            Bitmap image = Bitmap.createBitmap((int)faceVerifyDatas[index].cols, (int)faceVerifyDatas[index].rows, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            image.setPixels(faceVerifyDatas[index].mRegImg, 0, faceVerifyDatas[index].cols, 0, 0, faceVerifyDatas[index].cols, faceVerifyDatas[index].rows);
            imageEncode = BitmapUtils.bitmapToJpegBase64(image, 100);
            if (imageEncode != null && imageEncode.length() > 0) {
                imageEncode = imageEncode.replace("\\/", "/");
            }
        }
        return imageEncode;
    }

    public String getDetectBestImage() {
        String imageEncode = "";
        FaceVerifyData[] faceVerifyDatas = this.mFaceTracker.get_FaceVerifyData(0);
        if (faceVerifyDatas != null && faceVerifyDatas.length > 0) {
            int index = faceVerifyDatas.length - 1;
            Bitmap image = Bitmap.createBitmap((int)faceVerifyDatas[index].cols, (int)faceVerifyDatas[index].rows, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            image.setPixels(faceVerifyDatas[index].mRegImg, 0, faceVerifyDatas[index].cols, 0, 0, faceVerifyDatas[index].cols, faceVerifyDatas[index].rows);
            imageEncode = BitmapUtils.bitmapToJpegBase64(image, 100);
            if (imageEncode != null && imageEncode.length() > 0) {
                imageEncode = imageEncode.replace("\\/", "/");
            }
        }
        return imageEncode;
    }

    public ArrayList<String> getDetectBestImageList() {
        ArrayList<String> list = new ArrayList<String>();
        FaceVerifyData[] faceVerifyDatas = this.mFaceTracker.get_FaceVerifyData(0);
        if (faceVerifyDatas != null && faceVerifyDatas.length > 0) {
            String imageEncode = "";
            for (int i = 0; i < faceVerifyDatas.length; ++i) {
                Bitmap image = Bitmap.createBitmap((int)faceVerifyDatas[i].cols, (int)faceVerifyDatas[i].rows, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                image.setPixels(faceVerifyDatas[i].mRegImg, 0, faceVerifyDatas[i].cols, 0, 0, faceVerifyDatas[i].cols, faceVerifyDatas[i].rows);
                imageEncode = BitmapUtils.bitmapToJpegBase64(image, 100);
                if (imageEncode != null && imageEncode.length() > 0) {
                    imageEncode = imageEncode.replace("\\/", "/");
                }
                list.add(imageEncode);
            }
        }
        return list;
    }

    private FaceInfo[] faceTrackerDecode(byte[] imageData, int imageWidth, int imageHeight) {
        FaceInfo[] faces = null;
        if (this.mArgbData == null || imageWidth * imageHeight != this.mImageWidth * this.mImageHeight) {
            this.mArgbData = new int[imageWidth * imageHeight];
            this.mImageWidth = imageWidth;
            this.mImageHeight = imageHeight;
        }
        long startTime = System.nanoTime();
        if (FaceSDK.getAuthorityStatus() == 0) {
            FaceSDK.getARGBFromYUVimg((byte[])imageData, (int[])this.mArgbData, (int)imageWidth, (int)imageHeight, (int)(360 - this.mDegree), (int)1);
            FaceTracker.ErrCode errorCode = this.mFaceTracker.faceVerification(this.mArgbData, imageWidth, imageHeight, FaceSDK.ImgType.ARGB, FaceTracker.ActionType.RECOGNIZE);
            this.mErrCode = errorCode.ordinal();
            faces = this.mFaceTracker.get_TrackedFaceInfo();
            long endingTime = System.nanoTime();
            Float fps = Float.valueOf(1.0E9f / (float)(endingTime - startTime + 1L));
            if (faces != null && faces.length > 0 && this.mErrCode == FaceTracker.ErrCode.OK.ordinal()) {
                this.mSaveFaceArgbData = this.mArgbData;
            }
        }
        return faces;
    }

    @Override
    public void reset() {
        if (this.mFaceTracker != null) {
            this.mFaceTracker.re_collect_reg_imgs();
            this.mFaceTracker.clearTrackedFaces();
        }
    }
}

