/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.strategy;

import android.graphics.Rect;
import com.baidu.idl.face.platform.FaceEnvironment;
import com.baidu.idl.face.platform.FaceStatusEnum;
import com.baidu.idl.face.platform.LivenessTypeEnum;

class DetectStrategy {
    private static final String TAG = DetectStrategy.class.getSimpleName();
    private LivenessTypeEnum mLivenessTypeEnum;
    private FaceStatusEnum mCurrentFaceStatus;
    private int mHeadPitchValue = 10;
    private int mHeadYawValue = 10;
    private int mHeadRollValue = 10;
    private long mDuration = 0L;
    private boolean mTimeoutFlag = false;
    private boolean mIsDetectSuccess = false;

    public void setHeadAngle(int p, int y, int r) {
        this.mHeadPitchValue = p;
        this.mHeadYawValue = y;
        this.mHeadRollValue = r;
    }

    public void setLiveness(LivenessTypeEnum type) {
        this.mLivenessTypeEnum = type;
    }

    public boolean isTimeout() {
        return this.mTimeoutFlag;
    }

    public boolean isDetectCheckSuccess() {
        return this.mIsDetectSuccess;
    }

    public FaceStatusEnum checkDetect(Rect previewRect, Rect detectRect, float headh, float headv, int faceOutCount, int faceWidth, FaceStatusEnum status) {
        boolean flag = this.isDefaultDetectStatus(status);
        if (flag) {
            this.checkTimeout(status);
            return status;
        }
        if (faceWidth > detectRect.width() * 1) {
            status = FaceStatusEnum.Detect_FaceZoomOut;
            this.checkTimeout(status);
            return status;
        }
        if ((float)faceWidth < (float)detectRect.width() * 0.4f) {
            status = FaceStatusEnum.Detect_FaceZoomIn;
            this.checkTimeout(status);
            return status;
        }
        FaceStatusEnum st = this.getHeadPose(headh, headv);
        if (st != null) {
            status = st;
        }
        if (faceOutCount > 10) {
            status = FaceStatusEnum.Detect_FacePointOut;
            this.checkTimeout(status);
            return status;
        }
        this.checkTimeout(status);
        if (status == FaceStatusEnum.OK) {
            this.mIsDetectSuccess = true;
        }
        return status;
    }

    private FaceStatusEnum getHeadPose(float headh, float headv) {
        FaceStatusEnum status = null;
        float left = this.mHeadYawValue;
        float right = this.mHeadYawValue;
        float up = this.mHeadPitchValue;
        float down = this.mHeadPitchValue;
        if (headh > up && this.mLivenessTypeEnum != LivenessTypeEnum.HeadDown) {
            status = FaceStatusEnum.Detect_PitchOutOfDownMaxRange;
        } else if (headh < down * -1.0f && this.mLivenessTypeEnum != LivenessTypeEnum.HeadUp) {
            status = FaceStatusEnum.Detect_PitchOutOfUpMaxRange;
        } else if (headv > left && this.mLivenessTypeEnum != LivenessTypeEnum.HeadLeft && this.mLivenessTypeEnum != LivenessTypeEnum.HeadLeftOrRight) {
            status = FaceStatusEnum.Detect_PitchOutOfLeftMaxRange;
        } else if (headv < right * -1.0f && this.mLivenessTypeEnum != LivenessTypeEnum.HeadRight && this.mLivenessTypeEnum != LivenessTypeEnum.HeadLeftOrRight) {
            status = FaceStatusEnum.Detect_PitchOutOfRightMaxRange;
        }
        return status;
    }

    private void checkTimeout(FaceStatusEnum status) {
        if (this.mCurrentFaceStatus == null || this.mCurrentFaceStatus != status) {
            this.mCurrentFaceStatus = status;
            this.mDuration = System.currentTimeMillis();
            this.mTimeoutFlag = false;
        }
        long t = System.currentTimeMillis();
        if (this.mCurrentFaceStatus == status && t - this.mDuration > FaceEnvironment.TIME_DETECT_MODULE) {
            this.mTimeoutFlag = true;
        }
    }

    private boolean isDefaultDetectStatus(FaceStatusEnum status) {
        boolean flag = false;
        switch (status) {
            case Detect_PoorIllumintion: 
            case Detect_ImageBlured: 
            case Detect_OccLeftEye: 
            case Detect_OccRightEye: 
            case Detect_OccNose: 
            case Detect_OccMouth: 
            case Detect_OccLeftContour: 
            case Detect_OccRightContour: 
            case Detect_OccChin: 
            case Detect_FaceZoomIn: 
            case Detect_FaceZoomOut: 
            case Detect_FacePointOut: 
            case Detect_PitchOutOfUpMaxRange: 
            case Detect_PitchOutOfDownMaxRange: 
            case Detect_PitchOutOfLeftMaxRange: 
            case Detect_PitchOutOfRightMaxRange: {
                flag = true;
                break;
            }
        }
        return flag;
    }

    public void reset() {
        this.mDuration = 0L;
        this.mTimeoutFlag = false;
        this.mIsDetectSuccess = false;
        this.mCurrentFaceStatus = null;
    }
}

