/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.strategy;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.Log;
import com.baidu.idl.face.platform.FaceConfig;
import com.baidu.idl.face.platform.FaceEnvironment;
import com.baidu.idl.face.platform.FaceStatusEnum;
import com.baidu.idl.face.platform.IDetectStrategy;
import com.baidu.idl.face.platform.IDetectStrategyCallback;
import com.baidu.idl.face.platform.common.LogHelper;
import com.baidu.idl.face.platform.common.SoundPoolHelper;
import com.baidu.idl.face.platform.model.FaceExtInfo;
import com.baidu.idl.face.platform.model.FaceModel;
import com.baidu.idl.face.platform.strategy.DetectStrategy;
import com.baidu.idl.face.platform.strategy.FaceStrategyModule;
import com.baidu.idl.face.platform.utils.BitmapUtils;
import com.baidu.idl.facesdk.FaceTracker;
import java.util.ArrayList;
import java.util.HashMap;

public final class FaceDetectStrategyExtModule
extends FaceStrategyModule
implements IDetectStrategy {
    private static final String TAG = FaceDetectStrategyExtModule.class.getSimpleName();
    private Context mContext;
    private Rect mPreviewRect;
    private Rect mDetectRect;
    private DetectStrategy mDetectStrategy;
    private SoundPoolHelper mSoundPlayHelper = null;
    private boolean mIsFirstTipsed = false;
    private volatile boolean mIsEnableSound = true;
    private volatile boolean mIsPlayCompletion = false;
    protected HashMap<String, String> mBase64ImageMap = new HashMap();
    protected HashMap<FaceStatusEnum, String> mTipsMap = new HashMap();
    private IDetectStrategyCallback mIDetectStrategyCallback;

    public FaceDetectStrategyExtModule(Context context, FaceTracker tracker) {
        super(tracker);
        LogHelper.addLog("appid", context.getPackageName());
        this.mContext = context;
        this.mDetectStrategy = new DetectStrategy();
        this.mSoundPlayHelper = new SoundPoolHelper(context);
        this.mLaunchTime = System.currentTimeMillis();
    }

    public void setConfigValue(FaceConfig config) {
        if (config != null && this.mDetectStrategy != null) {
            this.mDetectStrategy.setHeadAngle(config.getHeadPitchValue(), config.getHeadYawValue(), config.getHeadRollValue());
        }
    }

    @Override
    public void setDetectStrategyConfig(Rect previewRect, Rect detectRect, IDetectStrategyCallback callback) {
        this.mPreviewRect = previewRect;
        this.mDetectRect = detectRect;
        this.mIDetectStrategyCallback = callback;
    }

    @Override
    public void setDetectStrategySoundEnable(boolean flag) {
        this.mIsEnableSound = flag;
    }

    @Override
    public void setPreviewDegree(int degree) {
        if (this.mFaceModule != null) {
            this.mFaceModule.setPreviewDegree(degree);
        }
    }

    @Override
    public String getBestFaceImage() {
        String encodeImage = "";
        if (this.mFaceModule != null && this.mFaceModule.getBestFaceImage() != null && this.mFaceModule.getBestFaceImage().length > 0) {
            try {
                int[] image = this.mFaceModule.getBestFaceImage();
                int w = this.mPreviewRect.height();
                int h = this.mPreviewRect.width();
                Bitmap bmp = Bitmap.createBitmap((int)h, (int)w, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bmp.setPixels(image, 0, h, 0, 0, h, w);
                encodeImage = BitmapUtils.bitmapToJpegBase64(bmp, 100);
                if (encodeImage != null && encodeImage.length() > 0) {
                    encodeImage = encodeImage.replace("\\/", "/");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Log.e((String)TAG, (String)("getBestFaceImage Exception " + ex.getMessage()));
            }
        }
        return encodeImage;
    }

    @Override
    public void detectStrategy(byte[] imageData) {
        if (!this.mIsFirstTipsed) {
            this.mIsFirstTipsed = true;
            this.processUITips(FaceStatusEnum.Detect_FacePointOut);
        }
        if (this.mIsProcessing) {
            this.process(imageData);
        }
    }

    @Override
    protected void processStrategy(byte[] imageData) {
        FaceModel model = this.mFaceModule.detect(imageData, this.mPreviewRect.height(), this.mPreviewRect.width());
        this.processUIStrategy(new UIDetectResultRunnable(model));
    }

    private void processUIResult(FaceModel model) {
        FaceExtInfo faceInfo;
        if (!this.mIsProcessing) {
            return;
        }
        if (System.currentTimeMillis() - this.mLaunchTime > FaceEnvironment.TIME_MODULE && FaceEnvironment.TIME_MODULE != 0L) {
            this.mIsProcessing = false;
            this.processUICallback(FaceStatusEnum.Error_Timeout);
            return;
        }
        if (model != null && model.getFaceInfos() != null && model.getFaceInfos().length > 0) {
            faceInfo = model.getFaceInfos()[0];
            LogHelper.addLogWithKey("ftm", System.currentTimeMillis());
        } else {
            faceInfo = null;
            if (this.mDetectStrategy != null) {
                this.mDetectStrategy.reset();
            }
        }
        if (faceInfo != null) {
            if (this.mIsCompletion) {
                this.mIsPlayCompletion = this.processUITips(FaceStatusEnum.OK);
                return;
            }
            FaceStatusEnum detectStatus = this.mDetectStrategy.checkDetect(this.mPreviewRect, this.mDetectRect, faceInfo.getPitch(), faceInfo.getYaw(), faceInfo.getLandmarksOutOfDetectCount(this.mDetectRect), faceInfo.getFaceWidth(), model.getFaceModuleState());
            if (detectStatus == FaceStatusEnum.OK || detectStatus == FaceStatusEnum.Detect_DataNotReady) {
                LogHelper.addLogWithKey("btm", System.currentTimeMillis());
            }
            if (detectStatus == FaceStatusEnum.OK) {
                boolean flag = this.processUITips(FaceStatusEnum.OK);
                this.mIsCompletion = true;
                return;
            }
            if (this.mDetectStrategy.isTimeout()) {
                this.mIsProcessing = false;
                this.processUICallback(FaceStatusEnum.Error_DetectTimeout);
                return;
            }
            this.processUITips(detectStatus);
        } else {
            if (model != null && model.getFaceModuleState() == FaceStatusEnum.Detect_NoFace) {
                this.mDetectStrategy.reset();
                if (this.mNoFaceTime == 0L) {
                    this.mNoFaceTime = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - this.mNoFaceTime > FaceEnvironment.TIME_DETECT_MODULE) {
                    this.mIsProcessing = false;
                    this.processUICallback(FaceStatusEnum.Error_DetectTimeout);
                    return;
                }
            } else {
                this.mNoFaceTime = 0L;
            }
            if (this.mDetectStrategy.isTimeout()) {
                this.mIsProcessing = false;
                this.processUICallback(FaceStatusEnum.Error_DetectTimeout);
                return;
            }
            this.processUITips(FaceStatusEnum.Detect_NoFace);
        }
    }

    private boolean processUITips(FaceStatusEnum status) {
        boolean flag = false;
        if (status != null) {
            this.mSoundPlayHelper.setEnableSound(this.mIsEnableSound);
            flag = this.mSoundPlayHelper.playSound(status);
            if (flag) {
                LogHelper.addTipsLogWithKey(status.name());
                this.processUICallback(status);
            }
        }
        return flag;
    }

    private void processUICallback(FaceStatusEnum status) {
        if (status == FaceStatusEnum.Error_DetectTimeout || status == FaceStatusEnum.Error_LivenessTimeout || status == FaceStatusEnum.Error_Timeout) {
            LogHelper.addLogWithKey("etm", System.currentTimeMillis());
            LogHelper.sendLog();
        }
        if (this.mIDetectStrategyCallback != null) {
            if (FaceStatusEnum.OK == status) {
                this.mIsProcessing = false;
                this.mIsCompletion = true;
                LogHelper.addLogWithKey("etm", System.currentTimeMillis());
                LogHelper.addLogWithKey("finish", 1);
                LogHelper.sendLog();
                ArrayList<String> imageList = this.mFaceModule.getDetectBestImageList();
                for (int i = 0; i < imageList.size(); ++i) {
                    this.mBase64ImageMap.put("bestImage" + i, imageList.get(i));
                }
                this.mIDetectStrategyCallback.onDetectCompletion(status, this.getStatusTextResId(status), this.mBase64ImageMap);
            } else {
                this.mIDetectStrategyCallback.onDetectCompletion(status, this.getStatusTextResId(status), null);
            }
        }
    }

    private String getStatusTextResId(FaceStatusEnum status) {
        String tips = "";
        if (this.mTipsMap.containsKey((Object)status)) {
            tips = this.mTipsMap.get((Object)status);
        } else {
            int resId = FaceEnvironment.getTipsId(status);
            if (resId > 0) {
                tips = this.mContext.getResources().getString(resId);
                this.mTipsMap.put(status, tips);
            }
        }
        return tips;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.mSoundPlayHelper != null) {
            this.mSoundPlayHelper.release();
        }
    }

    private class UIDetectResultRunnable
    implements Runnable {
        private final FaceModel mModel;

        public UIDetectResultRunnable(FaceModel model) {
            this.mModel = model;
        }

        @Override
        public void run() {
            FaceDetectStrategyExtModule.this.processUIResult(this.mModel);
        }
    }
}

