/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.strategy;

import com.baidu.idl.face.platform.FaceEnvironment;
import com.baidu.idl.face.platform.FaceStatusEnum;
import com.baidu.idl.face.platform.LivenessTypeEnum;
import java.util.List;

@Deprecated
class LivenessStrategy {
    private static final String TAG = LivenessStrategy.class.getSimpleName();
    private List<LivenessTypeEnum> mLivenessList;
    private long mDuration = System.currentTimeMillis();
    private volatile int mIndex = 0;
    private volatile LivenessTypeEnum mCurrentLivenessTypeEnum = null;
    private volatile boolean mIsCurrentCheckSuccess = false;
    private boolean mTimeoutFlag = false;

    public void setLivenessList(List<LivenessTypeEnum> list) {
        this.mLivenessList = list;
        if (this.mLivenessList != null && this.mIndex < this.mLivenessList.size()) {
            this.mCurrentLivenessTypeEnum = this.mLivenessList.get(this.mIndex);
        }
    }

    public LivenessTypeEnum getCurrentLivenessType() {
        return this.mCurrentLivenessTypeEnum;
    }

    public FaceStatusEnum getCurrentLivenessStatus() {
        FaceStatusEnum status = null;
        if (this.mCurrentLivenessTypeEnum != null) {
            switch (this.mCurrentLivenessTypeEnum) {
                case Eye: {
                    status = FaceStatusEnum.Liveness_Eye;
                    break;
                }
                case Mouth: {
                    status = FaceStatusEnum.Liveness_Mouth;
                    break;
                }
                case HeadUp: {
                    status = FaceStatusEnum.Liveness_HeadUp;
                    break;
                }
                case HeadDown: {
                    status = FaceStatusEnum.Liveness_HeadDown;
                    break;
                }
                case HeadLeft: {
                    status = FaceStatusEnum.Liveness_HeadLeft;
                    break;
                }
                case HeadRight: {
                    status = FaceStatusEnum.Liveness_HeadRight;
                    break;
                }
                case HeadLeftOrRight: {
                    status = FaceStatusEnum.Liveness_HeadLeftRight;
                    break;
                }
            }
        }
        return status;
    }

    public boolean isLivenessCheckSuccess() {
        return this.mIsCurrentCheckSuccess && this.mIndex >= this.mLivenessList.size() - 1;
    }

    public boolean isCurrentLivenessCheckSuccess() {
        return this.mIsCurrentCheckSuccess;
    }

    public boolean isTimeout() {
        return this.mTimeoutFlag;
    }

    public void nextLiveness() {
        if (this.mIndex + 1 < this.mLivenessList.size()) {
            ++this.mIndex;
            this.mIsCurrentCheckSuccess = false;
            this.mCurrentLivenessTypeEnum = this.mLivenessList.get(this.mIndex);
            this.mDuration = System.currentTimeMillis();
        }
    }

    public void checkLiveness(int[] livenessStatus) {
        if (this.mIndex < this.mLivenessList.size() && !this.mIsCurrentCheckSuccess) {
            long t = System.currentTimeMillis();
            if (t - this.mDuration > FaceEnvironment.TIME_LIVENESS_MODULE) {
                this.mTimeoutFlag = true;
                this.mIsCurrentCheckSuccess = false;
            } else {
                this.mIsCurrentCheckSuccess = LivenessStrategy.getLivenessStatus(livenessStatus, this.mCurrentLivenessTypeEnum);
            }
        }
    }

    public static boolean getLivenessStatus(int[] live, LivenessTypeEnum type) {
        boolean flag = false;
        if (type == LivenessTypeEnum.Eye) {
            flag = live[0] == 1;
        } else if (type == LivenessTypeEnum.Mouth) {
            flag = live[3] == 1;
        } else if (type == LivenessTypeEnum.HeadLeft) {
            flag = live[5] == 1;
        } else if (type == LivenessTypeEnum.HeadRight) {
            flag = live[6] == 1;
        } else if (type == LivenessTypeEnum.HeadUp) {
            flag = live[8] == 1;
        } else if (type == LivenessTypeEnum.HeadDown) {
            flag = live[9] == 1;
        } else if (type == LivenessTypeEnum.HeadLeftOrRight) {
            flag = live[5] == 1 || live[6] == 1;
        }
        return flag;
    }

    public void reset() {
        this.mIsCurrentCheckSuccess = false;
        this.mIndex = 0;
        if (this.mLivenessList != null && this.mIndex < this.mLivenessList.size()) {
            this.mCurrentLivenessTypeEnum = this.mLivenessList.get(this.mIndex);
        }
        this.mDuration = System.currentTimeMillis();
        this.mTimeoutFlag = false;
    }

    public void resetState() {
        this.mIsCurrentCheckSuccess = false;
        this.mDuration = System.currentTimeMillis();
        this.mTimeoutFlag = false;
    }
}

