/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.utils;

import android.graphics.Point;
import android.hardware.Camera;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class CameraPreviewUtils {
    private static final String TAG = CameraPreviewUtils.class.getSimpleName();
    private static final int MIN_PREVIEW_PIXELS = 307200;
    private static final int MAX_PREVIEW_PIXELS = 921600;

    public static Point getBestPreview(Camera.Parameters parameters, Point screenResolution) {
        List rawSupportedSizes = parameters.getSupportedPreviewSizes();
        if (rawSupportedSizes == null) {
            Camera.Size defaultSize = parameters.getPreviewSize();
            return new Point(defaultSize.width, defaultSize.height);
        }
        ArrayList supportedPictureSizes = new ArrayList(rawSupportedSizes);
        Collections.sort(supportedPictureSizes, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size a, Camera.Size b) {
                int bPixels = b.height * b.width;
                int aPixels = a.height * a.width;
                if (bPixels < aPixels) {
                    return -1;
                }
                if (bPixels > aPixels) {
                    return 1;
                }
                return 0;
            }
        });
        double screenAspectRatio = screenResolution.x > screenResolution.y ? (double)screenResolution.x / (double)screenResolution.y : (double)screenResolution.y / (double)screenResolution.x;
        Camera.Size selectedSize = null;
        double selectedMinus = -1.0;
        double selectedPreviewSize = 0.0;
        Iterator it = supportedPictureSizes.iterator();
        while (it.hasNext()) {
            Camera.Size supportedPreviewSize = (Camera.Size)it.next();
            int realWidth = supportedPreviewSize.width;
            int realHeight = supportedPreviewSize.height;
            if (realWidth * realHeight < 307200) {
                it.remove();
                continue;
            }
            if (realWidth * realHeight > 921600) {
                it.remove();
                continue;
            }
            double aRatio = supportedPreviewSize.width > supportedPreviewSize.height ? (double)supportedPreviewSize.width / (double)supportedPreviewSize.height : (double)supportedPreviewSize.height / (double)supportedPreviewSize.width;
            double minus = Math.abs(aRatio - screenAspectRatio);
            boolean selectedFlag = false;
            if (selectedMinus == -1.0 && minus <= 0.25 || selectedMinus >= minus && minus <= 0.25) {
                selectedFlag = true;
            }
            if (!selectedFlag) continue;
            selectedMinus = minus;
            selectedSize = supportedPreviewSize;
            selectedPreviewSize = realWidth * realHeight;
        }
        if (selectedSize != null) {
            Camera.Size preview = selectedSize;
            return new Point(preview.width, preview.height);
        }
        Camera.Size defaultSize = parameters.getPreviewSize();
        return new Point(defaultSize.width, defaultSize.height);
    }
}

