/*
 * Decompiled with CFR 0.152.
 */
package com.megvii.livenesslib;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.megvii.livenessdetection.DetectionFrame;

public class FaceMask
extends View {
    public static final int Threshold = 30;
    Paint localPaint = null;
    RectF mFaceRect = new RectF();
    RectF mDrawRect = new RectF();
    private int normal_colour = -16730881;
    private int high_colour = -65536;
    private boolean isFraontalCamera = true;

    public FaceMask(Context context, AttributeSet atti) {
        super(context, atti);
        this.localPaint = new Paint();
        this.localPaint.setColor(this.normal_colour);
        this.localPaint.setStrokeWidth(5.0f);
        this.localPaint.setStyle(Paint.Style.STROKE);
    }

    public void setFaceInfo(DetectionFrame faceInfo) {
        this.mFaceRect = faceInfo != null ? faceInfo.getFacePos() : null;
        this.postInvalidate();
    }

    public void setFrontal(boolean isFrontal) {
        this.isFraontalCamera = isFrontal;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mFaceRect == null) {
            return;
        }
        if (this.isFraontalCamera) {
            this.mDrawRect.set((float)this.getWidth() * (1.0f - this.mFaceRect.right), (float)this.getHeight() * this.mFaceRect.top, (float)this.getWidth() * (1.0f - this.mFaceRect.left), (float)this.getHeight() * this.mFaceRect.bottom);
        } else {
            this.mDrawRect.set((float)this.getWidth() * this.mFaceRect.left, (float)this.getHeight() * this.mFaceRect.top, (float)this.getWidth() * this.mFaceRect.right, (float)this.getHeight() * this.mFaceRect.bottom);
        }
        canvas.drawRect(this.mDrawRect, this.localPaint);
    }
}

