/*
 * Decompiled with CFR 0.152.
 */
package com.megvii.livenesslib.util;

import com.megvii.livenessdetection.DetectionFrame;
import com.megvii.livenessdetection.Detector;
import com.megvii.livenesslib.util.Constant;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class IFile {
    public boolean save(Detector mDetector, String session, JSONObject jsonObject) {
        ArrayList frames = mDetector.getValidFrame();
        if (frames.size() == 0) {
            return false;
        }
        try {
            String dirPath = Constant.dirName + "/" + session;
            File dir = new File(dirPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            for (int i = 0; i < frames.size(); ++i) {
                File file = new File(dir, session + "-" + i + ".jpg");
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(((DetectionFrame)frames.get(i)).getCroppedFaceImageData());
                JSONArray jsonArray = jsonObject.getJSONArray("imgs");
                jsonArray.put((Object)file.getAbsoluteFile());
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean saveOne(Detector mDetector, String session, JSONObject jsonObject) {
        ArrayList frames = mDetector.getValidFrame();
        if (frames.size() == 0) {
            return false;
        }
        try {
            String dirPath = Constant.dirName + "/" + session;
            File dir = new File(dirPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(dir, "only.jpg");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(((DetectionFrame)frames.get(0)).getCroppedFaceImageData());
            JSONArray jsonArray = jsonObject.getJSONArray("imgs");
            jsonArray.put((Object)file.getAbsoluteFile());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean saveLog(String session, String name) {
        try {
            String dirPath = Constant.dirName + "/" + session;
            File dir = new File(dirPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(dir, "Log.txt");
            FileOutputStream fileOutputStream = new FileOutputStream(file, true);
            String str = "\n" + session + ",  " + name;
            fileOutputStream.write(str.getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

