/*
 * Decompiled with CFR 0.152.
 */
package com.megvii.livenesslib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.Handler;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.megvii.livenessdetection.DetectionConfig;
import com.megvii.livenessdetection.DetectionFrame;
import com.megvii.livenessdetection.Detector;
import com.megvii.livenessdetection.FaceQualityManager;
import com.megvii.livenessdetection.bean.FaceInfo;
import com.megvii.livenesslib.FaceMask;
import com.megvii.livenesslib.R;
import com.megvii.livenesslib.util.ConUtil;
import com.megvii.livenesslib.util.DialogUtil;
import com.megvii.livenesslib.util.ICamera;
import com.megvii.livenesslib.util.IDetection;
import com.megvii.livenesslib.util.IFile;
import com.megvii.livenesslib.util.IMediaPlayer;
import com.megvii.livenesslib.util.Screen;
import com.megvii.livenesslib.util.SensorUtil;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LivenessActivity
extends Activity
implements Camera.PreviewCallback,
Detector.DetectionListener,
TextureView.SurfaceTextureListener {
    private TextureView camerapreview;
    private FaceMask mFaceMask;
    private ProgressBar mProgressBar;
    private LinearLayout headViewLinear;
    private RelativeLayout rootView;
    private TextView timeOutText;
    private LinearLayout timeOutLinear;
    private Detector mDetector;
    private Handler mainHandler;
    private JSONObject jsonObject;
    private IMediaPlayer mIMediaPlayer;
    private ICamera mICamera;
    private IFile mIFile;
    private IDetection mIDetection;
    private DialogUtil mDialogUtil;
    private TextView promptText;
    private boolean isHandleStart;
    private Camera mCamera;
    private String mSession;
    private FaceQualityManager mFaceQualityManager;
    private SensorUtil sensorUtil;
    private Runnable mTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            LivenessActivity.this.initDetecteSession();
            if (LivenessActivity.this.mIDetection.getmDetectionSteps() != null) {
                LivenessActivity.this.changeType(LivenessActivity.this.mIDetection.getmDetectionSteps().get(0), 10L);
            }
        }
    };
    private int mFailFrame = 0;
    private int mCurStep = 0;
    private boolean mHasSurface = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.liveness_layout);
        this.init();
        this.initData();
    }

    private void init() {
        this.sensorUtil = new SensorUtil((Context)this);
        Screen.initialize((Context)this);
        this.mSession = ConUtil.getFormatterTime(System.currentTimeMillis());
        this.mainHandler = new Handler();
        this.mIMediaPlayer = new IMediaPlayer((Context)this);
        this.mIFile = new IFile();
        this.mDialogUtil = new DialogUtil(this);
        this.rootView = (RelativeLayout)this.findViewById(R.id.liveness_layout_rootRel);
        this.mIDetection = new IDetection((Context)this, (View)this.rootView);
        this.mFaceMask = (FaceMask)this.findViewById(R.id.liveness_layout_facemask);
        this.mICamera = new ICamera();
        this.promptText = (TextView)this.findViewById(R.id.liveness_layout_promptText);
        this.camerapreview = (TextureView)this.findViewById(R.id.liveness_layout_textureview);
        this.camerapreview.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.liveness_layout_progressbar);
        this.mProgressBar.setVisibility(4);
        this.headViewLinear = (LinearLayout)this.findViewById(R.id.liveness_layout_bottom_tips_head);
        this.headViewLinear.setVisibility(0);
        this.timeOutLinear = (LinearLayout)this.findViewById(R.id.detection_step_timeoutLinear);
        this.timeOutText = (TextView)this.findViewById(R.id.detection_step_timeout);
        this.mIDetection.viewsInit();
    }

    private void initData() {
        DetectionConfig config = new DetectionConfig.Builder().build();
        this.mDetector = new Detector((Context)this, config);
        boolean initSuccess = this.mDetector.init((Context)this, ConUtil.readModel((Context)this), "");
        if (!initSuccess) {
            this.mDialogUtil.showDialog("\u68c0\u6d4b\u5668\u521d\u59cb\u5316\u5931\u8d25");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                LivenessActivity.this.mIDetection.animationInit();
            }
        }).start();
    }

    protected void onResume() {
        super.onResume();
        this.isHandleStart = false;
        this.mCamera = this.mICamera.openCamera(this);
        if (this.mCamera != null) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)1, (Camera.CameraInfo)cameraInfo);
            this.mFaceMask.setFrontal(cameraInfo.facing == 1);
            RelativeLayout.LayoutParams layout_params = this.mICamera.getLayoutParam();
            this.camerapreview.setLayoutParams((ViewGroup.LayoutParams)layout_params);
            this.mFaceMask.setLayoutParams((ViewGroup.LayoutParams)layout_params);
            this.mFaceQualityManager = new FaceQualityManager(0.5f, 0.5f);
            this.mIDetection.setmCurShowIndex(-1);
        } else {
            this.mDialogUtil.showDialog("\u6253\u5f00\u524d\u7f6e\u6444\u50cf\u5934\u5931\u8d25");
        }
    }

    private void handleStart() {
        if (this.isHandleStart) {
            return;
        }
        this.isHandleStart = true;
        Animation animationIN = AnimationUtils.loadAnimation((Context)this, (int)R.anim.liveness_rightin);
        Animation animationOut = AnimationUtils.loadAnimation((Context)this, (int)R.anim.liveness_leftout);
        this.headViewLinear.startAnimation(animationOut);
        this.mIDetection.getmAnimViews()[0].setVisibility(0);
        this.mIDetection.getmAnimViews()[0].startAnimation(animationIN);
        animationOut.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                LivenessActivity.this.timeOutLinear.setVisibility(0);
            }
        });
        this.mainHandler.post(this.mTimeoutRunnable);
        try {
            this.jsonObject = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            this.jsonObject.put("imgs", (Object)jsonArray);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void initDetecteSession() {
        if (this.mICamera.getmCamera() == null) {
            return;
        }
        this.mProgressBar.setVisibility(4);
        this.mIDetection.detectionTypeInit();
        this.mCurStep = 0;
        this.mDetector.reset();
        this.mDetector.changeDetectionType(this.mIDetection.getmDetectionSteps().get(0));
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        Camera.Size previewsize = camera.getParameters().getPreviewSize();
        this.mDetector.doDetection(data, previewsize.width, previewsize.height, 360 - this.mICamera.getCameraAngle(this));
    }

    public Detector.DetectionType onDetectionSuccess(DetectionFrame validFrame) {
        this.mIMediaPlayer.reset();
        ++this.mCurStep;
        this.mFaceMask.setFaceInfo(null);
        if (this.mCurStep >= this.mIDetection.getmDetectionSteps().size()) {
            this.mProgressBar.setVisibility(0);
            this.handleResult(R.string.cert_creation_verify_success);
        } else {
            this.changeType(this.mIDetection.getmDetectionSteps().get(this.mCurStep), 10L);
        }
        return this.mCurStep >= this.mIDetection.getmDetectionSteps().size() ? Detector.DetectionType.DONE : this.mIDetection.getmDetectionSteps().get(this.mCurStep);
    }

    public void onDetectionFailed(final Detector.DetectionFailedType type) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LivenessActivity.this.mIFile.saveLog(LivenessActivity.this.mSession, type.name());
            }
        }).start();
        int resourceID = R.string.liveness_detection_failed;
        switch (type) {
            case ACTIONBLEND: {
                resourceID = R.string.liveness_detection_failed_action_blend;
                break;
            }
            case NOTVIDEO: {
                resourceID = R.string.liveness_detection_failed_not_video;
                break;
            }
            case TIMEOUT: {
                resourceID = R.string.liveness_detection_failed_timeout;
            }
        }
        this.handleResult(resourceID);
    }

    public void onFrameDetected(long timeout, DetectionFrame detectionFrame) {
        if (this.sensorUtil.isVertical()) {
            this.faceOcclusion(detectionFrame);
            this.handleNotPass(timeout);
            this.mFaceMask.setFaceInfo(detectionFrame);
        } else {
            this.promptText.setText((CharSequence)"\u8bf7\u7ad6\u76f4\u63e1\u7d27\u624b\u673a");
        }
    }

    private void faceOcclusion(DetectionFrame detectionFrame) {
        FaceInfo faceInfo;
        ++this.mFailFrame;
        if (detectionFrame != null && (faceInfo = detectionFrame.getFaceInfo()) != null) {
            if ((double)faceInfo.eyeLeftOcclusion > 0.5 || (double)faceInfo.eyeRightOcclusion > 0.5) {
                if (this.mFailFrame > 10) {
                    this.mFailFrame = 0;
                    this.promptText.setText((CharSequence)"\u8bf7\u52ff\u7528\u624b\u906e\u6321\u773c\u775b");
                }
                return;
            }
            if ((double)faceInfo.mouthOcclusion > 0.5) {
                if (this.mFailFrame > 10) {
                    this.mFailFrame = 0;
                    this.promptText.setText((CharSequence)"\u8bf7\u52ff\u7528\u624b\u906e\u6321\u5634\u5df4");
                }
                return;
            }
        }
        this.faceInfoChecker(this.mFaceQualityManager.feedFrame(detectionFrame));
    }

    public void faceInfoChecker(List<FaceQualityManager.FaceQualityErrorType> errorTypeList) {
        if (errorTypeList == null || errorTypeList.size() == 0) {
            this.handleStart();
        } else {
            String infoStr = "";
            FaceQualityManager.FaceQualityErrorType errorType = errorTypeList.get(0);
            if (errorType == FaceQualityManager.FaceQualityErrorType.FACE_NOT_FOUND) {
                infoStr = "\u8bf7\u8ba9\u6211\u770b\u5230\u60a8\u7684\u6b63\u8138";
            } else if (errorType == FaceQualityManager.FaceQualityErrorType.FACE_POS_DEVIATED) {
                infoStr = "\u8bf7\u8ba9\u6211\u770b\u5230\u60a8\u7684\u6b63\u8138";
            } else if (errorType == FaceQualityManager.FaceQualityErrorType.FACE_NONINTEGRITY) {
                infoStr = "\u8bf7\u8ba9\u6211\u770b\u5230\u60a8\u7684\u6b63\u8138";
            } else if (errorType == FaceQualityManager.FaceQualityErrorType.FACE_TOO_DARK) {
                infoStr = "\u8bf7\u8ba9\u5149\u7ebf\u518d\u4eae\u70b9";
            } else if (errorType == FaceQualityManager.FaceQualityErrorType.FACE_TOO_BRIGHT) {
                infoStr = "\u8bf7\u8ba9\u5149\u7ebf\u518d\u6697\u70b9";
            } else if (errorType == FaceQualityManager.FaceQualityErrorType.FACE_TOO_SMALL) {
                infoStr = "\u8bf7\u518d\u9760\u8fd1\u4e00\u4e9b";
            } else if (errorType == FaceQualityManager.FaceQualityErrorType.FACE_TOO_LARGE) {
                infoStr = "\u8bf7\u518d\u79bb\u8fdc\u4e00\u4e9b";
            } else if (errorType == FaceQualityManager.FaceQualityErrorType.FACE_TOO_BLURRY) {
                infoStr = "\u8bf7\u907f\u514d\u4fa7\u5149\u548c\u80cc\u5149";
            } else if (errorType == FaceQualityManager.FaceQualityErrorType.FACE_OUT_OF_RECT) {
                infoStr = "\u8bf7\u4fdd\u6301\u8138\u5728\u4eba\u8138\u6846\u4e2d";
            }
            if (this.mFailFrame > 10) {
                this.mFailFrame = 0;
                this.promptText.setText((CharSequence)infoStr);
            }
        }
    }

    private void handleResult(int resID) {
        String resultString = this.getResources().getString(resID);
        try {
            this.jsonObject.put("result", (Object)resultString);
            this.jsonObject.put("resultcode", resID);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Intent intent = new Intent();
        intent.putExtra("result", this.jsonObject.toString());
        IFile store = new IFile();
        store.saveOne(this.mDetector, "demo", this.jsonObject);
        boolean isSuccess = resultString.contains("\u6210\u529f");
        Intent broad = new Intent("com.xdja.result");
        broad.putExtra("result", isSuccess);
        broad.putExtra("type", "kuangshi");
        this.sendBroadcast(broad);
        this.finish();
    }

    public void changeType(Detector.DetectionType detectiontype, long timeout) {
        this.mIDetection.changeType(detectiontype, timeout);
        this.mFaceMask.setFaceInfo(null);
        if (this.mCurStep == 0) {
            this.mIMediaPlayer.doPlay(this.mIMediaPlayer.getSoundRes(detectiontype));
        } else {
            this.mIMediaPlayer.doPlay(R.raw.meglive_well_done);
            this.mIMediaPlayer.setOnCompletionListener(detectiontype);
        }
    }

    public void handleNotPass(final long remainTime) {
        if (remainTime > 0L) {
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    LivenessActivity.this.timeOutText.setText((CharSequence)(remainTime / 1000L + ""));
                }
            });
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.mHasSurface = true;
        this.doPreview();
        this.mDetector.setDetectionListener((Detector.DetectionListener)this);
        this.mICamera.actionDetect(this);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.mHasSurface = false;
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    private void doPreview() {
        if (!this.mHasSurface) {
            return;
        }
        this.mICamera.startPreview(this.camerapreview.getSurfaceTexture());
    }

    protected void onPause() {
        super.onPause();
        this.mainHandler.removeCallbacksAndMessages(null);
        this.mICamera.closeCamera();
        this.mCamera = null;
        this.mIMediaPlayer.close();
        this.finish();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mDetector != null) {
            this.mDetector.release();
        }
        this.mDialogUtil.onDestory();
        this.mIDetection.onDestroy();
        this.sensorUtil.release();
    }
}

