/*
 * Decompiled with CFR 0.152.
 */
package com.megvii.livenesslib.util;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.ExifInterface;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.util.Base64;
import android.view.inputmethod.InputMethodManager;
import android.widget.Toast;
import com.megvii.livenesslib.R;
import com.megvii.livenesslib.util.SharedUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

public class ConUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readModel(Context context) {
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int count = -1;
        try {
            inputStream = context.getResources().openRawResource(R.raw.model);
            while ((count = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, count);
            }
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String getUUIDString(Context mContext) {
        SharedUtil sharedUtil = new SharedUtil(mContext);
        String KEY_UUID = "key_uuid";
        String uuid = sharedUtil.getStringValueByKey(KEY_UUID);
        if (uuid != null) {
            return uuid;
        }
        uuid = ConUtil.getPhoneNumber(mContext);
        if (!(uuid != null && uuid.trim().length() != 0 || (uuid = ConUtil.getMacAddress(mContext)) != null && uuid.trim().length() != 0 || (uuid = ConUtil.getDeviceID(mContext)) != null && uuid.trim().length() != 0)) {
            uuid = UUID.randomUUID().toString();
            uuid = Base64.encodeToString((byte[])uuid.getBytes(), (int)0);
        }
        sharedUtil.saveStringValue(KEY_UUID, uuid);
        return uuid;
    }

    public static String getPhoneNumber(Context mContext) {
        TelephonyManager phoneMgr = (TelephonyManager)mContext.getSystemService("phone");
        return phoneMgr.getLine1Number();
    }

    public static String getDeviceID(Context mContext) {
        TelephonyManager tm = (TelephonyManager)mContext.getSystemService("phone");
        return tm.getDeviceId();
    }

    public static String getMacAddress(Context mContext) {
        WifiManager wifi = (WifiManager)mContext.getSystemService("wifi");
        WifiInfo info = wifi.getConnectionInfo();
        String address = info.getMacAddress();
        if (address != null && address.length() > 0) {
            address = address.replace(":", "");
        }
        return address;
    }

    public static byte[] getGrayscale(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        byte[] ret = new byte[bitmap.getWidth() * bitmap.getHeight()];
        for (int j = 0; j < bitmap.getHeight(); ++j) {
            for (int i = 0; i < bitmap.getWidth(); ++i) {
                int pixel = bitmap.getPixel(i, j);
                int red = (pixel & 0xFF0000) >> 16;
                int green = (pixel & 0xFF00) >> 8;
                int blue = pixel & 0xFF;
                ret[j * bitmap.getWidth() + i] = (byte)((299 * red + 587 * green + 114 * blue) / 1000);
            }
        }
        return ret;
    }

    public static int readPictureDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    public static Bitmap rotateImage(int angle, Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    private static Bitmap getBitMap(String fileSrc, int dstWidth) {
        if (dstWidth == -1) {
            return BitmapFactory.decodeFile((String)fileSrc);
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)fileSrc, (BitmapFactory.Options)options);
        options.inSampleSize = Math.max(1, (int)Math.max((double)options.outWidth / (double)dstWidth, (double)options.outHeight / (double)dstWidth));
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)fileSrc, (BitmapFactory.Options)options);
    }

    public static Bitmap getBitmapConsiderExif(String imagePath) {
        Bitmap tmpBitmap = ConUtil.getBitMap(imagePath, 800);
        if (tmpBitmap == null) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.postRotate((float)ConUtil.readPictureDegree(imagePath));
        tmpBitmap = Bitmap.createBitmap((Bitmap)tmpBitmap, (int)0, (int)0, (int)tmpBitmap.getWidth(), (int)tmpBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        tmpBitmap = tmpBitmap.copy(Bitmap.Config.ARGB_8888, true);
        int hight = tmpBitmap.getHeight() > tmpBitmap.getWidth() ? tmpBitmap.getHeight() : tmpBitmap.getWidth();
        float scale = (float)hight / 800.0f;
        if (scale > 1.0f) {
            tmpBitmap = Bitmap.createScaledBitmap((Bitmap)tmpBitmap, (int)((int)((float)tmpBitmap.getWidth() / scale)), (int)((int)((float)tmpBitmap.getHeight() / scale)), (boolean)false);
        }
        return tmpBitmap;
    }

    public static Bitmap cropImage(RectF rect, Bitmap bitmap) {
        float t;
        float l;
        float hight;
        float width = rect.width() * 2.0f;
        if (width > (float)bitmap.getWidth()) {
            width = bitmap.getWidth();
        }
        if ((hight = rect.height() * 2.0f) > (float)bitmap.getHeight()) {
            hight = bitmap.getHeight();
        }
        if ((l = rect.centerX() - width / 2.0f) < 0.0f) {
            l = 0.0f;
        }
        if ((t = rect.centerY() - hight / 2.0f) < 0.0f) {
            t = 0.0f;
        }
        if (l + width > (float)bitmap.getWidth()) {
            width = (float)bitmap.getWidth() - l;
        }
        if (t + hight > (float)bitmap.getHeight()) {
            hight = (float)bitmap.getHeight() - t;
        }
        return Bitmap.createBitmap((Bitmap)bitmap, (int)((int)l), (int)((int)t), (int)((int)width), (int)((int)hight));
    }

    public static Bitmap cutImage(RectF rect, String imagePath) {
        Bitmap bitmap = BitmapFactory.decodeFile((String)imagePath);
        return ConUtil.cropImage(rect, bitmap);
    }

    public static File getOutputMediaFile(Context mContext) {
        File mediaStorageDir = mContext.getExternalFilesDir("livenessDemo_campareimage");
        if (!mediaStorageDir.exists() && !mediaStorageDir.mkdirs()) {
            return null;
        }
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        File mediaFile = new File(mediaStorageDir.getPath() + File.separator + "IMG_" + timeStamp + ".jpg");
        return mediaFile;
    }

    public static void isGoneKeyBoard(Activity activity) {
        if (activity.getCurrentFocus() != null) {
            ((InputMethodManager)activity.getSystemService("input_method")).hideSoftInputFromWindow(activity.getCurrentFocus().getWindowToken(), 2);
        }
    }

    public static void showToast(Context context, String str) {
        if (context != null) {
            Toast toast = Toast.makeText((Context)context, (CharSequence)str, (int)0);
            toast.setGravity(48, 0, 30);
            toast.show();
        }
    }

    public static void showLongToast(Context context, String str) {
        if (context != null) {
            Toast toast = Toast.makeText((Context)context, (CharSequence)str, (int)1);
            toast.setGravity(48, 0, 30);
            toast.show();
        }
    }

    public static String getVersionName(Context context) {
        try {
            String versionName = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
            return versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap convert(Bitmap bitmap, boolean mIsFrontalCamera) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Bitmap newbBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas cv = new Canvas(newbBitmap);
        Matrix m = new Matrix();
        if (mIsFrontalCamera) {
            m.postScale(-1.0f, 1.0f);
        }
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)m, (boolean)true);
        cv.drawBitmap(bitmap2, new Rect(0, 0, bitmap2.getWidth(), bitmap2.getHeight()), new Rect(0, 0, w, h), null);
        return newbBitmap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String saveBitmap(Context mContext, Bitmap bitmaptosave) {
        if (bitmaptosave == null) {
            return null;
        }
        File mediaStorageDir = mContext.getExternalFilesDir("livenessDemo_image");
        if (!mediaStorageDir.exists() && !mediaStorageDir.mkdirs()) {
            return null;
        }
        String bitmapFileName = System.currentTimeMillis() + "";
        try (FileOutputStream fos = new FileOutputStream(mediaStorageDir + "/" + bitmapFileName);){
            boolean successful = bitmaptosave.compress(Bitmap.CompressFormat.JPEG, 75, (OutputStream)fos);
            if (successful) {
                String string3 = mediaStorageDir.getAbsolutePath() + "/" + bitmapFileName;
                return string3;
            }
            String string2 = null;
            return string2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFormatterTime(long time) {
        Date d = new Date(time);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        String data = formatter.format(d);
        return data;
    }
}

