/*
 * Decompiled with CFR 0.152.
 */
package com.megvii.livenesslib.util;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.widget.RelativeLayout;
import com.megvii.livenesslib.util.Screen;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ICamera {
    private Camera mCamera;
    private int cameraWidth;
    private int cameraHeight;
    private int cameraId = 1;

    public Camera getmCamera() {
        return this.mCamera;
    }

    public void setmCamera(Camera mCamera) {
        this.mCamera = mCamera;
    }

    public int getCameraWidth() {
        return this.cameraWidth;
    }

    public void setCameraWidth(int cameraWidth) {
        this.cameraWidth = cameraWidth;
    }

    public int getCameraHeight() {
        return this.cameraHeight;
    }

    public void setCameraHeight(int cameraHeight) {
        this.cameraHeight = cameraHeight;
    }

    public int getCameraId() {
        return this.cameraId;
    }

    public void setCameraId(int cameraId) {
        this.cameraId = cameraId;
    }

    public Camera openCamera(Activity activity) {
        try {
            this.mCamera = Camera.open((int)this.cameraId);
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)this.cameraId, (Camera.CameraInfo)cameraInfo);
            Camera.Parameters params = this.mCamera.getParameters();
            Camera.Size bestPreviewSize = this.calBestPreviewSize(this.mCamera.getParameters(), 640, 480);
            this.cameraWidth = bestPreviewSize.width;
            this.cameraHeight = bestPreviewSize.height;
            params.setPreviewSize(this.cameraWidth, this.cameraHeight);
            this.mCamera.setDisplayOrientation(this.getCameraAngle(activity));
            this.mCamera.setParameters(params);
            return this.mCamera;
        }
        catch (Exception e) {
            return null;
        }
    }

    public RelativeLayout.LayoutParams getLayoutParam() {
        Camera.Size previewSize = this.mCamera.getParameters().getPreviewSize();
        float scale = Math.min((float)Screen.getmWidth() * 1.0f / (float)previewSize.height, (float)Screen.getmHeight() * 1.0f / (float)previewSize.width);
        int layout_width = (int)(scale * (float)previewSize.height);
        int layout_height = (int)(scale * (float)previewSize.width);
        RelativeLayout.LayoutParams layout_params = new RelativeLayout.LayoutParams(layout_width, layout_height);
        return layout_params;
    }

    public void actionDetect(Camera.PreviewCallback mActivity) {
        if (this.mCamera != null) {
            this.mCamera.setPreviewCallback(mActivity);
        }
    }

    public void startPreview(SurfaceTexture surfaceTexture) {
        if (this.mCamera != null) {
            try {
                this.mCamera.setPreviewTexture(surfaceTexture);
                this.mCamera.startPreview();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void closeCamera() {
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
            this.mCamera.setPreviewCallback(null);
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    private Camera.Size calBestPreviewSize(Camera.Parameters camPara, final int width, final int height) {
        List allSupportedSize = camPara.getSupportedPreviewSizes();
        ArrayList<Camera.Size> widthLargerSize = new ArrayList<Camera.Size>();
        for (Camera.Size tmpSize : allSupportedSize) {
            if (tmpSize.width <= tmpSize.height) continue;
            widthLargerSize.add(tmpSize);
        }
        Collections.sort(widthLargerSize, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size lhs, Camera.Size rhs) {
                int off_one = Math.abs(lhs.width * lhs.height - width * height);
                int off_two = Math.abs(rhs.width * rhs.height - width * height);
                return off_one - off_two;
            }
        });
        return (Camera.Size)widthLargerSize.get(0);
    }

    public Camera getCameraSafely(int cameraId) {
        Camera camera = null;
        try {
            camera = Camera.open((int)cameraId);
        }
        catch (Exception e) {
            camera = null;
        }
        return camera;
    }

    public RelativeLayout.LayoutParams getParams(Camera camera) {
        Camera.Parameters camPara = camera.getParameters();
        Camera.Size bestPreviewSize = this.calBestPreviewSize(camPara, Screen.getmWidth(), Screen.getmHeight());
        this.cameraWidth = bestPreviewSize.width;
        this.cameraHeight = bestPreviewSize.height;
        camPara.setPreviewSize(this.cameraWidth, this.cameraHeight);
        camera.setParameters(camPara);
        float scale = bestPreviewSize.width / bestPreviewSize.height;
        RelativeLayout.LayoutParams layoutPara = new RelativeLayout.LayoutParams(bestPreviewSize.width, (int)((float)bestPreviewSize.width / scale));
        layoutPara.addRule(14);
        return layoutPara;
    }

    public Bitmap getBitMap(byte[] data, Camera camera, boolean mIsFrontalCamera) {
        int width = camera.getParameters().getPreviewSize().width;
        int height = camera.getParameters().getPreviewSize().height;
        YuvImage yuvImage = new YuvImage(data, camera.getParameters().getPreviewFormat(), width, height, null);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        yuvImage.compressToJpeg(new Rect(0, 0, width, height), 80, (OutputStream)byteArrayOutputStream);
        byte[] jpegData = byteArrayOutputStream.toByteArray();
        Bitmap tmpBitmap = BitmapFactory.decodeByteArray((byte[])jpegData, (int)0, (int)jpegData.length);
        Matrix matrix = new Matrix();
        matrix.reset();
        if (mIsFrontalCamera) {
            matrix.setRotate(-90.0f);
        } else {
            matrix.setRotate(90.0f);
        }
        tmpBitmap = Bitmap.createBitmap((Bitmap)tmpBitmap, (int)0, (int)0, (int)tmpBitmap.getWidth(), (int)tmpBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        tmpBitmap = tmpBitmap.copy(Bitmap.Config.ARGB_8888, true);
        int hight = tmpBitmap.getHeight() > tmpBitmap.getWidth() ? tmpBitmap.getHeight() : tmpBitmap.getWidth();
        float scale = (float)hight / 800.0f;
        if (scale > 1.0f) {
            tmpBitmap = Bitmap.createScaledBitmap((Bitmap)tmpBitmap, (int)((int)((float)tmpBitmap.getWidth() / scale)), (int)((int)((float)tmpBitmap.getHeight() / scale)), (boolean)false);
        }
        return tmpBitmap;
    }

    public int getCameraAngle(Activity activity) {
        int rotateAngle = 90;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.cameraId, (Camera.CameraInfo)info);
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            rotateAngle = (info.orientation + degrees) % 360;
            rotateAngle = (360 - rotateAngle) % 360;
        } else {
            rotateAngle = (info.orientation - degrees + 360) % 360;
        }
        return rotateAngle;
    }
}

