/*
 * Decompiled with CFR 0.152.
 */
package com.megvii.livenesslib.util;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import com.megvii.livenessdetection.Detector;
import com.megvii.livenesslib.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class IDetection {
    private View rootView;
    private Context mContext;
    private View[] mAnimViews;
    private int num = 3;
    private HashMap<Integer, Drawable> mDrawableCache;
    private int mCurShowIndex = -1;
    private ArrayList<Detector.DetectionType> mDetectionSteps;

    public View getRootView() {
        return this.rootView;
    }

    public void setRootView(View rootView) {
        this.rootView = rootView;
    }

    public Context getmContext() {
        return this.mContext;
    }

    public void setmContext(Context mContext) {
        this.mContext = mContext;
    }

    public View[] getmAnimViews() {
        return this.mAnimViews;
    }

    public void setmAnimViews(View[] mAnimViews) {
        this.mAnimViews = mAnimViews;
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public HashMap<Integer, Drawable> getmDrawableCache() {
        return this.mDrawableCache;
    }

    public void setmDrawableCache(HashMap<Integer, Drawable> mDrawableCache) {
        this.mDrawableCache = mDrawableCache;
    }

    public ArrayList<Detector.DetectionType> getmDetectionSteps() {
        return this.mDetectionSteps;
    }

    public void setmDetectionSteps(ArrayList<Detector.DetectionType> mDetectionSteps) {
        this.mDetectionSteps = mDetectionSteps;
    }

    public int getmCurShowIndex() {
        return this.mCurShowIndex;
    }

    public void setmCurShowIndex(int mCurShowIndex) {
        this.mCurShowIndex = mCurShowIndex;
    }

    public IDetection(Context mContext, View view) {
        this.mContext = mContext;
        this.rootView = view;
        this.mDrawableCache = new HashMap();
    }

    public void animationInit() {
        int[] reses;
        for (int oneRes : reses = new int[]{R.drawable.liveness_head_pitch, R.drawable.liveness_head_yaw, R.drawable.liveness_mouth_open_closed, R.drawable.liveness_eye_open_closed}) {
            this.mDrawableCache.put(oneRes, this.mContext.getResources().getDrawable(oneRes));
        }
    }

    public void viewsInit() {
        this.mAnimViews = new View[2];
        this.mAnimViews[0] = this.rootView.findViewById(R.id.liveness_layout_first_layout);
        this.mAnimViews[1] = this.rootView.findViewById(R.id.liveness_layout_second_layout);
        for (View tmpView : this.mAnimViews) {
            tmpView.setVisibility(4);
        }
    }

    public void changeType(Detector.DetectionType detectiontype, long timeout) {
        Animation animationIN = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.liveness_rightin);
        Animation animationOut = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.liveness_leftout);
        if (this.mCurShowIndex != -1) {
            this.mAnimViews[this.mCurShowIndex].setVisibility(4);
            this.mAnimViews[this.mCurShowIndex].setAnimation(animationOut);
        } else {
            this.mAnimViews[0].setVisibility(4);
            this.mAnimViews[0].startAnimation(animationOut);
        }
        this.mCurShowIndex = this.mCurShowIndex == -1 ? 0 : (this.mCurShowIndex == 0 ? 1 : 0);
        this.initAnim(detectiontype, this.mAnimViews[this.mCurShowIndex]);
        this.mAnimViews[this.mCurShowIndex].setVisibility(0);
        this.mAnimViews[this.mCurShowIndex].startAnimation(animationIN);
    }

    private void initAnim(Detector.DetectionType detectiontype, View layoutView) {
        ImageView tmpImageView = (ImageView)layoutView.findViewById(R.id.detection_step_image);
        tmpImageView.setImageDrawable(this.getDrawRes(detectiontype));
        ((AnimationDrawable)tmpImageView.getDrawable()).start();
        TextView detectionName = (TextView)layoutView.findViewById(R.id.detection_step_name);
        detectionName.setText((CharSequence)this.getDetectionName(detectiontype));
    }

    private Drawable getDrawRes(Detector.DetectionType detectionType) {
        int resID = -1;
        switch (detectionType) {
            case POS_PITCH: 
            case POS_PITCH_UP: 
            case POS_PITCH_DOWN: {
                resID = R.drawable.liveness_head_pitch;
                break;
            }
            case POS_YAW_LEFT: 
            case POS_YAW_RIGHT: 
            case POS_YAW: {
                resID = R.drawable.liveness_head_yaw;
                break;
            }
            case MOUTH: {
                resID = R.drawable.liveness_mouth_open_closed;
                break;
            }
            case BLINK: {
                resID = R.drawable.liveness_eye_open_closed;
            }
        }
        Drawable cachedDrawAble = this.mDrawableCache.get(resID);
        if (cachedDrawAble != null) {
            return cachedDrawAble;
        }
        Drawable drawable2 = this.mContext.getResources().getDrawable(resID);
        this.mDrawableCache.put(resID, drawable2);
        return drawable2;
    }

    private String getDetectionName(Detector.DetectionType detectionType) {
        String detectionName = null;
        switch (detectionType) {
            case POS_PITCH: {
                detectionName = "\u7f13\u6162\u70b9\u5934";
                break;
            }
            case POS_YAW: {
                detectionName = "\u5de6\u53f3\u6447\u5934";
                break;
            }
            case MOUTH: {
                detectionName = "\u5f20\u5634";
                break;
            }
            case BLINK: {
                detectionName = "\u7728\u773c";
                break;
            }
            case POS_YAW_LEFT: {
                detectionName = "\u5de6\u8f6c";
                break;
            }
            case POS_YAW_RIGHT: {
                detectionName = "\u53f3\u8f6c";
            }
        }
        return detectionName;
    }

    public void detectionTypeInit() {
        ArrayList<Detector.DetectionType> tmpTypes = new ArrayList<Detector.DetectionType>();
        tmpTypes.add(Detector.DetectionType.BLINK);
        tmpTypes.add(Detector.DetectionType.MOUTH);
        tmpTypes.add(Detector.DetectionType.POS_PITCH);
        tmpTypes.add(Detector.DetectionType.POS_YAW);
        Collections.shuffle(tmpTypes);
        this.mDetectionSteps = new ArrayList(this.num);
        for (int i = 0; i < this.num; ++i) {
            this.mDetectionSteps.add((Detector.DetectionType)tmpTypes.get(i));
        }
    }

    public void onDestroy() {
        this.rootView = null;
        this.mContext = null;
        if (this.mDrawableCache != null) {
            this.mDrawableCache.clear();
        }
    }
}

