/*
 * Decompiled with CFR 0.152.
 */
package com.megvii.livenesslib.util;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import com.megvii.livenessdetection.Detector;
import com.megvii.livenesslib.R;

public class IMediaPlayer {
    private MediaPlayer mMediaPlayer;
    private Context mContext;

    public IMediaPlayer(Context mContext) {
        this.mContext = mContext;
        this.mMediaPlayer = new MediaPlayer();
    }

    public void close() {
        this.mContext = null;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
    }

    public void reset() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
        }
    }

    public void setOnCompletionListener(final Detector.DetectionType detectiontype) {
        this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                IMediaPlayer.this.doPlay(IMediaPlayer.this.getSoundRes(detectiontype));
                IMediaPlayer.this.mMediaPlayer.setOnCompletionListener(null);
            }
        });
    }

    public void doPlay(int rawId) {
        if (this.mMediaPlayer == null) {
            return;
        }
        this.mMediaPlayer.reset();
        try {
            AssetFileDescriptor localAssetFileDescriptor = this.mContext.getResources().openRawResourceFd(rawId);
            this.mMediaPlayer.setDataSource(localAssetFileDescriptor.getFileDescriptor(), localAssetFileDescriptor.getStartOffset(), localAssetFileDescriptor.getLength());
            localAssetFileDescriptor.close();
            this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    IMediaPlayer.this.mMediaPlayer.start();
                }
            });
            this.mMediaPlayer.prepareAsync();
        }
        catch (Exception localIOException) {
            localIOException.printStackTrace();
        }
    }

    public int getSoundRes(Detector.DetectionType detectionType) {
        int resID = -1;
        switch (detectionType) {
            case POS_PITCH: {
                resID = R.raw.meglive_pitch_down;
                break;
            }
            case POS_YAW_LEFT: 
            case POS_YAW_RIGHT: 
            case POS_YAW: {
                resID = R.raw.meglive_yaw;
                break;
            }
            case MOUTH: {
                resID = R.raw.meglive_mouth_open;
                break;
            }
            case BLINK: {
                resID = R.raw.meglive_eye_blink;
            }
        }
        return resID;
    }
}

