/*
 * Decompiled with CFR 0.152.
 */
package com.megvii.livenesslib.util;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.Map;

public class SharedUtil {
    private static String TAG = "PushSharePreference";
    private Context ctx;
    private String FileName = "YueSuoPing";

    public SharedUtil(Context ctx) {
        this.ctx = ctx;
    }

    public void saveIntValue(String key, int value) {
        SharedPreferences sharePre = this.ctx.getSharedPreferences(this.FileName, 0);
        SharedPreferences.Editor editor = sharePre.edit();
        editor.putInt(key, value);
        editor.commit();
    }

    public void saveLongValue(String key, long value) {
        SharedPreferences sharePre = this.ctx.getSharedPreferences(this.FileName, 0);
        SharedPreferences.Editor editor = sharePre.edit();
        editor.putLong(key, value);
        editor.commit();
    }

    public void writeDownStartApplicationTime() {
        SharedPreferences sp = this.ctx.getSharedPreferences(this.FileName, 0);
        long now = System.currentTimeMillis();
        SharedPreferences.Editor editor = sp.edit();
        editor.putLong("nowtimekey", now);
        editor.commit();
    }

    public void saveBooleanValue(String key, boolean value) {
        SharedPreferences sharePre = this.ctx.getSharedPreferences(this.FileName, 0);
        SharedPreferences.Editor editor = sharePre.edit();
        editor.putBoolean(key, value);
        editor.commit();
    }

    public void removeSharePreferences(String key) {
        SharedPreferences sharePre = this.ctx.getSharedPreferences(this.FileName, 0);
        SharedPreferences.Editor editor = sharePre.edit();
        editor.remove(key);
        editor.commit();
    }

    public boolean contains(String key) {
        SharedPreferences sharePre = this.ctx.getSharedPreferences(this.FileName, 0);
        return sharePre.contains(key);
    }

    public Map<String, Object> getAllMap() {
        SharedPreferences sharePre = this.ctx.getSharedPreferences(this.FileName, 0);
        return sharePre.getAll();
    }

    public Integer getIntValueByKey(String key) {
        SharedPreferences sharePre = this.ctx.getSharedPreferences(this.FileName, 0);
        return sharePre.getInt(key, -1);
    }

    public Long getLongValueByKey(String key) {
        SharedPreferences sharePre = this.ctx.getSharedPreferences(this.FileName, 0);
        return sharePre.getLong(key, -1L);
    }

    public void saveStringValue(String key, String value) {
        SharedPreferences sharePre = this.ctx.getSharedPreferences(this.FileName, 0);
        SharedPreferences.Editor editor = sharePre.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public String getStringValueByKey(String key) {
        SharedPreferences sharePre = this.ctx.getSharedPreferences(this.FileName, 0);
        return sharePre.getString(key, null);
    }

    public Boolean getBooleanValueByKey(String key) {
        SharedPreferences sharePre = this.ctx.getSharedPreferences(this.FileName, 0);
        return sharePre.getBoolean(key, false);
    }

    public Integer getIntValueAndRemoveByKey(String key) {
        Integer value = this.getIntValueByKey(key);
        this.removeSharePreferences(key);
        return value;
    }

    public void setUserkey(String userkey) {
        this.saveStringValue("params_userkey", userkey);
    }

    public String getUserkey() {
        return this.getStringValueByKey("params_userkey");
    }
}

