/*
 * Decompiled with CFR 0.152.
 */
package com.megvii.livenesslib.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.megvii.livenesslib.R;

public class AutoRatioImageview
extends ImageView {
    private float mRatio = -1.0f;
    private int mPrefer = 0;

    public AutoRatioImageview(Context context) {
        super(context);
    }

    public AutoRatioImageview(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AutoRatioImageView);
        if (typedArray != null) {
            this.mRatio = typedArray.getFloat(R.styleable.AutoRatioImageView_ratio, -1.0f);
            this.mPrefer = typedArray.getInt(R.styleable.AutoRatioImageView_prefer, 0);
        }
    }

    public AutoRatioImageview(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int viewWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int viewHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mRatio < 0.0f) {
            if (this.getDrawable() == null) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            } else {
                int drawableWidth = this.getDrawable().getIntrinsicWidth();
                int drawableHeight = this.getDrawable().getIntrinsicHeight();
                if (this.mPrefer == 0) {
                    this.setMeasuredDimension(viewWidth, viewWidth * drawableHeight / drawableWidth);
                } else {
                    this.setMeasuredDimension(viewHeight * drawableWidth / drawableHeight, viewHeight);
                }
            }
        } else if (this.mPrefer == 0) {
            this.setMeasuredDimension(viewWidth, (int)((float)viewWidth * this.mRatio));
        } else {
            this.setMeasuredDimension((int)((float)viewHeight / this.mRatio), viewWidth);
        }
    }
}

