/*
 * Decompiled with CFR 0.152.
 */
package com.megvii.livenessdetection;

import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import com.megvii.livenessdetection.bean.FaceInfo;

public abstract class DetectionFrame {
    protected FaceInfo mFaceInfo;
    private FrameType a = FrameType.NONE;

    public abstract int getImageWidth();

    public abstract int getImageHeight();

    public abstract byte[] getYUVData();

    public FrameType getFrameType() {
        return this.a;
    }

    public void setFrameType(FrameType frameType) {
        this.a = frameType;
    }

    public FaceInfo getFaceInfo() {
        return this.mFaceInfo;
    }

    @Deprecated
    public float getWearGlass() {
        if (this.mFaceInfo == null) {
            return -1.0f;
        }
        return this.mFaceInfo.wearGlass;
    }

    public abstract int getRotation();

    public abstract byte[] getCroppedFaceImageData();

    public abstract byte[] getCroppedFaceImageData(int var1);

    public abstract byte[] getCroppedFaceImageData(Rect var1);

    public abstract byte[] getCroppedFaceImageData(int var1, Rect var2);

    public abstract byte[] getEncodedFaceImageData(int var1, int var2, Rect var3);

    public byte[] getEncodedFaceImageData(int n, Rect rect) {
        return this.getEncodedFaceImageData(n, -1, rect);
    }

    public byte[] getEncodedFaceImageData(int n, int n2) {
        return this.getEncodedFaceImageData(n, n2, null);
    }

    public byte[] getEncodedFaceImageData(int n) {
        return this.getEncodedFaceImageData(n, -1, null);
    }

    public abstract byte[] getImageData(Rect var1, boolean var2, int var3, int var4, boolean var5, boolean var6, int var7);

    @Deprecated
    public synchronized Rect getFaceSize() {
        if (this.mFaceInfo == null) {
            return null;
        }
        return this.mFaceInfo.faceSize;
    }

    @Deprecated
    public RectF getFacePos() {
        if (this.mFaceInfo == null) {
            return null;
        }
        return this.mFaceInfo.position;
    }

    @Deprecated
    public float getYawAngle() {
        if (this.mFaceInfo == null) {
            return -1.0f;
        }
        return this.mFaceInfo.yaw;
    }

    @Deprecated
    public float getPitchAngle() {
        if (this.mFaceInfo == null) {
            return -1.0f;
        }
        return this.mFaceInfo.pitch;
    }

    @Deprecated
    public float getGaussianBlur() {
        if (this.mFaceInfo == null) {
            return -1.0f;
        }
        return this.mFaceInfo.gaussianBlur;
    }

    @Deprecated
    public float getMotionBlur() {
        if (this.mFaceInfo == null) {
            return -1.0f;
        }
        return this.mFaceInfo.motionBlur;
    }

    @Deprecated
    public float getBrightness() {
        if (this.mFaceInfo == null) {
            return -1.0f;
        }
        return this.mFaceInfo.brightness;
    }

    @Deprecated
    public float getFaceQuality() {
        if (this.mFaceInfo == null) {
            return -1.0f;
        }
        return this.mFaceInfo.faceQuality;
    }

    public boolean hasFace() {
        return this.mFaceInfo != null;
    }

    @Deprecated
    public float getLeftEyeHwratio() {
        if (this.mFaceInfo == null) {
            return -1.0f;
        }
        return this.mFaceInfo.leftEyeHWRatio;
    }

    @Deprecated
    public float getRightEyeHwratio() {
        if (this.mFaceInfo == null) {
            return -1.0f;
        }
        return this.mFaceInfo.rightEyeHWRatio;
    }

    @Deprecated
    public float getMouthHwratio() {
        if (this.mFaceInfo == null) {
            return -1.0f;
        }
        return this.mFaceInfo.mouthHWRatio;
    }

    public static PointF get2DPoint(float f, float f2, float f3, float f4, float f5, float f6) {
        PointF pointF = new PointF();
        new PointF().x = 0.5f * (f6 < 0.0f ? f6 / f3 : -f6 / f4) + 0.5f;
        pointF.y = 0.5f * (f5 < 0.0f ? -f5 / f : f5 / f2) + 0.5f;
        return pointF;
    }

    public PointF get2DPoint(float f, float f2, float f3, float f4) {
        if (!this.hasFace()) {
            return null;
        }
        return DetectionFrame.get2DPoint(f, f2, f3, f4, this.mFaceInfo.smoothPitch, this.mFaceInfo.smoothYaw);
    }

    public PointF get2DPoint() {
        return this.get2DPoint(-0.17f, 0.17f, -0.22f, 0.22f);
    }

    public static boolean isValid2DPoint(PointF pointF) {
        return pointF.x >= 0.0f && pointF.x <= 1.0f && pointF.y >= 0.0f && pointF.y <= 1.0f;
    }

    public static enum FrameType {
        NONE,
        WAITINGNORMAL;

    }
}

