/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny;

import android.app.Application;
import android.graphics.Bitmap;
import android.net.Uri;
import android.text.TextUtils;
import com.zxy.tiny.common.ApplicationLoader;
import com.zxy.tiny.common.TinyException;
import com.zxy.tiny.core.CompressEngine;
import com.zxy.tiny.core.CompressKit;
import com.zxy.tiny.core.FileKit;
import java.io.File;
import java.io.InputStream;

public final class Tiny {
    private static volatile Tiny sInstance;
    private Application mApplication;
    private boolean isDebug = false;

    private Tiny() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Tiny getInstance() {
        if (sInstance != null) return sInstance;
        Class<Tiny> clazz = Tiny.class;
        synchronized (Tiny.class) {
            if (sInstance != null) return sInstance;
            sInstance = new Tiny();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public Tiny debug(boolean isDebug) {
        this.isDebug = isDebug;
        return this;
    }

    @Deprecated
    public void init(Application application) {
        if (application == null) {
            throw new TinyException.IllegalArgumentException("application can not be null!");
        }
        this.mApplication = application;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public Application getApplication() {
        if (this.mApplication == null) {
            this.mApplication = ApplicationLoader.get();
        }
        return this.mApplication;
    }

    public synchronized CompressEngine source(String filePath) {
        return new CompressEngine().source(TextUtils.isEmpty((CharSequence)filePath) ? new File("") : new File(filePath));
    }

    public synchronized CompressEngine source(File file) {
        return new CompressEngine().source(file);
    }

    public synchronized CompressEngine source(String[] filePaths) {
        return new CompressEngine().source(FileKit.wrap(filePaths));
    }

    public synchronized CompressEngine source(File[] files) {
        return new CompressEngine().source(files);
    }

    public synchronized CompressEngine source(Bitmap bitmap) {
        return new CompressEngine().source(bitmap);
    }

    public synchronized CompressEngine source(Bitmap[] bitmaps) {
        return new CompressEngine().source(bitmaps);
    }

    public synchronized CompressEngine source(Uri uri) {
        return new CompressEngine().source(uri);
    }

    public synchronized CompressEngine source(Uri[] uris) {
        return new CompressEngine().source(uris);
    }

    public synchronized CompressEngine source(byte[] bytes) {
        return new CompressEngine().source(bytes);
    }

    public synchronized CompressEngine source(InputStream is) {
        return new CompressEngine().source(is);
    }

    public synchronized CompressEngine source(int resId) {
        return new CompressEngine().source(resId);
    }

    public synchronized CompressEngine source(int[] resIds) {
        return new CompressEngine().source(resIds);
    }

    public synchronized boolean clearCompressDirectory() {
        File dir = FileKit.getDefaultFileCompressDirectory();
        try {
            return FileKit.clearDirectory(dir);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static class BatchFileCompressOptions
    extends FileCompressOptions {
        public String[] outfiles;
    }

    public static class FileCompressOptions
    extends BitmapCompressOptions {
        public int quality = 76;
        public boolean isKeepSampling = false;
        public float size;
        public String outfile;
        public boolean overrideSource = false;
    }

    public static class BitmapCompressOptions {
        public Bitmap.Config config = CompressKit.DEFAULT_CONFIG;
        public int width;
        public int height;
    }
}

