/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.callable;

import android.graphics.Bitmap;
import android.net.Uri;
import android.text.TextUtils;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.callable.BaseBitmapBatchCompressCallable;
import com.zxy.tiny.callable.BaseBitmapCompressCallable;
import com.zxy.tiny.common.Conditions;
import com.zxy.tiny.common.TinyException;
import com.zxy.tiny.common.UriUtil;
import com.zxy.tiny.core.BitmapCompressor;
import com.zxy.tiny.core.CompressKit;
import com.zxy.tiny.core.HttpUrlConnectionFetcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitmapCompressCallableTasks {
    private BitmapCompressCallableTasks() {
        throw new TinyException.UnsupportedOperationException("can not be a instance");
    }

    public static final class ResourceArrayAsBitmapCallable
    extends BaseBitmapBatchCompressCallable {
        private int[] mResIds;

        public ResourceArrayAsBitmapCallable(Tiny.BitmapCompressOptions options, int[] resIds) {
            super(options);
            this.mResIds = resIds;
        }

        @Override
        public Bitmap[] call() throws Exception {
            if (this.mResIds == null) {
                return null;
            }
            Bitmap[] result = new Bitmap[this.mResIds.length];
            for (int i = 0; i < this.mResIds.length; ++i) {
                result[i] = BitmapCompressor.compress(this.mResIds[i], this.mCompressOptions, true);
            }
            return result;
        }
    }

    public static final class UriArrayAsBitmapCallable
    extends BaseBitmapBatchCompressCallable {
        private Uri[] mUris;

        public UriArrayAsBitmapCallable(Tiny.BitmapCompressOptions options, Uri[] uris) {
            super(options);
            this.mUris = uris;
        }

        @Override
        public Bitmap[] call() throws Exception {
            if (this.mUris == null) {
                return null;
            }
            Bitmap[] result = new Bitmap[this.mUris.length];
            for (int i = 0; i < this.mUris.length; ++i) {
                Uri uri = this.mUris[i];
                result[i] = uri == null ? null : new UriAsBitmapCallable(this.mCompressOptions, this.mUris[i]).call();
            }
            return result;
        }
    }

    public static final class BitmapArrayAsBitmapCallable
    extends BaseBitmapBatchCompressCallable {
        private Bitmap[] mBitmaps;

        public BitmapArrayAsBitmapCallable(Tiny.BitmapCompressOptions options, Bitmap[] bitmaps) {
            super(options);
            this.mBitmaps = bitmaps;
        }

        @Override
        public Bitmap[] call() throws Exception {
            if (this.mBitmaps == null) {
                return null;
            }
            Bitmap[] result = new Bitmap[this.mBitmaps.length];
            for (int i = 0; i < this.mBitmaps.length; ++i) {
                Bitmap bitmap = this.mBitmaps[i];
                result[i] = BitmapCompressor.compress(bitmap, this.mCompressOptions, true);
            }
            return result;
        }
    }

    public static final class FileArrayAsBitmapCallable
    extends BaseBitmapBatchCompressCallable {
        private File[] mFiles;

        public FileArrayAsBitmapCallable(Tiny.BitmapCompressOptions options, File[] files) {
            super(options);
            this.mFiles = files;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Bitmap[] call() throws Exception {
            if (this.mFiles == null) {
                return null;
            }
            Bitmap[] result = new Bitmap[this.mFiles.length];
            for (int i = 0; i < this.mFiles.length; ++i) {
                File file = this.mFiles[i];
                if (file == null) {
                    result[i] = null;
                    continue;
                }
                Bitmap bitmap = null;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(file);
                    bitmap = BitmapCompressor.compress(CompressKit.transformToByteArray(fis), this.mCompressOptions, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                result[i] = bitmap;
            }
            return result;
        }
    }

    public static final class ResourceAsBitmapCallable
    extends BaseBitmapCompressCallable {
        private int mResId;

        public ResourceAsBitmapCallable(Tiny.BitmapCompressOptions options, int resId) {
            super(options);
            this.mResId = resId;
        }

        @Override
        public Bitmap call() throws Exception {
            return BitmapCompressor.compress(this.mResId, this.mCompressOptions, true);
        }
    }

    public static final class ByteArrayAsBitmapCallable
    extends BaseBitmapCompressCallable {
        private byte[] mBytes;

        public ByteArrayAsBitmapCallable(Tiny.BitmapCompressOptions options, byte[] bytes) {
            super(options);
            this.mBytes = bytes;
        }

        @Override
        public Bitmap call() throws Exception {
            return BitmapCompressor.compress(this.mBytes, this.mCompressOptions, true);
        }
    }

    public static final class UriAsBitmapCallable
    extends BaseBitmapCompressCallable {
        private Uri mUri;
        private Bitmap mResult = null;

        public UriAsBitmapCallable(Tiny.BitmapCompressOptions options, Uri uri) {
            super(options);
            this.mUri = uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Bitmap call() throws Exception {
            if (UriUtil.isNetworkUri(this.mUri)) {
                HttpUrlConnectionFetcher.fetch(this.mUri, new HttpUrlConnectionFetcher.ResponseCallback(){

                    @Override
                    public void callback(InputStream is) {
                        UriAsBitmapCallable.this.mResult = BitmapCompressor.compress(CompressKit.transformToByteArray(is), UriAsBitmapCallable.this.mCompressOptions, true);
                    }
                });
            } else if (UriUtil.isLocalContentUri(this.mUri) || UriUtil.isLocalFileUri(this.mUri)) {
                String filePath = UriUtil.getRealPathFromUri(this.mUri);
                if (TextUtils.isEmpty((CharSequence)filePath)) {
                    return null;
                }
                if (Conditions.fileIsExist(filePath) && Conditions.fileCanRead(filePath)) {
                    FileInputStream fis = null;
                    File file = new File(filePath);
                    try {
                        fis = new FileInputStream(file);
                        this.mResult = BitmapCompressor.compress(CompressKit.transformToByteArray(fis), this.mCompressOptions, true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return this.mResult;
        }
    }

    public static final class InputStreamAsBitmapCallable
    extends BaseBitmapCompressCallable {
        private InputStream mInputStream;

        public InputStreamAsBitmapCallable(Tiny.BitmapCompressOptions options, InputStream is) {
            super(options);
            this.mInputStream = is;
        }

        @Override
        public Bitmap call() throws Exception {
            return BitmapCompressor.compress(CompressKit.transformToByteArray(this.mInputStream), this.mCompressOptions, true);
        }
    }

    public static final class BitmapAsBitmapCallable
    extends BaseBitmapCompressCallable {
        private Bitmap mBitmap;

        public BitmapAsBitmapCallable(Tiny.BitmapCompressOptions options, Bitmap bitmap) {
            super(options);
            this.mBitmap = bitmap;
        }

        @Override
        public Bitmap call() throws Exception {
            return BitmapCompressor.compress(this.mBitmap, this.mCompressOptions, true);
        }
    }

    public static final class FileAsBitmapCallable
    extends BaseBitmapCompressCallable {
        private File mFile;

        public FileAsBitmapCallable(Tiny.BitmapCompressOptions options, File file) {
            super(options);
            this.mFile = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Bitmap call() throws Exception {
            Bitmap result = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.mFile);
                result = BitmapCompressor.compress(CompressKit.transformToByteArray(fis), this.mCompressOptions, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return result;
        }
    }
}

