/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.core;

import android.graphics.Bitmap;
import android.net.Uri;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.callable.BitmapCompressCallableTasks;
import com.zxy.tiny.callback.BitmapBatchCallback;
import com.zxy.tiny.callback.Callback;
import com.zxy.tiny.callback.DefaultCallbackDispatcher;
import com.zxy.tiny.core.CompressEngine;
import com.zxy.tiny.core.CompressExecutor;
import com.zxy.tiny.core.CompressFutureTask;
import com.zxy.tiny.core.CompressKit;
import java.io.File;

public class BitmapBatchCompressEngine
extends CompressEngine {
    private Tiny.BitmapCompressOptions mCompressOptions;

    public BitmapBatchCompressEngine withOptions(Tiny.BitmapCompressOptions options) {
        options.config = CompressKit.filterConfig(options.config);
        this.mCompressOptions = options;
        return this;
    }

    public void batchCompress(BitmapBatchCallback callback) {
        this.impl(callback);
    }

    private void impl(Callback callback) {
        if (this.mSource == null) {
            return;
        }
        if (this.mCompressOptions == null) {
            this.mCompressOptions = new Tiny.BitmapCompressOptions();
        }
        if (this.mSourceType == CompressEngine.SourceType.FILE_ARRAY) {
            File[] file = (File[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap[]>(new BitmapCompressCallableTasks.FileArrayAsBitmapCallable(this.mCompressOptions, file), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.BITMAP_ARRAY) {
            Bitmap[] bitmaps = (Bitmap[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap[]>(new BitmapCompressCallableTasks.BitmapArrayAsBitmapCallable(this.mCompressOptions, bitmaps), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.URI_ARRAY) {
            Uri[] uris = (Uri[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap[]>(new BitmapCompressCallableTasks.UriArrayAsBitmapCallable(this.mCompressOptions, uris), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.RES_ID_ARRAY) {
            int[] resIds = (int[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap[]>(new BitmapCompressCallableTasks.ResourceArrayAsBitmapCallable(this.mCompressOptions, resIds), new DefaultCallbackDispatcher(callback)));
        }
    }
}

