/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.core;

import android.graphics.Bitmap;
import android.net.Uri;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.callable.BitmapCompressCallableTasks;
import com.zxy.tiny.callback.BitmapCallback;
import com.zxy.tiny.callback.Callback;
import com.zxy.tiny.callback.DefaultCallbackDispatcher;
import com.zxy.tiny.core.CompressEngine;
import com.zxy.tiny.core.CompressExecutor;
import com.zxy.tiny.core.CompressFutureTask;
import com.zxy.tiny.core.CompressKit;
import java.io.File;
import java.io.InputStream;

public class BitmapCompressEngine
extends CompressEngine {
    private Tiny.BitmapCompressOptions mCompressOptions;

    public BitmapCompressEngine withOptions(Tiny.BitmapCompressOptions options) {
        options.config = CompressKit.filterConfig(options.config);
        this.mCompressOptions = options;
        return this;
    }

    public void compress(BitmapCallback callback) {
        this.impl(callback);
    }

    private void impl(Callback callback) {
        if (this.mSource == null) {
            return;
        }
        if (this.mCompressOptions == null) {
            this.mCompressOptions = new Tiny.BitmapCompressOptions();
        }
        if (this.mSourceType == CompressEngine.SourceType.FILE) {
            File file = (File)this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap>(new BitmapCompressCallableTasks.FileAsBitmapCallable(this.mCompressOptions, file), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.BITMAP) {
            Bitmap bitmap = (Bitmap)this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap>(new BitmapCompressCallableTasks.BitmapAsBitmapCallable(this.mCompressOptions, bitmap), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.URI) {
            Uri uri = (Uri)this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap>(new BitmapCompressCallableTasks.UriAsBitmapCallable(this.mCompressOptions, uri), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.BYTE_ARRAY) {
            byte[] bytes = (byte[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap>(new BitmapCompressCallableTasks.ByteArrayAsBitmapCallable(this.mCompressOptions, bytes), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.INPUT_STREAM) {
            InputStream is = (InputStream)this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap>(new BitmapCompressCallableTasks.InputStreamAsBitmapCallable(this.mCompressOptions, is), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.RES_ID) {
            int resId = (Integer)this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap>(new BitmapCompressCallableTasks.ResourceAsBitmapCallable(this.mCompressOptions, resId), new DefaultCallbackDispatcher(callback)));
        }
    }
}

