/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.core;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.util.Pair;
import android.util.TypedValue;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.core.BitmapKit;
import com.zxy.tiny.core.CompressKit;
import com.zxy.tiny.core.Degrees;
import java.io.IOException;
import java.io.InputStream;

public class BitmapCompressor {
    public static Bitmap compress(Bitmap bitmap, Tiny.BitmapCompressOptions options, boolean isViewMode) {
        Bitmap result;
        if (bitmap == null || bitmap.isRecycled()) {
            return null;
        }
        if (options == null) {
            options = new Tiny.BitmapCompressOptions();
        }
        int compressWidth = options.width;
        int compressHeight = options.height;
        Pair<Integer, Integer> screenPair = CompressKit.getDeviceScreenSizeInPixels();
        boolean hasCustomSize = false;
        if (compressWidth > 0 && compressHeight > 0) {
            hasCustomSize = true;
        }
        if (isViewMode) {
            if ((Integer)screenPair.second >= 1280 || (Integer)screenPair.first >= 1280) {
                int baseline = hasCustomSize ? Math.min(1280, Math.max(compressWidth, compressHeight)) : 1280;
                result = BitmapCompressor.matrixCompress(bitmap, baseline, false);
            } else {
                int baseline = hasCustomSize ? Math.min(1280, Math.max(compressWidth, compressHeight)) : (Integer)screenPair.second;
                result = BitmapCompressor.matrixCompress(bitmap, baseline, false);
            }
        } else {
            int baseline = hasCustomSize ? Math.min(1280, Math.max(compressWidth, compressHeight)) : 1280;
            result = BitmapCompressor.matrixCompress(bitmap, baseline, false);
        }
        if (result == null) {
            return null;
        }
        if (hasCustomSize) {
            result = BitmapCompressor.customCompress(result, compressWidth, compressHeight, false);
        }
        return result;
    }

    public static Bitmap compress(byte[] bytes, Tiny.BitmapCompressOptions options, boolean isViewMode) {
        Bitmap result;
        Pair<Integer, Integer> pair;
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (options == null) {
            options = new Tiny.BitmapCompressOptions();
        }
        if ((pair = BitmapKit.decodeDimensions(bytes)) == null) {
            return null;
        }
        int bitmapWidth = (Integer)pair.first;
        int bitmapHeight = (Integer)pair.second;
        int compressWidth = options.width;
        int compressHeight = options.height;
        Pair<Integer, Integer> screenPair = CompressKit.getDeviceScreenSizeInPixels();
        boolean hasCustomSize = false;
        if (compressWidth > 0 && compressHeight > 0) {
            hasCustomSize = true;
        }
        if (isViewMode) {
            if ((Integer)screenPair.second >= 1280 || (Integer)screenPair.first >= 1280) {
                int baseline = hasCustomSize ? Math.min(1280, Math.max(compressWidth, compressHeight)) : 1280;
                int sampleSize = BitmapCompressor.computeSampleSize(bitmapWidth, bitmapHeight, baseline);
                result = BitmapCompressor.matrixCompress(BitmapCompressor.sampleCompress(bytes, sampleSize, options), baseline, true);
            } else {
                int baseline = hasCustomSize ? Math.min(1280, Math.max(compressWidth, compressHeight)) : (Integer)screenPair.second;
                int sampleSize = BitmapCompressor.computeSampleSize(bitmapWidth, bitmapHeight, baseline);
                result = BitmapCompressor.matrixCompress(BitmapCompressor.sampleCompress(bytes, sampleSize, options), baseline, true);
            }
        } else {
            int baseline = hasCustomSize ? Math.min(1280, Math.max(compressWidth, compressHeight)) : 1280;
            int sampleSize = BitmapCompressor.computeSampleSize(bitmapWidth, bitmapHeight, baseline);
            result = BitmapCompressor.matrixCompress(BitmapCompressor.sampleCompress(bytes, sampleSize, options), baseline, true);
        }
        if (result == null) {
            return null;
        }
        if (hasCustomSize) {
            result = BitmapCompressor.customCompress(result, compressWidth, compressHeight, true);
        }
        return result;
    }

    public static Bitmap compress(int resId, Tiny.BitmapCompressOptions options, boolean isViewMode) {
        Bitmap result;
        Pair<Integer, Integer> pair;
        if (options == null) {
            options = new Tiny.BitmapCompressOptions();
        }
        if ((pair = BitmapKit.decodeDimensions(resId)) == null) {
            return null;
        }
        int bitmapWidth = (Integer)pair.first;
        int bitmapHeight = (Integer)pair.second;
        int compressWidth = options.width;
        int compressHeight = options.height;
        Pair<Integer, Integer> screenPair = CompressKit.getDeviceScreenSizeInPixels();
        boolean hasCustomSize = false;
        if (compressWidth > 0 && compressHeight > 0) {
            hasCustomSize = true;
        }
        if (isViewMode) {
            if ((Integer)screenPair.second >= 1280 || (Integer)screenPair.first >= 1280) {
                int baseline = hasCustomSize ? Math.min(1280, Math.max(compressWidth, compressHeight)) : 1280;
                int sampleSize = BitmapCompressor.computeSampleSize(bitmapWidth, bitmapHeight, baseline);
                result = BitmapCompressor.matrixCompress(BitmapCompressor.sampleCompress(resId, sampleSize, options), baseline, true);
            } else {
                int baseline = hasCustomSize ? Math.min(1280, Math.max(compressWidth, compressHeight)) : (Integer)screenPair.second;
                int sampleSize = BitmapCompressor.computeSampleSize(bitmapWidth, bitmapHeight, baseline);
                result = BitmapCompressor.matrixCompress(BitmapCompressor.sampleCompress(resId, sampleSize, options), baseline, true);
            }
        } else {
            int baseline = hasCustomSize ? Math.min(1280, Math.max(compressWidth, compressHeight)) : 1280;
            int sampleSize = BitmapCompressor.computeSampleSize(bitmapWidth, bitmapHeight, baseline);
            result = BitmapCompressor.matrixCompress(BitmapCompressor.sampleCompress(resId, sampleSize, options), baseline, true);
        }
        if (result == null) {
            return null;
        }
        if (hasCustomSize) {
            result = BitmapCompressor.customCompress(result, compressWidth, compressHeight, true);
        }
        return result;
    }

    private static Bitmap customCompress(Bitmap source, int targetWidth, int targetHeight, boolean recycle) {
        int dy;
        int dx;
        Bitmap result;
        float scale;
        float viewAspect;
        float bitmapHeight;
        Matrix matrix = new Matrix();
        float bitmapWidth = source.getWidth();
        float bitmapAspect = bitmapWidth / (bitmapHeight = (float)source.getHeight());
        if (bitmapAspect > (viewAspect = (float)targetWidth / (float)targetHeight)) {
            scale = (float)targetHeight / bitmapHeight;
            if (scale < 0.9f || scale > 1.0f) {
                matrix.setScale(scale, scale);
            } else {
                matrix = null;
            }
        } else {
            scale = (float)targetWidth / bitmapWidth;
            if (scale < 0.9f || scale > 1.0f) {
                matrix.setScale(scale, scale);
            } else {
                matrix = null;
            }
        }
        Bitmap temp = matrix != null ? Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true) : source;
        if (recycle && temp != source) {
            source.recycle();
        }
        if ((result = Bitmap.createBitmap((Bitmap)temp, (int)((dx = Math.max(0, temp.getWidth() - targetWidth)) / 2), (int)((dy = Math.max(0, temp.getHeight() - targetHeight)) / 2), (int)targetWidth, (int)targetHeight)) != temp && (recycle || temp != source)) {
            temp.recycle();
        }
        return result;
    }

    private static Bitmap sampleCompress(byte[] bytes, int sampleSize, Tiny.BitmapCompressOptions options) {
        BitmapFactory.Options decodeOptions = CompressKit.getDefaultDecodeOptions();
        decodeOptions.inPreferredConfig = options.config;
        decodeOptions.inSampleSize = sampleSize;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)decodeOptions);
        bitmap = Degrees.handle(bitmap, bytes);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap sampleCompress(int resId, int sampleSize, Tiny.BitmapCompressOptions options) {
        InputStream is = null;
        Resources resources = Tiny.getInstance().getApplication().getResources();
        try {
            is = resources.openRawResource(resId, new TypedValue());
            BitmapFactory.Options decodeOptions = CompressKit.getDefaultDecodeOptions();
            decodeOptions.inPreferredConfig = options.config;
            decodeOptions.inSampleSize = sampleSize;
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)decodeOptions);
            Bitmap bitmap2 = bitmap = Degrees.handle(bitmap, resId);
            return bitmap2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static Bitmap matrixCompress(Bitmap bitmap, int baseline, boolean recycle) {
        int bitmapHeight;
        if (bitmap == null) {
            return null;
        }
        int bitmapWidth = bitmap.getWidth();
        int maxValue = Math.max(bitmapWidth, bitmapHeight = bitmap.getHeight());
        if (maxValue > baseline) {
            Matrix matrix = new Matrix();
            float rate = (float)baseline / (float)maxValue;
            matrix.postScale(rate, rate);
            Bitmap result = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmapWidth, (int)bitmapHeight, (Matrix)matrix, (boolean)true);
            if (recycle) {
                bitmap.recycle();
                bitmap = null;
            }
            return result;
        }
        return bitmap;
    }

    private static int computeSampleSize(int width, int height, int baseline) {
        return BitmapCompressor.computeAccurateSampleSize(Math.max(width, height), baseline);
    }

    private static int computeAccurateSampleSize(int value, int baseline) {
        int result;
        int sampleSize = 1;
        int exponent = 1;
        while (value >= baseline * (result = (int)Math.pow(2.0, exponent))) {
            sampleSize = result;
            ++exponent;
        }
        return sampleSize;
    }
}

