/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.core;

import android.media.ExifInterface;
import com.zxy.tiny.common.Logger;
import com.zxy.tiny.common.TinyException;
import java.io.InputStream;
import java.util.Arrays;

public class ExifCompat {
    private static final byte[] JPEG_SIGNATURE = new byte[]{-1, -40, -1};
    private static final int JPEG_SIGNATURE_SIZE = 3;

    public static boolean isJpeg(InputStream is) {
        boolean isJpeg = false;
        if (is == null) {
            return isJpeg;
        }
        is.mark(3);
        byte[] signatureBytes = new byte[3];
        try {
            if (is.read(signatureBytes) != 3) {
                throw new TinyException.EOFException("no more data.");
            }
            isJpeg = Arrays.equals(JPEG_SIGNATURE, signatureBytes);
            is.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isJpeg;
    }

    public static boolean isJpeg(byte[] data) {
        boolean isJpeg = false;
        if (data == null || data.length < 3) {
            return isJpeg;
        }
        byte[] signatureBytes = new byte[]{data[0], data[1], data[2]};
        isJpeg = Arrays.equals(JPEG_SIGNATURE, signatureBytes);
        return isJpeg;
    }

    public static int getOrientation(byte[] jpeg) {
        if (jpeg == null) {
            return 0;
        }
        int offset = 0;
        int length = 0;
        while (offset + 3 < jpeg.length && (jpeg[offset++] & 0xFF) == 255) {
            int marker = jpeg[offset] & 0xFF;
            if (marker == 255) continue;
            ++offset;
            if (marker == 216 || marker == 1) continue;
            if (marker == 217 || marker == 218) break;
            length = ExifCompat.pack(jpeg, offset, 2, false);
            if (length < 2 || offset + length > jpeg.length) {
                Logger.e("Invalid length");
                return 0;
            }
            if (marker == 225 && length >= 8 && ExifCompat.pack(jpeg, offset + 2, 4, false) == 1165519206 && ExifCompat.pack(jpeg, offset + 6, 2, false) == 0) {
                offset += 8;
                length -= 8;
                break;
            }
            offset += length;
            length = 0;
        }
        if (length > 8) {
            int tag = ExifCompat.pack(jpeg, offset, 4, false);
            if (tag != 1229531648 && tag != 1296891946) {
                Logger.e("Invalid byte order");
                return 0;
            }
            boolean littleEndian = tag == 1229531648;
            int count = ExifCompat.pack(jpeg, offset + 4, 4, littleEndian) + 2;
            if (count < 10 || count > length) {
                Logger.e("Invalid offset");
                return 0;
            }
            offset += count;
            length -= count;
            count = ExifCompat.pack(jpeg, offset - 2, 2, littleEndian);
            while (count-- > 0 && length >= 12) {
                tag = ExifCompat.pack(jpeg, offset, 2, littleEndian);
                if (tag == 274) {
                    int orientation = ExifCompat.pack(jpeg, offset + 8, 2, littleEndian);
                    switch (orientation) {
                        case 1: {
                            return 0;
                        }
                        case 3: {
                            return 180;
                        }
                        case 6: {
                            return 90;
                        }
                        case 8: {
                            return 270;
                        }
                    }
                    Logger.e("Unsupported orientation");
                    return 0;
                }
                offset += 12;
                length -= 12;
            }
        }
        Logger.e("Orientation not found");
        return 0;
    }

    public static int getOrientation(String filepath) {
        int degree;
        int orientation = 1;
        try {
            ExifInterface exif = new ExifInterface(filepath);
            orientation = exif.getAttributeInt("Orientation", 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        switch (orientation) {
            case 1: {
                degree = 0;
                break;
            }
            case 6: {
                degree = 90;
                break;
            }
            case 3: {
                degree = 180;
                break;
            }
            case 8: {
                degree = 270;
                break;
            }
            default: {
                degree = 0;
            }
        }
        return degree;
    }

    private static int pack(byte[] bytes, int offset, int length, boolean littleEndian) {
        int step = 1;
        if (littleEndian) {
            offset += length - 1;
            step = -1;
        }
        int value = 0;
        while (length-- > 0) {
            value = value << 8 | bytes[offset] & 0xFF;
            offset += step;
        }
        return value;
    }
}

